/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.api.Connection;
import org.apache.dubbo.remoting.api.ConnectionManager;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class MultiplexProtocolConnectionManager
implements ConnectionManager {
    public static final String NAME = "multiple";
    private final ConcurrentMap<String, ConnectionManager> protocols = new ConcurrentHashMap<String, ConnectionManager>();
    private FrameworkModel frameworkModel;

    public MultiplexProtocolConnectionManager(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public Connection connect(URL url) {
        ConnectionManager manager = this.protocols.computeIfAbsent(url.getProtocol(), this::createSingleProtocolConnectionManager);
        return manager.connect(url);
    }

    @Override
    public void forEachConnection(Consumer<Connection> connectionConsumer) {
        this.protocols.values().forEach(p -> p.forEachConnection(connectionConsumer));
    }

    private ConnectionManager createSingleProtocolConnectionManager(String protocol) {
        return this.frameworkModel.getExtensionLoader(ConnectionManager.class).getExtension("single");
    }
}

