/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.event.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.RetryServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class ServiceInstancesChangedListener {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInstancesChangedListener.class);
    protected final Set<String> serviceNames;
    protected final ServiceDiscovery serviceDiscovery;
    protected URL url;
    protected Map<String, Set<NotifyListenerWithKey>> listeners;
    protected AtomicBoolean destroyed = new AtomicBoolean(false);
    protected Map<String, List<ServiceInstance>> allInstances;
    protected Map<String, Object> serviceUrls;
    private volatile long lastRefreshTime;
    private final Semaphore retryPermission;
    private volatile ScheduledFuture<?> retryFuture;
    private final ScheduledExecutorService scheduler;
    private volatile boolean hasEmptyMetadata;
    private static final String[] SUPPORTED_PROTOCOLS = new String[]{"dubbo", "tri", "rest"};
    public static final String CONSUMER_PROTOCOL_SUFFIX = ":consumer";

    public ServiceInstancesChangedListener(Set<String> serviceNames, ServiceDiscovery serviceDiscovery) {
        this.serviceNames = serviceNames;
        this.serviceDiscovery = serviceDiscovery;
        this.listeners = new ConcurrentHashMap<String, Set<NotifyListenerWithKey>>();
        this.allInstances = new HashMap<String, List<ServiceInstance>>();
        this.serviceUrls = new HashMap<String, Object>();
        this.retryPermission = new Semaphore(1);
        this.scheduler = ScopeModelUtil.getApplicationModel(serviceDiscovery == null || serviceDiscovery.getUrl() == null ? null : serviceDiscovery.getUrl().getScopeModel()).getBeanFactory().getBean(FrameworkExecutorRepository.class).getMetadataRetryExecutor();
    }

    public void onEvent(ServiceInstancesChangedEvent event) {
        if (this.destroyed.get() || !this.accept(event) || this.isRetryAndExpired(event)) {
            return;
        }
        this.doOnEvent(event);
    }

    private synchronized void doOnEvent(ServiceInstancesChangedEvent event) {
        if (this.destroyed.get() || !this.accept(event) || this.isRetryAndExpired(event)) {
            return;
        }
        this.refreshInstance(event);
        if (logger.isDebugEnabled()) {
            logger.debug(event.getServiceInstances().toString());
        }
        HashMap<String, List<ServiceInstance>> revisionToInstances = new HashMap<String, List<ServiceInstance>>();
        HashMap<String, Map<String, Set<String>>> localServiceToRevisions = new HashMap<String, Map<String, Set<String>>>();
        for (Map.Entry<String, List<ServiceInstance>> entry : this.allInstances.entrySet()) {
            List<ServiceInstance> instances = entry.getValue();
            for (ServiceInstance serviceInstance : instances) {
                String revision = ServiceInstanceMetadataUtils.getExportedServicesRevision(serviceInstance);
                if (revision == null || "0".equals(revision)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Find instance without valid service metadata: " + serviceInstance.getAddress());
                    continue;
                }
                List subInstances = revisionToInstances.computeIfAbsent(revision, r -> new LinkedList());
                subInstances.add(serviceInstance);
            }
        }
        for (Map.Entry<String, List<ServiceInstance>> entry : revisionToInstances.entrySet()) {
            String revision = entry.getKey();
            List<ServiceInstance> subInstances = entry.getValue();
            MetadataInfo metadataInfo = this.serviceDiscovery.getRemoteMetadata(revision, subInstances);
            this.parseMetadata(revision, metadataInfo, localServiceToRevisions);
            for (ServiceInstance tmpInstance : subInstances) {
                MetadataInfo originMetadata = tmpInstance.getServiceMetadata();
                if (originMetadata != null && Objects.equals(originMetadata.getRevision(), metadataInfo.getRevision())) continue;
                tmpInstance.setServiceMetadata(metadataInfo);
            }
        }
        int emptyNum = this.hasEmptyMetadata(revisionToInstances);
        if (emptyNum != 0) {
            this.hasEmptyMetadata = true;
            if (this.retryPermission.tryAcquire()) {
                if (this.retryFuture != null && !this.retryFuture.isDone()) {
                    this.retryFuture.cancel(true);
                }
                try {
                    this.retryFuture = this.scheduler.schedule(new AddressRefreshRetryTask(this.retryPermission, event.getServiceName()), 10000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    logger.error("Error submitting async retry task.");
                }
                logger.warn("Address refresh try task submitted");
            }
            if (emptyNum == revisionToInstances.size()) {
                logger.error("Address refresh failed because of Metadata Server failure, wait for retry or new address refresh event.");
                return;
            }
        }
        this.hasEmptyMetadata = false;
        HashMap hashMap = new HashMap();
        HashMap<String, Object> newServiceUrls = new HashMap<String, Object>();
        for (Map.Entry entry : localServiceToRevisions.entrySet()) {
            String protocol = (String)entry.getKey();
            ((Map)entry.getValue()).forEach((protocolServiceKey, revisions) -> {
                Map revisionsToUrls = protocolRevisionsToUrls.computeIfAbsent(protocol, k -> new HashMap());
                Object urls = revisionsToUrls.get(revisions);
                if (urls == null) {
                    urls = this.getServiceUrlsCache((Map<String, List<ServiceInstance>>)revisionToInstances, (Set<String>)revisions, protocol);
                    revisionsToUrls.put(revisions, urls);
                }
                newServiceUrls.put((String)protocolServiceKey, urls);
            });
        }
        this.serviceUrls = newServiceUrls;
        this.notifyAddressChanged();
    }

    public synchronized void addListenerAndNotify(String serviceKey, NotifyListener listener) {
        List<Object> urls;
        if (this.destroyed.get()) {
            return;
        }
        Set notifyListeners = this.listeners.computeIfAbsent(serviceKey, _k -> new ConcurrentHashSet());
        Set<String> protocolServiceKeysToConsume = this.getProtocolServiceKeyList(serviceKey, listener);
        NotifyListenerWithKey listenerWithKey = new NotifyListenerWithKey(serviceKey, protocolServiceKeysToConsume, listener);
        notifyListeners.add(listenerWithKey);
        if (protocolServiceKeysToConsume.size() > 1) {
            urls = new ArrayList();
            for (String protocolServiceKey : protocolServiceKeysToConsume) {
                List<URL> urlsOfProtocol = this.getAddresses(protocolServiceKey, listener.getConsumerUrl());
                if (!CollectionUtils.isNotEmpty(urlsOfProtocol)) continue;
                logger.info(String.format("Found %s urls of protocol service key %s ", urlsOfProtocol.size(), protocolServiceKey));
                urls.addAll(urlsOfProtocol);
            }
        } else {
            urls = this.getAddresses(protocolServiceKeysToConsume.iterator().next(), listener.getConsumerUrl());
        }
        if (CollectionUtils.isNotEmpty(urls)) {
            logger.info(String.format("Notify serviceKey: %s, listener: %s with %s urls on subscription", serviceKey, listener, urls.size()));
            listener.notify(urls);
        }
    }

    public synchronized void removeListener(String serviceKey, NotifyListener notifyListener) {
        if (this.destroyed.get()) {
            return;
        }
        Set<NotifyListenerWithKey> notifyListeners = this.listeners.get(serviceKey);
        if (notifyListeners != null) {
            NotifyListenerWithKey listenerWithKey = new NotifyListenerWithKey(serviceKey, notifyListener);
            notifyListeners.remove(listenerWithKey);
            if (notifyListeners.size() == 0) {
                this.listeners.remove(serviceKey);
            }
        }
    }

    public boolean hasListeners() {
        return CollectionUtils.isNotEmptyMap(this.listeners);
    }

    public final Set<String> getServiceNames() {
        return this.serviceNames;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public Map<String, List<ServiceInstance>> getAllInstances() {
        return this.allInstances;
    }

    private boolean accept(ServiceInstancesChangedEvent event) {
        return this.serviceNames.contains(event.getServiceName());
    }

    protected boolean isRetryAndExpired(ServiceInstancesChangedEvent event) {
        if (event instanceof RetryServiceInstancesChangedEvent) {
            RetryServiceInstancesChangedEvent retryEvent = (RetryServiceInstancesChangedEvent)event;
            logger.warn("Received address refresh retry event, " + retryEvent.getFailureRecordTime());
            if (retryEvent.getFailureRecordTime() < this.lastRefreshTime && !this.hasEmptyMetadata) {
                logger.warn("Ignore retry event, event time: " + retryEvent.getFailureRecordTime() + ", last refresh time: " + this.lastRefreshTime);
                return true;
            }
            logger.warn("Retrying address notification...");
        }
        return false;
    }

    private void refreshInstance(ServiceInstancesChangedEvent event) {
        if (event instanceof RetryServiceInstancesChangedEvent) {
            return;
        }
        String appName = event.getServiceName();
        List<ServiceInstance> appInstances = event.getServiceInstances();
        logger.info("Received instance notification, serviceName: " + appName + ", instances: " + appInstances.size());
        this.allInstances.put(appName, appInstances);
        this.lastRefreshTime = System.currentTimeMillis();
    }

    protected int hasEmptyMetadata(Map<String, List<ServiceInstance>> revisionToInstances) {
        if (revisionToInstances == null) {
            return 0;
        }
        StringBuilder builder = new StringBuilder();
        int emptyMetadataNum = 0;
        for (Map.Entry<String, List<ServiceInstance>> entry : revisionToInstances.entrySet()) {
            DefaultServiceInstance serviceInstance = (DefaultServiceInstance)entry.getValue().get(0);
            if (serviceInstance == null || serviceInstance.getServiceMetadata() == MetadataInfo.EMPTY) {
                ++emptyMetadataNum;
            }
            builder.append(entry.getKey());
            builder.append(' ');
        }
        if (emptyMetadataNum > 0) {
            builder.insert(0, emptyMetadataNum + "/" + revisionToInstances.size() + " revisions failed to get metadata from remote: ");
            logger.error(builder.toString());
        } else {
            builder.insert(0, revisionToInstances.size() + " unique working revisions: ");
            logger.info(builder.toString());
        }
        return emptyMetadataNum;
    }

    protected Map<String, Map<String, Set<String>>> parseMetadata(String revision, MetadataInfo metadata, Map<String, Map<String, Set<String>>> localServiceToRevisions) {
        Map<String, MetadataInfo.ServiceInfo> serviceInfos = metadata.getServices();
        for (Map.Entry<String, MetadataInfo.ServiceInfo> entry : serviceInfos.entrySet()) {
            String protocol = entry.getValue().getProtocol();
            String protocolServiceKey = entry.getValue().getMatchKey();
            Map map = localServiceToRevisions.computeIfAbsent(protocol, _p -> new HashMap());
            Set set = map.computeIfAbsent(protocolServiceKey, _k -> new TreeSet());
            set.add(revision);
        }
        return localServiceToRevisions;
    }

    protected Object getServiceUrlsCache(Map<String, List<ServiceInstance>> revisionToInstances, Set<String> revisions, String protocol) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String r : revisions) {
            for (ServiceInstance i : revisionToInstances.get(r)) {
                DefaultServiceInstance.Endpoint endpoint;
                if (ServiceInstanceMetadataUtils.hasEndpoints(i) && (endpoint = ServiceInstanceMetadataUtils.getEndpoint(i, protocol)) != null && endpoint.getPort() != i.getPort()) {
                    urls.add(((DefaultServiceInstance)i).copyFrom(endpoint).toURL(endpoint.getProtocol()));
                    continue;
                }
                urls.add(i.toURL(protocol).setScopeModel(i.getApplicationModel()));
            }
        }
        return urls;
    }

    protected List<URL> getAddresses(String serviceProtocolKey, URL consumerURL) {
        return (List)this.serviceUrls.get(serviceProtocolKey);
    }

    protected void notifyAddressChanged() {
        this.listeners.forEach((serviceKey, listenerSet) -> {
            for (NotifyListenerWithKey listenerWithKey : listenerSet) {
                NotifyListener notifyListener = listenerWithKey.getNotifyListener();
                if (listenerWithKey.getProtocolServiceKeys().size() == 1) {
                    String protocolServiceKey = listenerWithKey.getProtocolServiceKeys().iterator().next();
                    List<URL> urls = this.toUrlsWithEmpty(this.getAddresses(protocolServiceKey, notifyListener.getConsumerUrl()));
                    logger.info("Notify service " + protocolServiceKey + " with urls " + urls.size());
                    notifyListener.notify(urls);
                    continue;
                }
                List<URL> urls = new ArrayList<URL>();
                int effectiveProtocolNum = 0;
                for (String protocolServiceKey : listenerWithKey.getProtocolServiceKeys()) {
                    List<URL> tmpUrls = this.getAddresses(protocolServiceKey, notifyListener.getConsumerUrl());
                    if (!CollectionUtils.isNotEmpty(tmpUrls)) continue;
                    logger.info("Found  " + urls.size() + " urls of protocol service key " + protocolServiceKey);
                    ++effectiveProtocolNum;
                    urls.addAll(tmpUrls);
                }
                logger.info("Notify service " + serviceKey + " with " + urls.size() + " urls from " + effectiveProtocolNum + " different protocols");
                urls = this.toUrlsWithEmpty(urls);
                notifyListener.notify(urls);
            }
        });
    }

    protected List<URL> toUrlsWithEmpty(List<URL> urls) {
        boolean emptyProtectionEnabled = this.serviceDiscovery.getUrl().getParameter("enable-empty-protection", true);
        if (!emptyProtectionEnabled && urls == null) {
            urls = new ArrayList<URL>();
        } else if (emptyProtectionEnabled && urls == null) {
            urls = Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(urls) && !emptyProtectionEnabled) {
            ServiceConfigURL empty = URLBuilder.from(this.url).setProtocol("empty").build();
            urls.add(empty);
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.destroyed.compareAndSet(false, true)) {
            logger.info("Destroying instance listener of  " + this.getServiceNames());
            this.serviceDiscovery.removeServiceInstancesChangedListener(this);
            ServiceInstancesChangedListener serviceInstancesChangedListener = this;
            synchronized (serviceInstancesChangedListener) {
                this.allInstances.clear();
                this.serviceUrls.clear();
                this.listeners.clear();
                if (this.retryFuture != null && !this.retryFuture.isDone()) {
                    this.retryFuture.cancel(true);
                }
            }
        }
    }

    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceInstancesChangedListener)) {
            return false;
        }
        ServiceInstancesChangedListener that = (ServiceInstancesChangedListener)o;
        return Objects.equals(this.getServiceNames(), that.getServiceNames());
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.getServiceNames());
    }

    protected Set<String> getProtocolServiceKeyList(String serviceKey, NotifyListener listener) {
        if (StringUtils.isEmpty(serviceKey)) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        String protocol = listener.getConsumerUrl().getParameter("protocol");
        if (serviceKey.endsWith(CONSUMER_PROTOCOL_SUFFIX)) {
            serviceKey = serviceKey.substring(0, serviceKey.indexOf(CONSUMER_PROTOCOL_SUFFIX));
        }
        if (StringUtils.isNotEmpty(protocol)) {
            int protocolIndex = serviceKey.indexOf(":" + protocol);
            if (protocol.contains(",") && protocolIndex != -1) {
                String[] specifiedProtocols;
                serviceKey = serviceKey.substring(0, protocolIndex);
                for (String specifiedProtocol : specifiedProtocols = protocol.split(",")) {
                    result.add(serviceKey + ":" + specifiedProtocol);
                }
            } else {
                result.add(serviceKey);
            }
        } else {
            for (String supportedProtocol : SUPPORTED_PROTOCOLS) {
                result.add(serviceKey + ":" + supportedProtocol);
            }
        }
        return result;
    }

    public static class NotifyListenerWithKey {
        private final String serviceKey;
        private final Set<String> protocolServiceKeys;
        private final NotifyListener notifyListener;

        public NotifyListenerWithKey(String protocolServiceKey, Set<String> protocolServiceKeys, NotifyListener notifyListener) {
            this.serviceKey = protocolServiceKey;
            this.protocolServiceKeys = protocolServiceKeys == null ? new ConcurrentHashSet() : protocolServiceKeys;
            this.notifyListener = notifyListener;
        }

        public NotifyListenerWithKey(String protocolServiceKey, NotifyListener notifyListener) {
            this(protocolServiceKey, null, notifyListener);
        }

        public String getServiceKey() {
            return this.serviceKey;
        }

        public Set<String> getProtocolServiceKeys() {
            return this.protocolServiceKeys;
        }

        public NotifyListener getNotifyListener() {
            return this.notifyListener;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotifyListenerWithKey that = (NotifyListenerWithKey)o;
            return Objects.equals(this.serviceKey, that.serviceKey) && Objects.equals(this.notifyListener, that.notifyListener);
        }

        public int hashCode() {
            return Objects.hash(this.serviceKey, this.notifyListener);
        }
    }

    protected class AddressRefreshRetryTask
    implements Runnable {
        private final RetryServiceInstancesChangedEvent retryEvent;
        private final Semaphore retryPermission;

        public AddressRefreshRetryTask(Semaphore semaphore, String serviceName) {
            this.retryEvent = new RetryServiceInstancesChangedEvent(serviceName);
            this.retryPermission = semaphore;
        }

        @Override
        public void run() {
            this.retryPermission.release();
            ServiceInstancesChangedListener.this.onEvent(this.retryEvent);
        }
    }
}

