/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public abstract class AbstractReferenceConfig
extends AbstractInterfaceConfig {
    private static final long serialVersionUID = -2786526984373031126L;
    protected Boolean check;
    protected Boolean init;
    protected String generic;
    protected Boolean injvm;
    protected Boolean lazy;
    protected String reconnect;
    protected Boolean sticky;
    protected Boolean stubevent;
    protected String providedBy;
    protected String router;
    @Deprecated
    private Boolean referAsync;
    protected String client;
    protected String protocol;

    public AbstractReferenceConfig() {
    }

    public AbstractReferenceConfig(ModuleModel moduleModel) {
        super(moduleModel);
    }

    @Override
    protected void checkDefault() {
        super.checkDefault();
        if (this.sticky == null) {
            this.sticky = false;
        }
    }

    public Boolean isCheck() {
        return this.check;
    }

    public void setCheck(Boolean check) {
        this.check = check;
    }

    public Boolean isInit() {
        return this.init;
    }

    public void setInit(Boolean init) {
        this.init = init;
    }

    @Deprecated
    @Parameter(excluded=true, attribute=false)
    public Boolean isGeneric() {
        return this.generic != null ? Boolean.valueOf(ProtocolUtils.isGeneric(this.generic)) : null;
    }

    @Deprecated
    public void setGeneric(Boolean generic) {
        if (generic != null) {
            this.generic = generic.toString();
        }
    }

    public String getGeneric() {
        return this.generic;
    }

    public void setGeneric(String generic) {
        if (StringUtils.isEmpty(generic)) {
            return;
        }
        if (!ProtocolUtils.isValidGenericValue(generic)) {
            throw new IllegalArgumentException("Unsupported generic type " + generic);
        }
        this.generic = generic;
    }

    @Deprecated
    public Boolean isInjvm() {
        return this.injvm;
    }

    @Deprecated
    public void setInjvm(Boolean injvm) {
        this.injvm = injvm;
    }

    @Override
    @Parameter(key="reference.filter", append=true)
    public String getFilter() {
        return super.getFilter();
    }

    @Override
    @Parameter(key="invoker.listener", append=true)
    public String getListener() {
        return super.getListener();
    }

    @Override
    public void setListener(String listener) {
        super.setListener(listener);
    }

    public Boolean getLazy() {
        return this.lazy;
    }

    public void setLazy(Boolean lazy) {
        this.lazy = lazy;
    }

    @Override
    public void setOnconnect(String onconnect) {
        if (onconnect != null && onconnect.length() > 0) {
            this.stubevent = true;
        }
        super.setOnconnect(onconnect);
    }

    @Override
    public void setOndisconnect(String ondisconnect) {
        if (ondisconnect != null && ondisconnect.length() > 0) {
            this.stubevent = true;
        }
        super.setOndisconnect(ondisconnect);
    }

    @Parameter(key="dubbo.stub.event")
    public Boolean getStubevent() {
        return this.stubevent;
    }

    public String getReconnect() {
        return this.reconnect;
    }

    public void setReconnect(String reconnect) {
        this.reconnect = reconnect;
    }

    public Boolean getSticky() {
        return this.sticky;
    }

    public void setSticky(Boolean sticky) {
        this.sticky = sticky;
    }

    @Parameter(key="provided-by")
    public String getProvidedBy() {
        return this.providedBy;
    }

    public void setProvidedBy(String providedBy) {
        this.providedBy = providedBy;
    }

    @Parameter(key="router", append=true)
    public String getRouter() {
        return this.router;
    }

    public void setRouter(String router) {
        this.router = router;
    }

    @Deprecated
    @Parameter(key="refer-async")
    public Boolean getReferAsync() {
        return this.referAsync;
    }

    @Deprecated
    public void setReferAsync(Boolean referAsync) {
        this.referAsync = referAsync;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

