/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dubbo.common.Parameters;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.ExchangeClient;
import org.apache.dubbo.remoting.exchange.ExchangeHandler;
import org.apache.dubbo.rpc.protocol.dubbo.LazyConnectExchangeClient;

final class ReferenceCountExchangeClient
implements ExchangeClient {
    private final URL url;
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    private ExchangeClient client;

    public ReferenceCountExchangeClient(ExchangeClient client) {
        this.client = client;
        this.referenceCount.incrementAndGet();
        this.url = client.getUrl();
    }

    @Override
    public void reset(URL url) {
        this.client.reset(url);
    }

    @Override
    public CompletableFuture<Object> request(Object request) throws RemotingException {
        return this.client.request(request);
    }

    @Override
    public URL getUrl() {
        return this.client.getUrl();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.client.getRemoteAddress();
    }

    @Override
    public ChannelHandler getChannelHandler() {
        return this.client.getChannelHandler();
    }

    @Override
    public CompletableFuture<Object> request(Object request, int timeout) throws RemotingException {
        return this.client.request(request, timeout);
    }

    @Override
    public CompletableFuture<Object> request(Object request, ExecutorService executor) throws RemotingException {
        return this.client.request(request, executor);
    }

    @Override
    public CompletableFuture<Object> request(Object request, int timeout, ExecutorService executor) throws RemotingException {
        return this.client.request(request, timeout, executor);
    }

    @Override
    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public void reconnect() throws RemotingException {
        this.client.reconnect();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.client.getLocalAddress();
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.client.hasAttribute(key);
    }

    @Override
    public void reset(Parameters parameters) {
        this.client.reset(parameters);
    }

    @Override
    public void send(Object message) throws RemotingException {
        this.client.send(message);
    }

    @Override
    public ExchangeHandler getExchangeHandler() {
        return this.client.getExchangeHandler();
    }

    @Override
    public Object getAttribute(String key) {
        return this.client.getAttribute(key);
    }

    @Override
    public void send(Object message, boolean sent) throws RemotingException {
        this.client.send(message, sent);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.client.setAttribute(key, value);
    }

    @Override
    public void removeAttribute(String key) {
        this.client.removeAttribute(key);
    }

    @Override
    public void close() {
        this.close(0);
    }

    @Override
    public void close(int timeout) {
        if (this.referenceCount.decrementAndGet() <= 0) {
            if (timeout == 0) {
                this.client.close();
            } else {
                this.client.close(timeout);
            }
            this.replaceWithLazyClient();
        }
    }

    @Override
    public void startClose() {
        this.client.startClose();
    }

    private void replaceWithLazyClient() {
        URL lazyUrl = URLBuilder.from(this.url).addParameter("connect.lazy.initial.state", Boolean.TRUE).addParameter("reconnect", Boolean.FALSE).addParameter("send.reconnect", Boolean.TRUE.toString()).addParameter("warning", Boolean.TRUE.toString()).addParameter("lazyclient_request_with_warning", true).addParameter("_client_memo", "referencecounthandler.replacewithlazyclient").build();
        if (!(this.client instanceof LazyConnectExchangeClient) || this.client.isClosed()) {
            this.client = new LazyConnectExchangeClient(lazyUrl, this.client.getExchangeHandler());
        }
    }

    @Override
    public boolean isClosed() {
        return this.client.isClosed();
    }

    public void incrementAndGetCount() {
        this.referenceCount.incrementAndGet();
    }
}

