/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.multicast;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.support.FailbackRegistry;

public class MulticastRegistry
extends FailbackRegistry {
    private static final Logger logger = LoggerFactory.getLogger(MulticastRegistry.class);
    private static final int DEFAULT_MULTICAST_PORT = 1234;
    private final InetAddress multicastAddress;
    private final MulticastSocket multicastSocket;
    private final int multicastPort;
    private final ConcurrentMap<URL, Set<URL>> received = new ConcurrentHashMap<URL, Set<URL>>();
    private final ScheduledExecutorService cleanExecutor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("DubboMulticastRegistryCleanTimer", true));
    private final ScheduledFuture<?> cleanFuture;
    private final int cleanPeriod;
    private volatile boolean admin = false;

    public MulticastRegistry(URL url) {
        super(url);
        if (url.isAnyHost()) {
            throw new IllegalStateException("registry address == null");
        }
        try {
            this.multicastAddress = InetAddress.getByName(url.getHost());
            this.checkMulticastAddress(this.multicastAddress);
            this.multicastPort = url.getPort() <= 0 ? 1234 : url.getPort();
            this.multicastSocket = new MulticastSocket(this.multicastPort);
            NetUtils.joinMulticastGroup(this.multicastSocket, this.multicastAddress);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    byte[] buf = new byte[2048];
                    DatagramPacket recv = new DatagramPacket(buf, buf.length);
                    while (!MulticastRegistry.this.multicastSocket.isClosed()) {
                        try {
                            MulticastRegistry.this.multicastSocket.receive(recv);
                            String msg = new String(recv.getData()).trim();
                            int i = msg.indexOf(10);
                            if (i > 0) {
                                msg = msg.substring(0, i).trim();
                            }
                            MulticastRegistry.this.receive(msg, (InetSocketAddress)recv.getSocketAddress());
                            Arrays.fill(buf, (byte)0);
                        }
                        catch (Throwable e) {
                            if (MulticastRegistry.this.multicastSocket.isClosed()) continue;
                            logger.error(e.getMessage(), e);
                        }
                    }
                }
            }, "DubboMulticastRegistryReceiver");
            thread.setDaemon(true);
            thread.start();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        this.cleanPeriod = url.getParameter("session", 60000);
        this.cleanFuture = url.getParameter("clean", true) ? this.cleanExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    MulticastRegistry.this.clean();
                }
                catch (Throwable t) {
                    logger.error("Unexpected exception occur at clean expired provider, cause: " + t.getMessage(), t);
                }
            }
        }, this.cleanPeriod, this.cleanPeriod, TimeUnit.MILLISECONDS) : null;
    }

    private void checkMulticastAddress(InetAddress multicastAddress) {
        if (!multicastAddress.isMulticastAddress()) {
            String message = "Invalid multicast address " + multicastAddress;
            if (multicastAddress instanceof Inet4Address) {
                throw new IllegalArgumentException(message + ", ipv4 multicast address scope: 224.0.0.0 - 239.255.255.255.");
            }
            throw new IllegalArgumentException(message + ", ipv6 multicast address must start with ff, for example: ff01::1");
        }
    }

    private void clean() {
        if (this.admin) {
            for (Set providers : new HashSet(this.received.values())) {
                for (URL url : new HashSet(providers)) {
                    if (!this.isExpired(url)) continue;
                    if (logger.isWarnEnabled()) {
                        logger.warn("Clean expired provider " + url);
                    }
                    this.doUnregister(url);
                }
            }
        }
    }

    private boolean isExpired(URL url) {
        if (!url.getParameter("dynamic", true) || url.getPort() <= 0 || "consumer".equals(url.getProtocol()) || "route".equals(url.getProtocol()) || "override".equals(url.getProtocol())) {
            return false;
        }
        try {
            Socket socket = new Socket(url.getHost(), url.getPort());
            Throwable throwable = null;
            if (socket != null) {
                if (throwable != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    socket.close();
                }
            }
        }
        catch (Throwable e) {
            try {
                Thread.sleep(100L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Socket socket2 = new Socket(url.getHost(), url.getPort());
                Throwable throwable = null;
                if (socket2 != null) {
                    if (throwable != null) {
                        try {
                            socket2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        socket2.close();
                    }
                }
            }
            catch (Throwable e2) {
                return true;
            }
        }
        return false;
    }

    private void receive(String msg, InetSocketAddress remoteAddress) {
        if (logger.isInfoEnabled()) {
            logger.info("Receive multicast message: " + msg + " from " + remoteAddress);
        }
        if (msg.startsWith("register")) {
            URL url = URL.valueOf(msg.substring("register".length()).trim());
            this.registered(url);
        } else if (msg.startsWith("unregister")) {
            URL url = URL.valueOf(msg.substring("unregister".length()).trim());
            this.unregistered(url);
        } else if (msg.startsWith("subscribe")) {
            URL url = URL.valueOf(msg.substring("subscribe".length()).trim());
            Set<URL> urls = this.getRegistered();
            if (CollectionUtils.isNotEmpty(urls)) {
                for (URL u : urls) {
                    String host;
                    if (!UrlUtils.isMatch(url, u)) continue;
                    String string = host = remoteAddress != null && remoteAddress.getAddress() != null ? remoteAddress.getAddress().getHostAddress() : url.getIp();
                    if (url.getParameter("unicast", true) && !NetUtils.getLocalHost().equals(host)) {
                        this.unicast("register " + u.toFullString(), host);
                        continue;
                    }
                    this.multicast("register " + u.toFullString());
                }
            }
        }
    }

    private void multicast(String msg) {
        if (logger.isInfoEnabled()) {
            logger.info("Send multicast message: " + msg + " to " + this.multicastAddress + ":" + this.multicastPort);
        }
        try {
            byte[] data = (msg + "\n").getBytes();
            DatagramPacket hi = new DatagramPacket(data, data.length, this.multicastAddress, this.multicastPort);
            this.multicastSocket.send(hi);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private void unicast(String msg, String host) {
        if (logger.isInfoEnabled()) {
            logger.info("Send unicast message: " + msg + " to " + host + ":" + this.multicastPort);
        }
        try {
            byte[] data = (msg + "\n").getBytes();
            DatagramPacket hi = new DatagramPacket(data, data.length, InetAddress.getByName(host), this.multicastPort);
            this.multicastSocket.send(hi);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void doRegister(URL url) {
        this.multicast("register " + url.toFullString());
    }

    @Override
    public void doUnregister(URL url) {
        this.multicast("unregister " + url.toFullString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSubscribe(URL url, NotifyListener listener) {
        if ("*".equals(url.getServiceInterface())) {
            this.admin = true;
        }
        this.multicast("subscribe " + url.toFullString());
        NotifyListener notifyListener = listener;
        synchronized (notifyListener) {
            try {
                listener.wait(url.getParameter("timeout", 1000));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void doUnsubscribe(URL url, NotifyListener listener) {
        if (!"*".equals(url.getServiceInterface()) && url.getParameter("register", true)) {
            this.unregister(url);
        }
        this.multicast("unsubscribe " + url.toFullString());
    }

    @Override
    public boolean isAvailable() {
        try {
            return this.multicastSocket != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            ExecutorUtil.cancelScheduledFuture(this.cleanFuture);
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
        try {
            this.multicastSocket.leaveGroup(this.multicastAddress);
            this.multicastSocket.close();
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
        ExecutorUtil.gracefulShutdown(this.cleanExecutor, this.cleanPeriod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registered(URL url) {
        for (Map.Entry<URL, Set<NotifyListener>> entry : this.getSubscribed().entrySet()) {
            URL key = entry.getKey();
            if (!UrlUtils.isMatch(key, url)) continue;
            Set urls = this.received.computeIfAbsent(key, k -> new ConcurrentHashSet());
            urls.add(url);
            List<URL> list = this.toList(urls);
            for (NotifyListener listener : entry.getValue()) {
                this.notify(key, listener, list);
                NotifyListener notifyListener = listener;
                synchronized (notifyListener) {
                    listener.notify();
                }
            }
        }
    }

    protected void unregistered(URL url) {
        for (Map.Entry<URL, Set<NotifyListener>> entry : this.getSubscribed().entrySet()) {
            URL key = entry.getKey();
            if (!UrlUtils.isMatch(key, url)) continue;
            ConcurrentHashSet<URL> urls = (ConcurrentHashSet<URL>)this.received.get(key);
            if (urls != null) {
                urls.remove(url);
            }
            if (urls == null || urls.isEmpty()) {
                if (urls == null) {
                    urls = new ConcurrentHashSet<URL>();
                }
                URL empty = url.setProtocol("empty");
                urls.add(empty);
            }
            List<URL> list = this.toList((Set<URL>)urls);
            for (NotifyListener listener : entry.getValue()) {
                this.notify(key, listener, list);
            }
        }
    }

    protected void subscribed(URL url, NotifyListener listener) {
        List<URL> urls = this.lookup(url);
        this.notify(url, listener, urls);
    }

    private List<URL> toList(Set<URL> urls) {
        ArrayList<URL> list = new ArrayList<URL>();
        if (CollectionUtils.isNotEmpty(urls)) {
            for (URL url : urls) {
                list.add(url);
            }
        }
        return list;
    }

    @Override
    public void register(URL url) {
        super.register(url);
        this.registered(url);
    }

    @Override
    public void unregister(URL url) {
        super.unregister(url);
        this.unregistered(url);
    }

    @Override
    public void subscribe(URL url, NotifyListener listener) {
        super.subscribe(url, listener);
        this.subscribed(url, listener);
    }

    @Override
    public void unsubscribe(URL url, NotifyListener listener) {
        super.unsubscribe(url, listener);
        this.received.remove(url);
    }

    @Override
    public List<URL> lookup(URL url) {
        List<URL> cacheUrls;
        ArrayList<URL> urls = new ArrayList<URL>();
        Map<String, List<URL>> notifiedUrls = this.getNotified().get(url);
        if (notifiedUrls != null && notifiedUrls.size() > 0) {
            for (List list : notifiedUrls.values()) {
                urls.addAll(list);
            }
        }
        if (urls.isEmpty() && CollectionUtils.isNotEmpty(cacheUrls = this.getCacheUrls(url))) {
            urls.addAll(cacheUrls);
        }
        if (urls.isEmpty()) {
            for (URL uRL : this.getRegistered()) {
                if (!UrlUtils.isMatch(url, uRL)) continue;
                urls.add(uRL);
            }
        }
        if ("*".equals(url.getServiceInterface())) {
            for (URL uRL : this.getSubscribed().keySet()) {
                if (!UrlUtils.isMatch(url, uRL)) continue;
                urls.add(uRL);
            }
        }
        return urls;
    }

    public MulticastSocket getMulticastSocket() {
        return this.multicastSocket;
    }

    public Map<URL, Set<URL>> getReceived() {
        return this.received;
    }
}

