/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store;

import java.util.Set;
import java.util.SortedSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.metadata.definition.ServiceDefinitionBuilder;
import org.apache.dubbo.metadata.definition.model.FullServiceDefinition;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.store.InMemoryWritableMetadataService;
import org.apache.dubbo.rpc.RpcException;

public class RemoteWritableMetadataService
implements WritableMetadataService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile String exportedRevision;
    private volatile String subscribedRevision;
    private InMemoryWritableMetadataService writableMetadataService;

    public RemoteWritableMetadataService(InMemoryWritableMetadataService writableMetadataService) {
        this.writableMetadataService = writableMetadataService;
    }

    public MetadataReport getMetadataReport() {
        return MetadataReportInstance.getMetadataReport(true);
    }

    @Override
    public void publishServiceDefinition(URL url) {
        String side = url.getParameter("side");
        if ("provider".equalsIgnoreCase(side)) {
            this.publishProvider(url);
        } else {
            this.publishConsumer(url);
        }
    }

    private void publishProvider(URL providerUrl) throws RpcException {
        providerUrl = providerUrl.removeParameters("pid", "timestamp", "bind.ip", "bind.port", "timestamp");
        try {
            String interfaceName = providerUrl.getParameter("interface");
            if (StringUtils.isNotEmpty(interfaceName)) {
                Class<?> interfaceClass = Class.forName(interfaceName);
                FullServiceDefinition fullServiceDefinition = ServiceDefinitionBuilder.buildFullDefinition(interfaceClass, providerUrl.getParameters());
                this.getMetadataReport().storeProviderMetadata(new MetadataIdentifier(providerUrl.getServiceInterface(), providerUrl.getParameter("version"), providerUrl.getParameter("group"), "provider", providerUrl.getParameter("application")), fullServiceDefinition);
                return;
            }
            this.logger.error("publishProvider interfaceName is empty . providerUrl: " + providerUrl.toFullString());
        }
        catch (ClassNotFoundException e) {
            this.logger.error("publishProvider getServiceDescriptor error. providerUrl: " + providerUrl.toFullString(), e);
        }
    }

    private void publishConsumer(URL consumerURL) throws RpcException {
        consumerURL = consumerURL.removeParameters("pid", "timestamp", "bind.ip", "bind.port", "timestamp");
        this.getMetadataReport().storeConsumerMetadata(new MetadataIdentifier(consumerURL.getServiceInterface(), consumerURL.getParameter("version"), consumerURL.getParameter("group"), "consumer", consumerURL.getParameter("application")), consumerURL.getParameters());
    }

    @Override
    public boolean exportURL(URL url) {
        return true;
    }

    @Override
    public boolean unexportURL(URL url) {
        ServiceMetadataIdentifier metadataIdentifier = new ServiceMetadataIdentifier(url);
        metadataIdentifier.setRevision(this.exportedRevision);
        metadataIdentifier.setProtocol(url.getProtocol());
        return this.throwableAction(this.getMetadataReport()::removeServiceMetadata, metadataIdentifier);
    }

    @Override
    public boolean subscribeURL(URL url) {
        return true;
    }

    @Override
    public boolean unsubscribeURL(URL url) {
        return true;
    }

    @Override
    public boolean refreshMetadata(String exportedRevision, String subscribedRevision) {
        boolean result = true;
        if (!StringUtils.isEmpty(exportedRevision) && !exportedRevision.equals(this.exportedRevision)) {
            this.exportedRevision = exportedRevision;
            boolean executeResult = this.saveServiceMetadata();
            if (!executeResult) {
                result = false;
            }
        }
        if (!StringUtils.isEmpty(subscribedRevision) && !subscribedRevision.equals(this.subscribedRevision) && CollectionUtils.isNotEmpty(this.writableMetadataService.getSubscribedURLs())) {
            this.subscribedRevision = subscribedRevision;
            SubscriberMetadataIdentifier metadataIdentifier = new SubscriberMetadataIdentifier();
            metadataIdentifier.setApplication(this.serviceName());
            metadataIdentifier.setRevision(subscribedRevision);
            boolean executeResult = this.throwableAction(this.getMetadataReport()::saveSubscribedData, metadataIdentifier, this.writableMetadataService.getSubscribedURLs());
            if (!executeResult) {
                result = false;
            }
        }
        return result;
    }

    private boolean saveServiceMetadata() {
        boolean result = true;
        for (SortedSet urls : this.writableMetadataService.exportedServiceURLs.values()) {
            for (URL url : urls) {
                ServiceMetadataIdentifier metadataIdentifier = new ServiceMetadataIdentifier(url);
                metadataIdentifier.setRevision(this.exportedRevision);
                metadataIdentifier.setProtocol(url.getProtocol());
                boolean tmpResult = this.throwableAction(this.getMetadataReport()::saveServiceMetadata, metadataIdentifier, url);
                if (tmpResult) continue;
                result = tmpResult;
            }
        }
        return result;
    }

    @Override
    public SortedSet<String> getExportedURLs(String serviceInterface, String group, String version, String protocol) {
        return null;
    }

    @Override
    public String getServiceDefinition(String interfaceName, String version, String group) {
        return null;
    }

    @Override
    public String getServiceDefinition(String serviceKey) {
        return null;
    }

    boolean throwableAction(BiConsumer<ServiceMetadataIdentifier, URL> consumer, ServiceMetadataIdentifier metadataIdentifier, URL url) {
        try {
            consumer.accept(metadataIdentifier, url);
        }
        catch (Exception e) {
            this.logger.error("Failed to execute consumer, url is: " + url);
            return false;
        }
        return true;
    }

    boolean throwableAction(BiConsumer<SubscriberMetadataIdentifier, Set<String>> consumer, SubscriberMetadataIdentifier metadataIdentifier, Set<String> urls) {
        try {
            consumer.accept(metadataIdentifier, urls);
        }
        catch (Exception e) {
            this.logger.error("Failed to execute consumer, url is: " + urls);
            return false;
        }
        return true;
    }

    boolean throwableAction(Consumer<ServiceMetadataIdentifier> consumer, ServiceMetadataIdentifier metadataIdentifier) {
        try {
            consumer.accept(metadataIdentifier);
        }
        catch (Exception e) {
            this.logger.error("Failed to remove url metadata to remote center, metadataIdentifier is: " + metadataIdentifier);
            return false;
        }
        return true;
    }
}

