/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.metadata.definition.builder.DefaultTypeBuilder;
import org.apache.dubbo.metadata.definition.builder.TypeBuilder;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

public class TypeDefinitionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TypeDefinitionBuilder.class);
    private static final List<TypeBuilder> BUILDERS;
    private Map<Class<?>, TypeDefinition> typeCache = new HashMap();

    public static TypeDefinition build(Type type, Class<?> clazz, Map<Class<?>, TypeDefinition> typeCache) {
        TypeDefinition td;
        TypeBuilder builder = TypeDefinitionBuilder.getGenericTypeBuilder(type, clazz);
        if (builder != null) {
            td = builder.build(type, clazz, typeCache);
            td.setTypeBuilderName(builder.getClass().getName());
        } else {
            td = DefaultTypeBuilder.build(clazz, typeCache);
            td.setTypeBuilderName(DefaultTypeBuilder.class.getName());
        }
        if (ClassUtils.isSimpleType(clazz)) {
            td.setProperties(null);
        }
        return td;
    }

    private static TypeBuilder getGenericTypeBuilder(Type type, Class<?> clazz) {
        for (TypeBuilder builder : BUILDERS) {
            try {
                if (!builder.accept(type, clazz)) continue;
                return builder;
            }
            catch (NoClassDefFoundError cnfe) {
                logger.info("Throw classNotFound (" + cnfe.getMessage() + ") in " + builder.getClass());
            }
        }
        return null;
    }

    public TypeDefinition build(Type type, Class<?> clazz) {
        return TypeDefinitionBuilder.build(type, clazz, this.typeCache);
    }

    public List<TypeDefinition> getTypeDefinitions() {
        return new ArrayList<TypeDefinition>(this.typeCache.values());
    }

    static {
        ArrayList<TypeBuilder> builders = new ArrayList<TypeBuilder>();
        ExtensionLoader<TypeBuilder> extensionLoader = ExtensionLoader.getExtensionLoader(TypeBuilder.class);
        for (String extensionName : extensionLoader.getSupportedExtensions()) {
            builders.add(extensionLoader.getExtension(extensionName));
        }
        BUILDERS = builders;
    }
}

