/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.config;

import com.alibaba.spring.beans.factory.config.GenericBeanPostProcessorAdapter;
import com.alibaba.spring.util.ObjectUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.dubbo.config.AbstractConfig;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ReflectionUtils;

public class DubboConfigDefaultPropertyValueBeanPostProcessor
extends GenericBeanPostProcessorAdapter<AbstractConfig>
implements MergedBeanDefinitionPostProcessor,
PriorityOrdered {
    public static final String BEAN_NAME = "dubboConfigDefaultPropertyValueBeanPostProcessor";

    protected void processBeforeInitialization(AbstractConfig dubboConfigBean, String beanName) throws BeansException {
        this.setBeanNameAsDefaultValue(dubboConfigBean, "id", beanName);
        this.setBeanNameAsDefaultValue(dubboConfigBean, "name", beanName);
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
    }

    protected void setBeanNameAsDefaultValue(Object bean, String propertyName, String beanName) {
        Class beanClass = AopUtils.getTargetClass((Object)bean);
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor((Class)beanClass, (String)propertyName);
        if (propertyDescriptor != null) {
            Method getterMethod = propertyDescriptor.getReadMethod();
            if (getterMethod == null) {
                return;
            }
            Object propertyValue = ReflectionUtils.invokeMethod((Method)getterMethod, (Object)bean);
            if (propertyValue != null) {
                return;
            }
            Method setterMethod = propertyDescriptor.getWriteMethod();
            if (setterMethod != null && Arrays.equals(ObjectUtils.of((Object[])new Class[]{String.class}), setterMethod.getParameterTypes())) {
                ReflectionUtils.invokeMethod((Method)setterMethod, (Object)bean, (Object[])new Object[]{beanName});
            }
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

