/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.spring.beans.factory.annotation.AbstractAnnotationBeanPostProcessor;
import com.alibaba.spring.util.AnnotationUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.config.spring.ServiceBean;
import org.apache.dubbo.config.spring.beans.factory.annotation.ReferenceBeanBuilder;
import org.apache.dubbo.config.spring.beans.factory.annotation.ServiceBeanNameBuilder;
import org.apache.dubbo.config.spring.context.event.ServiceBeanExportedEvent;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;

public class ReferenceAnnotationBeanPostProcessor
extends AbstractAnnotationBeanPostProcessor
implements ApplicationContextAware,
ApplicationListener<ServiceBeanExportedEvent> {
    public static final String BEAN_NAME = "referenceAnnotationBeanPostProcessor";
    private static final int CACHE_SIZE = Integer.getInteger("referenceAnnotationBeanPostProcessor.cache.size", 32);
    private final ConcurrentMap<String, ReferenceBean<?>> referenceBeanCache = new ConcurrentHashMap(CACHE_SIZE);
    private final ConcurrentMap<InjectionMetadata.InjectedElement, ReferenceBean<?>> injectedFieldReferenceBeanCache = new ConcurrentHashMap(CACHE_SIZE);
    private final ConcurrentMap<InjectionMetadata.InjectedElement, ReferenceBean<?>> injectedMethodReferenceBeanCache = new ConcurrentHashMap(CACHE_SIZE);
    private final ConcurrentMap<String, ReferencedBeanInvocationHandler> referencedBeanInvocationHandlersCache = new ConcurrentHashMap<String, ReferencedBeanInvocationHandler>();
    private ApplicationContext applicationContext;

    public ReferenceAnnotationBeanPostProcessor() {
        super(new Class[]{Reference.class, com.alibaba.dubbo.config.annotation.Reference.class});
    }

    public Collection<ReferenceBean<?>> getReferenceBeans() {
        return this.referenceBeanCache.values();
    }

    public Map<InjectionMetadata.InjectedElement, ReferenceBean<?>> getInjectedFieldReferenceBeanMap() {
        return Collections.unmodifiableMap(this.injectedFieldReferenceBeanCache);
    }

    public Map<InjectionMetadata.InjectedElement, ReferenceBean<?>> getInjectedMethodReferenceBeanMap() {
        return Collections.unmodifiableMap(this.injectedMethodReferenceBeanCache);
    }

    protected Object doGetInjectedBean(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) throws Exception {
        String referencedBeanName = this.buildReferencedBeanName(attributes, injectedType);
        String referenceBeanName = this.getReferenceBeanName(attributes, injectedType);
        ReferenceBean referenceBean = this.buildReferenceBeanIfAbsent(referenceBeanName, attributes, injectedType);
        boolean localServiceBean = this.isLocalServiceBean(referencedBeanName, referenceBean, attributes);
        this.registerReferenceBean(referencedBeanName, referenceBean, attributes, localServiceBean, injectedType);
        this.cacheInjectedReferenceBean(referenceBean, injectedElement);
        return this.getOrCreateProxy(referencedBeanName, referenceBean, localServiceBean, injectedType);
    }

    private void registerReferenceBean(String referencedBeanName, ReferenceBean referenceBean, AnnotationAttributes attributes, boolean localServiceBean, Class<?> interfaceClass) {
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        String beanName = this.getReferenceBeanName(attributes, interfaceClass);
        if (localServiceBean) {
            AbstractBeanDefinition beanDefinition = (AbstractBeanDefinition)beanFactory.getBeanDefinition(referencedBeanName);
            RuntimeBeanReference runtimeBeanReference = (RuntimeBeanReference)beanDefinition.getPropertyValues().get("ref");
            String serviceBeanName = runtimeBeanReference.getBeanName();
            beanFactory.registerAlias(serviceBeanName, beanName);
        } else if (!beanFactory.containsBean(beanName)) {
            beanFactory.registerSingleton(beanName, (Object)referenceBean);
        }
    }

    private String getReferenceBeanName(AnnotationAttributes attributes, Class<?> interfaceClass) {
        String beanName = (String)AnnotationUtils.getAttribute((Map)attributes, (String)"id");
        if (!StringUtils.hasText((String)beanName)) {
            beanName = this.generateReferenceBeanName(attributes, interfaceClass);
        }
        return beanName;
    }

    private String generateReferenceBeanName(AnnotationAttributes attributes, Class<?> interfaceClass) {
        StringBuilder beanNameBuilder = new StringBuilder("@Reference");
        if (!attributes.isEmpty()) {
            beanNameBuilder.append('(');
            for (Map.Entry entry : attributes.entrySet()) {
                beanNameBuilder.append((String)entry.getKey()).append('=').append(entry.getValue()).append(',');
            }
            beanNameBuilder.setCharAt(beanNameBuilder.lastIndexOf(","), ')');
        }
        beanNameBuilder.append(" ").append(interfaceClass.getName());
        return beanNameBuilder.toString();
    }

    private boolean isLocalServiceBean(String referencedBeanName, ReferenceBean referenceBean, AnnotationAttributes attributes) {
        return this.existsServiceBean(referencedBeanName) && !this.isRemoteReferenceBean(referenceBean, attributes);
    }

    private boolean existsServiceBean(String referencedBeanName) {
        return this.applicationContext.containsBean(referencedBeanName) && this.applicationContext.isTypeMatch(referencedBeanName, ServiceBean.class);
    }

    private boolean isRemoteReferenceBean(ReferenceBean referenceBean, AnnotationAttributes attributes) {
        boolean remote = Boolean.FALSE.equals(referenceBean.isInjvm()) || Boolean.FALSE.equals(attributes.get((Object)"injvm"));
        return remote;
    }

    private Object getOrCreateProxy(String referencedBeanName, ReferenceBean referenceBean, boolean localServiceBean, Class<?> serviceInterfaceType) {
        if (localServiceBean) {
            return Proxy.newProxyInstance(this.getClassLoader(), new Class[]{serviceInterfaceType}, this.newReferencedBeanInvocationHandler(referencedBeanName));
        }
        this.exportServiceBeanIfNecessary(referencedBeanName);
        return referenceBean.get();
    }

    private void exportServiceBeanIfNecessary(String referencedBeanName) {
        ServiceBean serviceBean;
        if (this.existsServiceBean(referencedBeanName) && !(serviceBean = this.getServiceBean(referencedBeanName)).isExported()) {
            serviceBean.export();
        }
    }

    private ServiceBean getServiceBean(String referencedBeanName) {
        return (ServiceBean)this.applicationContext.getBean(referencedBeanName, ServiceBean.class);
    }

    private InvocationHandler newReferencedBeanInvocationHandler(String referencedBeanName) {
        return this.referencedBeanInvocationHandlersCache.computeIfAbsent(referencedBeanName, x$0 -> new ReferencedBeanInvocationHandler((String)x$0));
    }

    public void onApplicationEvent(ServiceBeanExportedEvent event) {
        this.initReferencedBeanInvocationHandler(event.getServiceBean());
    }

    private void initReferencedBeanInvocationHandler(ServiceBean serviceBean) {
        String serviceBeanName = serviceBean.getBeanName();
        this.referencedBeanInvocationHandlersCache.computeIfPresent(serviceBeanName, (name, handler) -> {
            ((ReferencedBeanInvocationHandler)handler).init();
            return null;
        });
    }

    protected String buildInjectedObjectCacheKey(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) {
        return this.buildReferencedBeanName(attributes, injectedType) + "#source=" + injectedElement.getMember() + "#attributes=" + AnnotationUtils.getAttributes((Map)attributes, (PropertyResolver)this.getEnvironment(), (String[])new String[0]);
    }

    private String buildReferencedBeanName(AnnotationAttributes attributes, Class<?> serviceInterfaceType) {
        ServiceBeanNameBuilder serviceBeanNameBuilder = ServiceBeanNameBuilder.create(attributes, serviceInterfaceType, this.getEnvironment());
        return serviceBeanNameBuilder.build();
    }

    private ReferenceBean buildReferenceBeanIfAbsent(String referenceBeanName, AnnotationAttributes attributes, Class<?> referencedType) throws Exception {
        ReferenceBean referenceBean = (ReferenceBean)this.referenceBeanCache.get(referenceBeanName);
        if (referenceBean == null) {
            ReferenceBeanBuilder beanBuilder = (ReferenceBeanBuilder)ReferenceBeanBuilder.create(attributes, this.applicationContext).interfaceClass(referencedType);
            referenceBean = (ReferenceBean)beanBuilder.build();
            this.referenceBeanCache.put(referenceBeanName, referenceBean);
        } else if (!referencedType.isAssignableFrom(referenceBean.getInterfaceClass())) {
            throw new IllegalArgumentException("reference bean name " + referenceBeanName + " has been duplicated, but interfaceClass " + referenceBean.getInterfaceClass().getName() + " cannot be assigned to " + referencedType.getName());
        }
        return referenceBean;
    }

    private void cacheInjectedReferenceBean(ReferenceBean referenceBean, InjectionMetadata.InjectedElement injectedElement) {
        if (injectedElement.getMember() instanceof Field) {
            this.injectedFieldReferenceBeanCache.put(injectedElement, referenceBean);
        } else if (injectedElement.getMember() instanceof Method) {
            this.injectedMethodReferenceBeanCache.put(injectedElement, referenceBean);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        super.destroy();
        this.referenceBeanCache.clear();
        this.referencedBeanInvocationHandlersCache.clear();
        this.injectedFieldReferenceBeanCache.clear();
        this.injectedMethodReferenceBeanCache.clear();
    }

    private class ReferencedBeanInvocationHandler
    implements InvocationHandler {
        private final String referencedBeanName;
        private Object bean;

        private ReferencedBeanInvocationHandler(String referencedBeanName) {
            this.referencedBeanName = referencedBeanName;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            try {
                if (this.bean == null) {
                    this.init();
                }
                result = method.invoke(this.bean, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            return result;
        }

        private void init() {
            ServiceBean serviceBean = (ServiceBean)ReferenceAnnotationBeanPostProcessor.this.applicationContext.getBean(this.referencedBeanName, ServiceBean.class);
            this.bean = serviceBean.getRef();
        }
    }
}

