/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.protobuf.support;

import com.google.common.base.Strings;
import com.google.protobuf.BoolValue;
import com.google.protobuf.BytesValue;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Empty;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.FloatValue;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.StringValue;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.serialize.protobuf.support.ProtobufWrappedException;
import org.apache.dubbo.common.serialize.protobuf.support.wrapper.MapValue;
import org.apache.dubbo.common.serialize.protobuf.support.wrapper.ThrowablePB;

public class ProtobufUtils {
    private static ConcurrentMap<Class<? extends MessageLite>, MessageMarshaller> marshallers = new ConcurrentHashMap<Class<? extends MessageLite>, MessageMarshaller>();
    private static volatile ExtensionRegistryLite globalRegistry = ExtensionRegistryLite.getEmptyRegistry();

    static boolean isSupported(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return MessageLite.class.isAssignableFrom(clazz);
    }

    static <T> T deserializeJson(String json, Class<T> requestClass) throws InvalidProtocolBufferException {
        GeneratedMessageV3.Builder builder;
        try {
            builder = ProtobufUtils.getMessageBuilder(requestClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Get google protobuf message builder from " + requestClass.getName() + "failed", e);
        }
        JsonFormat.parser().merge(json, (Message.Builder)builder);
        return (T)builder.build();
    }

    static String serializeJson(Object value) throws InvalidProtocolBufferException {
        JsonFormat.Printer printer = JsonFormat.printer().omittingInsignificantWhitespace();
        return printer.print((MessageOrBuilder)value);
    }

    private static GeneratedMessageV3.Builder getMessageBuilder(Class<?> requestType) throws Exception {
        Method method = requestType.getMethod("newBuilder", new Class[0]);
        return (GeneratedMessageV3.Builder)method.invoke(null, null);
    }

    public static <T extends MessageLite> void marshaller(T defaultInstance) {
        marshallers.put(defaultInstance.getClass(), new MessageMarshaller<T>(defaultInstance));
    }

    static void serialize(Object value, OutputStream os) throws IOException {
        MessageLite messageLite = (MessageLite)value;
        messageLite.writeDelimitedTo(os);
    }

    static <T> T deserialize(InputStream is, Class<T> requestClass) throws InvalidProtocolBufferException {
        MessageMarshaller marshaller = (MessageMarshaller)marshallers.get(requestClass);
        if (marshaller == null) {
            throw new IllegalStateException(String.format("Protobuf classes should be registered in advance before do serialization, class name: %s", requestClass.getName()));
        }
        return marshaller.parse(is);
    }

    public static Empty convertNullToEmpty() {
        return Empty.newBuilder().build();
    }

    public static Object convertEmptyToNull(Empty empty) {
        return null;
    }

    public static ThrowablePB.ThrowableProto convertToThrowableProto(Throwable throwable) {
        ThrowablePB.ThrowableProto.Builder builder = ThrowablePB.ThrowableProto.newBuilder();
        builder.setOriginalClassName(throwable.getClass().getCanonicalName());
        builder.setOriginalMessage(Strings.nullToEmpty((String)throwable.getMessage()));
        for (StackTraceElement e : throwable.getStackTrace()) {
            builder.addStackTrace(ProtobufUtils.toStackTraceElement(e));
        }
        if (throwable.getCause() != null) {
            builder.setCause(ProtobufUtils.convertToThrowableProto(throwable.getCause()));
        }
        return builder.build();
    }

    public static Throwable convertToException(ThrowablePB.ThrowableProto throwableProto) {
        return new ProtobufWrappedException(throwableProto);
    }

    private static ThrowablePB.StackTraceElementProto toStackTraceElement(StackTraceElement element) {
        ThrowablePB.StackTraceElementProto.Builder builder = ThrowablePB.StackTraceElementProto.newBuilder().setClassName(element.getClassName()).setMethodName(element.getMethodName()).setLineNumber(element.getLineNumber());
        if (element.getFileName() != null) {
            builder.setFileName(element.getFileName());
        }
        return builder.build();
    }

    static {
        ProtobufUtils.marshaller(MapValue.Map.getDefaultInstance());
        ProtobufUtils.marshaller(Empty.getDefaultInstance());
        ProtobufUtils.marshaller(ThrowablePB.ThrowableProto.getDefaultInstance());
        ProtobufUtils.marshaller(BoolValue.getDefaultInstance());
        ProtobufUtils.marshaller(Int32Value.getDefaultInstance());
        ProtobufUtils.marshaller(Int64Value.getDefaultInstance());
        ProtobufUtils.marshaller(FloatValue.getDefaultInstance());
        ProtobufUtils.marshaller(DoubleValue.getDefaultInstance());
        ProtobufUtils.marshaller(BytesValue.getDefaultInstance());
        ProtobufUtils.marshaller(StringValue.getDefaultInstance());
    }

    private static final class MessageMarshaller<T extends MessageLite> {
        private final Parser<T> parser;
        private final T defaultInstance;

        MessageMarshaller(T defaultInstance) {
            this.defaultInstance = defaultInstance;
            this.parser = defaultInstance.getParserForType();
        }

        public Class<T> getMessageClass() {
            return this.defaultInstance.getClass();
        }

        public T getMessagePrototype() {
            return this.defaultInstance;
        }

        public T parse(InputStream stream) throws InvalidProtocolBufferException {
            return (T)((MessageLite)this.parser.parseDelimitedFrom(stream, globalRegistry));
        }

        private T parseFrom(CodedInputStream stream) throws InvalidProtocolBufferException {
            MessageLite message = (MessageLite)this.parser.parseFrom(stream, globalRegistry);
            try {
                stream.checkLastTagWas(0);
                return (T)message;
            }
            catch (InvalidProtocolBufferException e) {
                e.setUnfinishedMessage(message);
                throw e;
            }
        }
    }
}

