/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.kryo.optimized;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.dubbo.common.serialize.Cleanable;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.kryo.utils.KryoUtils;

public class KryoObjectOutput2
implements ObjectOutput,
Cleanable {
    private Output output;
    private Kryo kryo;

    public KryoObjectOutput2(OutputStream outputStream) {
        this.output = new Output(outputStream);
        this.kryo = KryoUtils.get();
    }

    @Override
    public void writeBool(boolean v) throws IOException {
        this.output.writeBoolean(v);
    }

    @Override
    public void writeByte(byte v) throws IOException {
        this.output.writeByte(v);
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.output.writeShort((int)v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.output.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.output.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.output.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.output.writeDouble(v);
    }

    @Override
    public void writeBytes(byte[] v) throws IOException {
        if (v == null) {
            this.output.writeInt(-1);
        } else {
            this.writeBytes(v, 0, v.length);
        }
    }

    @Override
    public void writeBytes(byte[] v, int off, int len) throws IOException {
        if (v == null) {
            this.output.writeInt(-1);
        } else {
            this.output.writeInt(len);
            this.output.write(v, off, len);
        }
    }

    @Override
    public void writeUTF(String v) throws IOException {
        this.output.writeString(v);
    }

    @Override
    public void writeObject(Object v) throws IOException {
        this.kryo.writeObjectOrNull(this.output, v, v.getClass());
    }

    @Override
    public void writeThrowable(Object v) throws IOException {
        this.kryo.writeClassAndObject(this.output, v);
    }

    @Override
    public void flushBuffer() throws IOException {
        this.output.flush();
    }

    @Override
    public void cleanup() {
        KryoUtils.release(this.kryo);
        this.kryo = null;
    }
}

