/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.xml.rpc.protocol.xmlrpc;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.http.HttpBinder;
import org.apache.dubbo.remoting.http.HttpHandler;
import org.apache.dubbo.remoting.http.HttpServer;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.AbstractProxyProtocol;
import org.apache.dubbo.xml.rpc.protocol.xmlrpc.XmlRpcProxyFactoryBean;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.server.PropertyHandlerMapping;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcServerConfigImpl;
import org.apache.xmlrpc.webserver.XmlRpcServletServer;
import org.springframework.remoting.RemoteAccessException;

public class XmlRpcProtocol
extends AbstractProxyProtocol {
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_METHODS_HEADER = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS_HEADER = "Access-Control-Allow-Headers";
    private final Map<String, HttpServer> serverMap = new ConcurrentHashMap<String, HttpServer>();
    private final Map<String, XmlRpcServletServer> skeletonMap = new ConcurrentHashMap<String, XmlRpcServletServer>();
    private HttpBinder httpBinder;

    public XmlRpcProtocol() {
        super(XmlRpcException.class);
    }

    public void setHttpBinder(HttpBinder httpBinder) {
        this.httpBinder = httpBinder;
    }

    @Override
    public int getDefaultPort() {
        return 80;
    }

    @Override
    protected <T> Runnable doExport(final T impl, Class<T> type, URL url) throws RpcException {
        URL httpUrl = url.setProtocol("http");
        String addr = httpUrl.getIp() + ":" + httpUrl.getPort();
        HttpServer server = this.serverMap.get(addr);
        if (server == null) {
            server = this.httpBinder.bind(httpUrl, new InternalHandler(httpUrl.getParameter("cors", false)));
            this.serverMap.put(addr, server);
        }
        final String path = httpUrl.getAbsolutePath();
        XmlRpcServletServer xmlRpcServer = new XmlRpcServletServer();
        PropertyHandlerMapping propertyHandlerMapping = new PropertyHandlerMapping();
        try {
            propertyHandlerMapping.setRequestProcessorFactoryFactory(new RequestProcessorFactoryFactory(){

                public RequestProcessorFactoryFactory.RequestProcessorFactory getRequestProcessorFactory(Class pClass) throws XmlRpcException {
                    return new RequestProcessorFactoryFactory.RequestProcessorFactory(){

                        public Object getRequestProcessor(XmlRpcRequest pRequest) throws XmlRpcException {
                            return impl;
                        }
                    };
                }
            });
            propertyHandlerMapping.addHandler(XmlRpcProxyFactoryBean.replace(type.getName()), type);
        }
        catch (Exception e) {
            throw new RpcException(e);
        }
        xmlRpcServer.setHandlerMapping((XmlRpcHandlerMapping)propertyHandlerMapping);
        XmlRpcServerConfigImpl xmlRpcServerConfig = (XmlRpcServerConfigImpl)xmlRpcServer.getConfig();
        xmlRpcServerConfig.setEnabledForExceptions(true);
        xmlRpcServerConfig.setContentLengthOptional(false);
        this.skeletonMap.put(path, xmlRpcServer);
        return new Runnable(){

            @Override
            public void run() {
                XmlRpcProtocol.this.skeletonMap.remove(path);
            }
        };
    }

    @Override
    protected <T> T doRefer(Class<T> serviceType, URL url) throws RpcException {
        XmlRpcProxyFactoryBean xmlRpcProxyFactoryBean = new XmlRpcProxyFactoryBean();
        xmlRpcProxyFactoryBean.setServiceUrl(url.setProtocol("http").toIdentityString());
        xmlRpcProxyFactoryBean.setServiceInterface(serviceType);
        xmlRpcProxyFactoryBean.afterPropertiesSet();
        return (T)xmlRpcProxyFactoryBean.getObject();
    }

    @Override
    protected int getErrorCode(Throwable e) {
        if (e instanceof RemoteAccessException) {
            e = e.getCause();
        }
        if (e != null) {
            Class<?> cls = e.getClass();
            if (SocketTimeoutException.class.equals(cls)) {
                return 2;
            }
            if (IOException.class.isAssignableFrom(cls)) {
                return 1;
            }
            if (ClassNotFoundException.class.isAssignableFrom(cls)) {
                return 5;
            }
        }
        return super.getErrorCode(e);
    }

    @Override
    public void destroy() {
        super.destroy();
        for (String key : new ArrayList<String>(this.serverMap.keySet())) {
            HttpServer server = this.serverMap.remove(key);
            if (server == null) continue;
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Close xml server " + server.getUrl());
                }
                server.close();
            }
            catch (Throwable t) {
                this.logger.warn(t.getMessage(), t);
            }
        }
    }

    private class InternalHandler
    implements HttpHandler {
        private boolean cors;

        public InternalHandler(boolean cors) {
            this.cors = cors;
        }

        @Override
        public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            String uri = request.getRequestURI();
            XmlRpcServletServer xmlrpc = (XmlRpcServletServer)XmlRpcProtocol.this.skeletonMap.get(uri);
            if (this.cors) {
                response.setHeader(XmlRpcProtocol.ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, "*");
                response.setHeader(XmlRpcProtocol.ACCESS_CONTROL_ALLOW_METHODS_HEADER, "POST");
                response.setHeader(XmlRpcProtocol.ACCESS_CONTROL_ALLOW_HEADERS_HEADER, "*");
            }
            if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
                response.setStatus(200);
            } else if ("POST".equalsIgnoreCase(request.getMethod())) {
                RpcContext.getContext().setRemoteAddress(request.getRemoteAddr(), request.getRemotePort());
                try {
                    xmlrpc.execute(request, response);
                }
                catch (Throwable e) {
                    throw new ServletException(e);
                }
            } else {
                response.setStatus(500);
            }
        }
    }
}

