/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.util.ObjectUtils;

public class BeanFactoryUtils {
    public static boolean addApplicationListener(ApplicationContext applicationContext, ApplicationListener listener) {
        try {
            Method method = applicationContext.getClass().getMethod("addApplicationListener", ApplicationListener.class);
            method.invoke((Object)applicationContext, listener);
            return true;
        }
        catch (Throwable t) {
            if (applicationContext instanceof AbstractApplicationContext) {
                try {
                    Method method = AbstractApplicationContext.class.getDeclaredMethod("addListener", ApplicationListener.class);
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    method.invoke((Object)applicationContext, listener);
                    return true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public static <T> T getNullableBean(ListableBeanFactory beanFactory, String beanName, Class<T> beanType) {
        Object bean = null;
        try {
            bean = beanFactory.getBean(beanName, beanType);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return (T)bean;
    }

    public static <T> List<T> getBeans(ListableBeanFactory beanFactory, String[] beanNames, Class<T> beanType) {
        if (ObjectUtils.isEmpty((Object[])beanNames)) {
            return Collections.emptyList();
        }
        ArrayList<T> beans = new ArrayList<T>(beanNames.length);
        for (String beanName : beanNames) {
            T bean = BeanFactoryUtils.getNullableBean(beanFactory, beanName, beanType);
            if (bean == null) continue;
            beans.add(bean);
        }
        return Collections.unmodifiableList(beans);
    }
}

