/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.httpinvoker;

import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http.HttpBinder;
import org.apache.dubbo.remoting.http.HttpHandler;
import org.apache.dubbo.remoting.http.HttpServer;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.AbstractProxyProtocol;
import org.apache.dubbo.rpc.protocol.httpinvoker.HttpRemoteInvocation;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.httpinvoker.HttpComponentsHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;
import org.springframework.remoting.httpinvoker.SimpleHttpInvokerRequestExecutor;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationFactory;

public class HttpInvokerProtocol
extends AbstractProxyProtocol {
    public static final int DEFAULT_PORT = 80;
    private final Map<String, HttpServer> serverMap = new ConcurrentHashMap<String, HttpServer>();
    private final Map<String, HttpInvokerServiceExporter> skeletonMap = new ConcurrentHashMap<String, HttpInvokerServiceExporter>();
    private HttpBinder httpBinder;

    public HttpInvokerProtocol() {
        super(RemoteAccessException.class);
    }

    public void setHttpBinder(HttpBinder httpBinder) {
        this.httpBinder = httpBinder;
    }

    @Override
    public int getDefaultPort() {
        return 80;
    }

    @Override
    protected <T> Runnable doExport(T impl, Class<T> type, URL url) throws RpcException {
        String addr = this.getAddr(url);
        HttpServer server = this.serverMap.get(addr);
        if (server == null) {
            server = this.httpBinder.bind(url, new InternalHandler());
            this.serverMap.put(addr, server);
        }
        final String path = url.getAbsolutePath();
        this.skeletonMap.put(path, this.createExporter(impl, type));
        final String genericPath = path + "/" + "generic";
        this.skeletonMap.put(genericPath, this.createExporter(impl, GenericService.class));
        return new Runnable(){

            @Override
            public void run() {
                HttpInvokerProtocol.this.skeletonMap.remove(path);
                HttpInvokerProtocol.this.skeletonMap.remove(genericPath);
            }
        };
    }

    private <T> HttpInvokerServiceExporter createExporter(T impl, Class<?> type) {
        HttpInvokerServiceExporter httpServiceExporter = new HttpInvokerServiceExporter();
        httpServiceExporter.setServiceInterface(type);
        httpServiceExporter.setService(impl);
        try {
            httpServiceExporter.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RpcException(e.getMessage(), (Throwable)e);
        }
        return httpServiceExporter;
    }

    @Override
    protected <T> T doRefer(Class<T> serviceType, final URL url) throws RpcException {
        final String generic = url.getParameter("generic");
        final boolean isGeneric = ProtocolUtils.isGeneric(generic) || serviceType.equals(GenericService.class);
        HttpInvokerProxyFactoryBean httpProxyFactoryBean = new HttpInvokerProxyFactoryBean();
        httpProxyFactoryBean.setRemoteInvocationFactory(new RemoteInvocationFactory(){

            public RemoteInvocation createRemoteInvocation(MethodInvocation methodInvocation) {
                HttpRemoteInvocation invocation = Version.isRelease270OrHigher(url.getParameter("release")) ? new HttpRemoteInvocation(methodInvocation) : (Version.isRelease263OrHigher(url.getParameter("dubbo")) ? new com.alibaba.dubbo.rpc.protocol.http.HttpRemoteInvocation(methodInvocation) : new RemoteInvocation(methodInvocation));
                if (isGeneric) {
                    invocation.addAttribute("generic", (Serializable)((Object)generic));
                }
                return invocation;
            }
        });
        String key = url.toIdentityString();
        if (isGeneric) {
            key = key + "/" + "generic";
        }
        httpProxyFactoryBean.setServiceUrl(key.replace("http-invoker", "http"));
        httpProxyFactoryBean.setServiceInterface(serviceType);
        String client = url.getParameter("client");
        if (StringUtils.isEmpty(client) || "simple".equals(client)) {
            SimpleHttpInvokerRequestExecutor httpInvokerRequestExecutor = new SimpleHttpInvokerRequestExecutor(){

                protected void prepareConnection(HttpURLConnection con, int contentLength) throws IOException {
                    super.prepareConnection(con, contentLength);
                    con.setReadTimeout(url.getParameter("timeout", 1000));
                    con.setConnectTimeout(url.getParameter("connect.timeout", 3000));
                }
            };
            httpProxyFactoryBean.setHttpInvokerRequestExecutor((HttpInvokerRequestExecutor)httpInvokerRequestExecutor);
        } else if ("commons".equals(client)) {
            HttpComponentsHttpInvokerRequestExecutor httpInvokerRequestExecutor = new HttpComponentsHttpInvokerRequestExecutor();
            httpInvokerRequestExecutor.setReadTimeout(url.getParameter("timeout", 1000));
            httpInvokerRequestExecutor.setConnectTimeout(url.getParameter("connect.timeout", 3000));
            httpProxyFactoryBean.setHttpInvokerRequestExecutor((HttpInvokerRequestExecutor)httpInvokerRequestExecutor);
        } else {
            throw new IllegalStateException("Unsupported http protocol client " + client + ", only supported: simple, commons");
        }
        httpProxyFactoryBean.afterPropertiesSet();
        return (T)httpProxyFactoryBean.getObject();
    }

    @Override
    protected int getErrorCode(Throwable e) {
        if (e instanceof RemoteAccessException) {
            e = e.getCause();
        }
        if (e != null) {
            Class<?> cls = e.getClass();
            if (SocketTimeoutException.class.equals(cls)) {
                return 2;
            }
            if (IOException.class.isAssignableFrom(cls)) {
                return 1;
            }
            if (ClassNotFoundException.class.isAssignableFrom(cls)) {
                return 5;
            }
        }
        return super.getErrorCode(e);
    }

    private class InternalHandler
    implements HttpHandler {
        private InternalHandler() {
        }

        @Override
        public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            String uri = request.getRequestURI();
            HttpInvokerServiceExporter skeleton = (HttpInvokerServiceExporter)HttpInvokerProtocol.this.skeletonMap.get(uri);
            if (!"POST".equalsIgnoreCase(request.getMethod())) {
                response.setStatus(500);
            } else {
                RpcContext.getContext().setRemoteAddress(request.getRemoteAddr(), request.getRemotePort());
                try {
                    skeleton.handleRequest(request, response);
                }
                catch (Throwable e) {
                    throw new ServletException(e);
                }
            }
        }
    }
}

