/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.AbstractResult;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvokeMode;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.protocol.dubbo.FutureAdapter;

public class AsyncRpcResult
extends AbstractResult {
    private static final Logger logger = LoggerFactory.getLogger(AsyncRpcResult.class);
    private RpcContext storedContext;
    private RpcContext storedServerContext;
    private Invocation invocation;
    private RpcContext tmpContext;
    private RpcContext tmpServerContext;
    private BiConsumer<Result, Throwable> beforeContext = (appResponse, t) -> {
        this.tmpContext = RpcContext.getContext();
        this.tmpServerContext = RpcContext.getServerContext();
        RpcContext.restoreContext(this.storedContext);
        RpcContext.restoreServerContext(this.storedServerContext);
    };
    private BiConsumer<Result, Throwable> afterContext = (appResponse, t) -> {
        RpcContext.restoreContext(this.tmpContext);
        RpcContext.restoreServerContext(this.tmpServerContext);
    };

    public AsyncRpcResult(Invocation invocation) {
        this.invocation = invocation;
        this.storedContext = RpcContext.getContext();
        this.storedServerContext = RpcContext.getServerContext();
    }

    public AsyncRpcResult(AsyncRpcResult asyncRpcResult) {
        this.invocation = asyncRpcResult.getInvocation();
        this.storedContext = asyncRpcResult.getStoredContext();
        this.storedServerContext = asyncRpcResult.getStoredServerContext();
    }

    @Override
    public Object getValue() {
        return this.getAppResponse().getValue();
    }

    @Override
    public void setValue(Object value) {
        try {
            if (this.isDone()) {
                ((Result)this.get()).setValue(value);
            } else {
                AppResponse appResponse = new AppResponse();
                appResponse.setValue(value);
                this.complete(appResponse);
            }
        }
        catch (Exception e) {
            logger.error("Got exception when trying to change the value of the underlying result from AsyncRpcResult.", e);
        }
    }

    @Override
    public Throwable getException() {
        return this.getAppResponse().getException();
    }

    @Override
    public void setException(Throwable t) {
        try {
            if (this.isDone()) {
                ((Result)this.get()).setException(t);
            } else {
                AppResponse appResponse = new AppResponse();
                appResponse.setException(t);
                this.complete(appResponse);
            }
        }
        catch (Exception e) {
            logger.error("Got exception when trying to change the value of the underlying result from AsyncRpcResult.", e);
        }
    }

    @Override
    public boolean hasException() {
        return this.getAppResponse().hasException();
    }

    public Result getAppResponse() {
        try {
            if (this.isDone()) {
                return (Result)this.get();
            }
        }
        catch (Exception e) {
            logger.error("Got exception when trying to fetch the underlying result from AsyncRpcResult.", e);
        }
        return new AppResponse();
    }

    @Override
    public Object recreate() throws Throwable {
        RpcInvocation rpcInvocation = (RpcInvocation)this.invocation;
        FutureAdapter future = new FutureAdapter(this);
        RpcContext.getContext().setFuture(future);
        if (InvokeMode.FUTURE == rpcInvocation.getInvokeMode()) {
            return future;
        }
        return this.getAppResponse().recreate();
    }

    @Override
    public Result whenCompleteWithContext(BiConsumer<Result, Throwable> fn) {
        CompletionStage future = this.whenComplete((T v, U t) -> {
            this.beforeContext.accept((Result)v, (Throwable)t);
            fn.accept((Result)v, (Throwable)t);
            this.afterContext.accept((Result)v, (Throwable)t);
        });
        AsyncRpcResult nextStage = new AsyncRpcResult(this);
        nextStage.subscribeTo((CompletableFuture<?>)future);
        return nextStage;
    }

    public void subscribeTo(CompletableFuture<?> future) {
        future.whenComplete((obj, t) -> {
            if (t != null) {
                this.completeExceptionally((Throwable)t);
            } else {
                this.complete((Result)obj);
            }
        });
    }

    @Override
    public Map<String, String> getAttachments() {
        return this.getAppResponse().getAttachments();
    }

    @Override
    public void setAttachments(Map<String, String> map) {
        this.getAppResponse().setAttachments(map);
    }

    @Override
    public void addAttachments(Map<String, String> map) {
        this.getAppResponse().addAttachments(map);
    }

    @Override
    public String getAttachment(String key) {
        return this.getAppResponse().getAttachment(key);
    }

    @Override
    public String getAttachment(String key, String defaultValue) {
        return this.getAppResponse().getAttachment(key, defaultValue);
    }

    @Override
    public void setAttachment(String key, String value) {
        this.getAppResponse().setAttachment(key, value);
    }

    public RpcContext getStoredContext() {
        return this.storedContext;
    }

    public RpcContext getStoredServerContext() {
        return this.storedServerContext;
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public static AsyncRpcResult newDefaultAsyncResult(AppResponse appResponse, Invocation invocation) {
        AsyncRpcResult asyncRpcResult = new AsyncRpcResult(invocation);
        asyncRpcResult.complete(appResponse);
        return asyncRpcResult;
    }

    public static AsyncRpcResult newDefaultAsyncResult(Invocation invocation) {
        return AsyncRpcResult.newDefaultAsyncResult(null, null, invocation);
    }

    public static AsyncRpcResult newDefaultAsyncResult(Object value, Invocation invocation) {
        return AsyncRpcResult.newDefaultAsyncResult(value, null, invocation);
    }

    public static AsyncRpcResult newDefaultAsyncResult(Throwable t, Invocation invocation) {
        return AsyncRpcResult.newDefaultAsyncResult(null, t, invocation);
    }

    public static AsyncRpcResult newDefaultAsyncResult(Object value, Throwable t, Invocation invocation) {
        AsyncRpcResult asyncRpcResult = new AsyncRpcResult(invocation);
        AppResponse appResponse = new AppResponse();
        if (t != null) {
            appResponse.setException(t);
        } else {
            appResponse.setValue(value);
        }
        asyncRpcResult.complete(appResponse);
        return asyncRpcResult;
    }
}

