/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Properties;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.support.AbstractMetadataReport;
import org.apache.dubbo.rpc.RpcException;

public class NacosMetadataReport
extends AbstractMetadataReport {
    private static final Logger logger = LoggerFactory.getLogger(NacosMetadataReport.class);
    private ConfigService configService;
    private String group;

    public NacosMetadataReport(URL url) {
        super(url);
        this.configService = this.buildConfigService(url);
        this.group = url.getParameter("group", "dubbo");
    }

    public ConfigService buildConfigService(URL url) {
        Properties nacosProperties = this.buildNacosProperties(url);
        try {
            this.configService = NacosFactory.createConfigService((Properties)nacosProperties);
        }
        catch (NacosException e) {
            if (logger.isErrorEnabled()) {
                logger.error(e.getErrMsg(), e);
            }
            throw new IllegalStateException(e);
        }
        return this.configService;
    }

    private Properties buildNacosProperties(URL url) {
        Properties properties = new Properties();
        this.setServerAddr(url, properties);
        this.setProperties(url, properties);
        return properties;
    }

    private void setServerAddr(URL url, Properties properties) {
        StringBuilder serverAddrBuilder = new StringBuilder(url.getHost()).append(":").append(url.getPort());
        String backup = url.getParameter("backup");
        if (backup != null) {
            serverAddrBuilder.append(",").append(backup);
        }
        String serverAddr = serverAddrBuilder.toString();
        properties.put("serverAddr", serverAddr);
    }

    private void setProperties(URL url, Properties properties) {
        this.putPropertyIfAbsent(url, properties, "namespace");
        this.putPropertyIfAbsent(url, properties, "com.alibaba.nacos.naming.log.filename");
        this.putPropertyIfAbsent(url, properties, "endpoint");
        this.putPropertyIfAbsent(url, properties, "accessKey");
        this.putPropertyIfAbsent(url, properties, "secretKey");
        this.putPropertyIfAbsent(url, properties, "clusterName");
    }

    private void putPropertyIfAbsent(URL url, Properties properties, String propertyName) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty(propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        }
    }

    @Override
    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.storeMetadata(providerMetadataIdentifier, serviceDefinitions);
    }

    @Override
    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String value) {
        this.storeMetadata(consumerMetadataIdentifier, value);
    }

    private void storeMetadata(MetadataIdentifier identifier, String value) {
        try {
            boolean publishResult = this.configService.publishConfig(identifier.getUniqueKey(MetadataIdentifier.KeyTypeEnum.UNIQUE_KEY), this.group, value);
            if (!publishResult) {
                throw new RuntimeException("publish nacos metadata failed");
            }
        }
        catch (Throwable t) {
            logger.error("Failed to put " + identifier + " to nacos " + value + ", cause: " + t.getMessage(), t);
            throw new RpcException("Failed to put " + identifier + " to nacos " + value + ", cause: " + t.getMessage(), t);
        }
    }
}

