/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.status;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.status.Status;
import org.apache.dubbo.common.status.StatusChecker;
import org.apache.dubbo.config.spring.extension.SpringExtensionFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.Lifecycle;
import org.springframework.web.context.support.GenericWebApplicationContext;

@Activate
public class SpringStatusChecker
implements StatusChecker {
    private static final Logger logger = LoggerFactory.getLogger(SpringStatusChecker.class);

    @Override
    public Status check() {
        ApplicationContext context = null;
        for (ApplicationContext c : SpringExtensionFactory.getContexts()) {
            if (c instanceof GenericWebApplicationContext || c == null) continue;
            context = c;
            break;
        }
        if (context == null) {
            return new Status(Status.Level.UNKNOWN);
        }
        Status.Level level = context instanceof Lifecycle ? (((Lifecycle)context).isRunning() ? Status.Level.OK : Status.Level.ERROR) : Status.Level.UNKNOWN;
        StringBuilder buf = new StringBuilder();
        try {
            Class<?> cls = context.getClass();
            AccessibleObject method = null;
            while (cls != null && method == null) {
                try {
                    method = cls.getDeclaredMethod("getConfigLocations", new Class[0]);
                }
                catch (NoSuchMethodException t) {
                    cls = cls.getSuperclass();
                }
            }
            if (method != null) {
                String[] configs;
                if (!method.isAccessible()) {
                    ((Method)method).setAccessible(true);
                }
                if ((configs = (String[])((Method)method).invoke(context, new Object[0])) != null && configs.length > 0) {
                    for (String config : configs) {
                        if (buf.length() > 0) {
                            buf.append(",");
                        }
                        buf.append(config);
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
        return new Status(level, buf.toString());
    }
}

