/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AnnotationUtils {
    @Deprecated
    public static String resolveInterfaceName(Service service, Class<?> defaultInterfaceClass) throws IllegalStateException {
        String interfaceName;
        if (StringUtils.hasText((String)service.interfaceName())) {
            interfaceName = service.interfaceName();
        } else if (!Void.TYPE.equals(service.interfaceClass())) {
            interfaceName = service.interfaceClass().getName();
        } else if (defaultInterfaceClass.isInterface()) {
            interfaceName = defaultInterfaceClass.getName();
        } else {
            throw new IllegalStateException("The @Service undefined interfaceClass or interfaceName, and the type " + defaultInterfaceClass.getName() + " is not a interface.");
        }
        return interfaceName;
    }

    public static String resolveInterfaceName(AnnotationAttributes attributes, Class<?> defaultInterfaceClass) {
        return AnnotationUtils.resolveServiceInterfaceClass(attributes, defaultInterfaceClass).getName();
    }

    public static <T> T getAttribute(AnnotationAttributes attributes, String name) {
        return (T)attributes.get((Object)name);
    }

    public static Class<?> resolveServiceInterfaceClass(AnnotationAttributes attributes, Class<?> defaultInterfaceClass) throws IllegalArgumentException {
        Class[] allInterfaces;
        ClassLoader classLoader = defaultInterfaceClass != null ? defaultInterfaceClass.getClassLoader() : Thread.currentThread().getContextClassLoader();
        Class interfaceClass = (Class)AnnotationUtils.getAttribute(attributes, "interfaceClass");
        if (Void.TYPE.equals(interfaceClass)) {
            interfaceClass = null;
            String interfaceClassName = (String)AnnotationUtils.getAttribute(attributes, "interfaceName");
            if (StringUtils.hasText((String)interfaceClassName) && ClassUtils.isPresent((String)interfaceClassName, (ClassLoader)classLoader)) {
                interfaceClass = ClassUtils.resolveClassName((String)interfaceClassName, (ClassLoader)classLoader);
            }
        }
        if (interfaceClass == null && defaultInterfaceClass != null && (allInterfaces = ClassUtils.getAllInterfacesForClass(defaultInterfaceClass)).length > 0) {
            interfaceClass = allInterfaces[0];
        }
        Assert.notNull((Object)interfaceClass, (String)"@Service interfaceClass() or interfaceName() or interface class must be present!");
        Assert.isTrue((boolean)interfaceClass.isInterface(), (String)"The annotated type must be an interface!");
        return interfaceClass;
    }

    @Deprecated
    public static String resolveInterfaceName(Reference reference, Class<?> defaultInterfaceClass) throws IllegalStateException {
        String interfaceName;
        if (!"".equals(reference.interfaceName())) {
            interfaceName = reference.interfaceName();
        } else if (!Void.TYPE.equals(reference.interfaceClass())) {
            interfaceName = reference.interfaceClass().getName();
        } else if (defaultInterfaceClass.isInterface()) {
            interfaceName = defaultInterfaceClass.getName();
        } else {
            throw new IllegalStateException("The @Reference undefined interfaceClass or interfaceName, and the type " + defaultInterfaceClass.getName() + " is not a interface.");
        }
        return interfaceName;
    }

    public static <A extends Annotation> boolean isPresent(Method method, Class<A> annotationClass) {
        Map<ElementType, List<A>> annotationsMap = AnnotationUtils.findAnnotations(method, annotationClass);
        return !annotationsMap.isEmpty();
    }

    public static <A extends Annotation> Map<ElementType, List<A>> findAnnotations(Method method, Class<A> annotationClass) {
        ElementType[] elementTypes;
        Retention retention = annotationClass.getAnnotation(Retention.class);
        RetentionPolicy retentionPolicy = retention.value();
        if (!RetentionPolicy.RUNTIME.equals((Object)retentionPolicy)) {
            return Collections.emptyMap();
        }
        LinkedHashMap annotationsMap = new LinkedHashMap();
        Target target = annotationClass.getAnnotation(Target.class);
        for (ElementType elementType : elementTypes = target.value()) {
            LinkedList<Annotation> annotationsList = new LinkedList<Annotation>();
            switch (elementType) {
                case PARAMETER: {
                    Annotation[][] parameterAnnotations;
                    Annotation[][] annotationArray = parameterAnnotations = method.getParameterAnnotations();
                    int n = annotationArray.length;
                    for (int i = 0; i < n; ++i) {
                        Annotation[] annotations;
                        for (Annotation annotation : annotations = annotationArray[i]) {
                            if (!annotationClass.equals(annotation.annotationType())) continue;
                            annotationsList.add(annotation);
                        }
                    }
                    break;
                }
                case METHOD: {
                    Annotation annotation = org.springframework.core.annotation.AnnotationUtils.findAnnotation((Method)method, annotationClass);
                    if (annotation == null) break;
                    annotationsList.add(annotation);
                    break;
                }
                case TYPE: {
                    Class<?> beanType = method.getDeclaringClass();
                    Annotation annotation2 = org.springframework.core.annotation.AnnotationUtils.findAnnotation(beanType, annotationClass);
                    if (annotation2 == null) break;
                    annotationsList.add(annotation2);
                }
            }
            if (annotationsList.isEmpty()) continue;
            annotationsMap.put(elementType, annotationsList);
        }
        return Collections.unmodifiableMap(annotationsMap);
    }

    @Deprecated
    public static Map<String, Object> getAttributes(Annotation annotation, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        return AnnotationUtils.getAttributes(annotation, null, ignoreDefaultValue, ignoreAttributeNames);
    }

    public static Map<String, Object> getAttributes(Annotation annotation, PropertyResolver propertyResolver, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        if (annotation == null) {
            return Collections.emptyMap();
        }
        Map attributes = org.springframework.core.annotation.AnnotationUtils.getAnnotationAttributes((Annotation)annotation);
        LinkedHashMap<String, Object> actualAttributes = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : attributes.entrySet()) {
            String attributeName = (String)entry.getKey();
            Object attributeValue = entry.getValue();
            if (ignoreDefaultValue && ObjectUtils.nullSafeEquals(attributeValue, (Object)org.springframework.core.annotation.AnnotationUtils.getDefaultValue((Annotation)annotation, (String)attributeName)) || attributeValue.getClass().isAnnotation() || attributeValue.getClass().isArray() && attributeValue.getClass().getComponentType().isAnnotation()) continue;
            actualAttributes.put(attributeName, attributeValue);
        }
        return AnnotationUtils.resolvePlaceholders(actualAttributes, propertyResolver, ignoreAttributeNames);
    }

    public static Map<String, Object> resolvePlaceholders(Map<String, Object> sourceAnnotationAttributes, PropertyResolver propertyResolver, String ... ignoreAttributeNames) {
        if (CollectionUtils.isEmpty(sourceAnnotationAttributes)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String[]> resolvedAnnotationAttributes = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, Object> entry : sourceAnnotationAttributes.entrySet()) {
            String attributeName = entry.getKey();
            if (ObjectUtils.containsElement((Object[])ignoreAttributeNames, (Object)attributeName)) continue;
            String[] attributeValue = entry.getValue();
            if (attributeValue instanceof String) {
                attributeValue = AnnotationUtils.resolvePlaceholders(String.valueOf(attributeValue), propertyResolver);
            } else if (attributeValue instanceof String[]) {
                String[] values = attributeValue;
                for (int i = 0; i < values.length; ++i) {
                    values[i] = AnnotationUtils.resolvePlaceholders(values[i], propertyResolver);
                }
                attributeValue = values;
            }
            resolvedAnnotationAttributes.put(attributeName, attributeValue);
        }
        return Collections.unmodifiableMap(resolvedAnnotationAttributes);
    }

    public static AnnotationAttributes getMergedAttributes(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType, PropertyResolver propertyResolver, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        Annotation annotation = AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)annotatedElement, annotationType);
        return annotation == null ? null : AnnotationAttributes.fromMap(AnnotationUtils.getAttributes(annotation, propertyResolver, ignoreDefaultValue, ignoreAttributeNames));
    }

    private static String resolvePlaceholders(String attributeValue, PropertyResolver propertyResolver) {
        String resolvedValue = attributeValue;
        if (propertyResolver != null) {
            resolvedValue = propertyResolver.resolvePlaceholders(resolvedValue);
            resolvedValue = StringUtils.trimWhitespace((String)resolvedValue);
        }
        return resolvedValue;
    }
}

