/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.builders;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.builders.AbstractServiceBuilder;

public class ServiceBuilder<U>
extends AbstractServiceBuilder<ServiceConfig, ServiceBuilder<U>> {
    private String interfaceName;
    private Class<?> interfaceClass;
    private U ref;
    private String path;
    private List<MethodConfig> methods;
    private ProviderConfig provider;
    private String providerIds;
    private String generic;

    public ServiceBuilder<U> interfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
        return this.getThis();
    }

    public ServiceBuilder<U> interfaceClass(Class<?> interfaceClass) {
        this.interfaceClass = interfaceClass;
        return this.getThis();
    }

    public ServiceBuilder<U> ref(U ref) {
        this.ref = ref;
        return this.getThis();
    }

    public ServiceBuilder<U> path(String path) {
        this.path = path;
        return this.getThis();
    }

    public ServiceBuilder<U> addMethod(MethodConfig method) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodConfig>();
        }
        this.methods.add(method);
        return this.getThis();
    }

    public ServiceBuilder<U> addMethods(List<? extends MethodConfig> methods) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodConfig>();
        }
        this.methods.addAll(methods);
        return this.getThis();
    }

    public ServiceBuilder<U> provider(ProviderConfig provider) {
        this.provider = provider;
        return this.getThis();
    }

    public ServiceBuilder<U> providerIds(String providerIds) {
        this.providerIds = providerIds;
        return this.getThis();
    }

    public ServiceBuilder<U> generic(String generic) {
        this.generic = generic;
        return this.getThis();
    }

    @Override
    public ServiceBuilder<U> mock(String mock) {
        throw new IllegalArgumentException("mock doesn't support on provider side");
    }

    @Override
    public ServiceBuilder<U> mock(Boolean mock) {
        throw new IllegalArgumentException("mock doesn't support on provider side");
    }

    public ServiceConfig<U> build() {
        ServiceConfig<U> serviceConfig = new ServiceConfig<U>();
        super.build(serviceConfig);
        serviceConfig.setInterface(this.interfaceName);
        serviceConfig.setInterface(this.interfaceClass);
        serviceConfig.setRef(this.ref);
        serviceConfig.setPath(this.path);
        serviceConfig.setMethods(this.methods);
        serviceConfig.setProvider(this.provider);
        serviceConfig.setProviderIds(this.providerIds);
        serviceConfig.setGeneric(this.generic);
        return serviceConfig;
    }

    @Override
    protected ServiceBuilder<U> getThis() {
        return this;
    }
}

