/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.util.Utf8;
import org.apache.dubbo.common.serialize.ObjectOutput;

public class AvroObjectOutput
implements ObjectOutput {
    private static EncoderFactory encoderFactory = EncoderFactory.get();
    private BinaryEncoder encoder;

    public AvroObjectOutput(OutputStream out) {
        this.encoder = encoderFactory.binaryEncoder(out, null);
    }

    @Override
    public void writeBool(boolean v) throws IOException {
        this.encoder.writeBoolean(v);
    }

    @Override
    public void writeByte(byte v) throws IOException {
        this.encoder.writeFixed(new byte[]{v});
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.encoder.writeInt((int)v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.encoder.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.encoder.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.encoder.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.encoder.writeDouble(v);
    }

    @Override
    public void writeUTF(String v) throws IOException {
        this.encoder.writeString(new Utf8(v));
    }

    @Override
    public void writeBytes(byte[] v) throws IOException {
        this.encoder.writeString(new String(v, "utf8"));
    }

    @Override
    public void writeBytes(byte[] v, int off, int len) throws IOException {
        byte[] v2 = Arrays.copyOfRange(v, off, off + len);
        this.encoder.writeString(new String(v2, "utf8"));
    }

    @Override
    public void flushBuffer() throws IOException {
        this.encoder.flush();
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        if (obj == null) {
            this.encoder.writeNull();
            return;
        }
        ReflectDatumWriter dd = new ReflectDatumWriter(obj.getClass());
        dd.write(obj, (Encoder)this.encoder);
    }
}

