/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.integration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.timer.HashedWheelTimer;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.apache.dubbo.registry.RegistryService;
import org.apache.dubbo.registry.client.ServiceDiscoveryRegistryDirectory;
import org.apache.dubbo.registry.client.migration.ServiceDiscoveryMigrationInvoker;
import org.apache.dubbo.registry.integration.AbstractConfiguratorListener;
import org.apache.dubbo.registry.integration.DynamicDirectory;
import org.apache.dubbo.registry.integration.RegistryDirectory;
import org.apache.dubbo.registry.integration.RegistryProtocolListener;
import org.apache.dubbo.registry.retry.ReExportTask;
import org.apache.dubbo.registry.support.SkipFailbackWrapperException;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Configurator;
import org.apache.dubbo.rpc.cluster.governance.GovernanceRuleRepository;
import org.apache.dubbo.rpc.cluster.support.migration.MigrationClusterInvoker;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.protocol.InvokerWrapper;

public class RegistryProtocol
implements Protocol {
    public static final String[] DEFAULT_REGISTER_PROVIDER_KEYS = new String[]{"application", "codec", "exchanger", "serialization", "cluster", "connections", "deprecated", "group", "loadbalance", "mock", "path", "timeout", "token", "version", "warmup", "weight", "timestamp", "dubbo", "release", "dubbo.tag"};
    public static final String[] DEFAULT_REGISTER_CONSUMER_KEYS = new String[]{"application", "version", "group", "dubbo", "release"};
    private static final String REGISTRY_PROTOCOL_LISTENER_KEY = "registry.protocol.listener";
    private static final int DEFAULT_PORT = 9090;
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryProtocol.class);
    private final Map<URL, NotifyListener> overrideListeners = new ConcurrentHashMap<URL, NotifyListener>();
    private final Map<String, ServiceConfigurationListener> serviceConfigurationListeners = new ConcurrentHashMap<String, ServiceConfigurationListener>();
    private final ProviderConfigurationListener providerConfigurationListener = new ProviderConfigurationListener();
    private final ConcurrentMap<String, ExporterChangeableWrapper<?>> bounds = new ConcurrentHashMap();
    protected Protocol protocol;
    protected RegistryFactory registryFactory;
    protected ProxyFactory proxyFactory;
    private ConcurrentMap<URL, ReExportTask> reExportFailedTasks = new ConcurrentHashMap<URL, ReExportTask>();
    private HashedWheelTimer retryTimer = new HashedWheelTimer(new NamedThreadFactory("DubboReexportTimer", true), 5000L, TimeUnit.MILLISECONDS, 128);
    private static RegistryProtocol INSTANCE;

    private static String[] getHiddenKeys(URL url) {
        Map<String, String> params = url.getParameters();
        if (CollectionUtils.isNotEmptyMap(params)) {
            return (String[])params.keySet().stream().filter(k -> k.startsWith(".")).toArray(String[]::new);
        }
        return new String[0];
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setRegistryFactory(RegistryFactory registryFactory) {
        this.registryFactory = registryFactory;
    }

    public void setProxyFactory(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    @Override
    public int getDefaultPort() {
        return 9090;
    }

    public Map<URL, NotifyListener> getOverrideListeners() {
        return this.overrideListeners;
    }

    private void registerStatedUrl(URL registryUrl, URL registeredProviderUrl, boolean registered) {
        ProviderModel model = ApplicationModel.getProviderModel(registeredProviderUrl.getServiceKey());
        model.addStatedUrl(new ProviderModel.RegisterStatedURL(registeredProviderUrl, registryUrl, registered));
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> originInvoker) throws RpcException {
        URL registryUrl = this.getRegistryUrl(originInvoker);
        URL providerUrl = this.getProviderUrl(originInvoker);
        URL overrideSubscribeUrl = this.getSubscribedOverrideUrl(providerUrl);
        OverrideListener overrideSubscribeListener = new OverrideListener(overrideSubscribeUrl, originInvoker);
        this.overrideListeners.put(overrideSubscribeUrl, overrideSubscribeListener);
        providerUrl = this.overrideUrlWithConfig(providerUrl, overrideSubscribeListener);
        ExporterChangeableWrapper<T> exporter = this.doLocalExport(originInvoker, providerUrl);
        Registry registry = this.getRegistry(originInvoker);
        URL registeredProviderUrl = this.getUrlToRegistry(providerUrl, registryUrl);
        boolean register = providerUrl.getParameter("register", true);
        if (register) {
            registry.register(registeredProviderUrl);
        }
        this.registerStatedUrl(registryUrl, registeredProviderUrl, register);
        exporter.setRegisterUrl(registeredProviderUrl);
        exporter.setSubscribeUrl(overrideSubscribeUrl);
        registry.subscribe(overrideSubscribeUrl, overrideSubscribeListener);
        this.notifyExport(exporter);
        return new DestroyableExporter<T>(exporter);
    }

    private <T> void notifyExport(ExporterChangeableWrapper<T> exporter) {
        List<RegistryProtocolListener> listeners = ExtensionLoader.getExtensionLoader(RegistryProtocolListener.class).getActivateExtension(exporter.getOriginInvoker().getUrl(), REGISTRY_PROTOCOL_LISTENER_KEY);
        if (CollectionUtils.isNotEmpty(listeners)) {
            for (RegistryProtocolListener listener : listeners) {
                listener.onExport(this, exporter);
            }
        }
    }

    private URL overrideUrlWithConfig(URL providerUrl, OverrideListener listener) {
        providerUrl = this.providerConfigurationListener.overrideUrl(providerUrl);
        ServiceConfigurationListener serviceConfigurationListener = new ServiceConfigurationListener(providerUrl, listener);
        this.serviceConfigurationListeners.put(providerUrl.getServiceKey(), serviceConfigurationListener);
        return serviceConfigurationListener.overrideUrl(providerUrl);
    }

    private <T> ExporterChangeableWrapper<T> doLocalExport(Invoker<T> originInvoker, URL providerUrl) {
        String key = this.getCacheKey(originInvoker);
        return this.bounds.computeIfAbsent(key, s -> {
            InvokerDelegate invokerDelegate = new InvokerDelegate(originInvoker, providerUrl);
            return new ExporterChangeableWrapper(this.protocol.export(invokerDelegate), originInvoker);
        });
    }

    public <T> void reExport(Exporter<T> exporter, URL newInvokerUrl) {
        if (exporter instanceof ExporterChangeableWrapper) {
            ExporterChangeableWrapper exporterWrapper = (ExporterChangeableWrapper)exporter;
            Invoker originInvoker = exporterWrapper.getOriginInvoker();
            this.reExport(originInvoker, newInvokerUrl);
        }
    }

    public <T> void reExport(Invoker<T> originInvoker, URL newInvokerUrl) {
        block4: {
            String key = this.getCacheKey(originInvoker);
            ExporterChangeableWrapper exporter = (ExporterChangeableWrapper)this.bounds.get(key);
            URL registeredUrl = exporter.getRegisterUrl();
            URL registryUrl = this.getRegistryUrl(originInvoker);
            URL newProviderUrl = this.getUrlToRegistry(newInvokerUrl, registryUrl);
            InvokerDelegate<T> invokerDelegate = new InvokerDelegate<T>(originInvoker, newInvokerUrl);
            exporter.setExporter(this.protocol.export(invokerDelegate));
            if (!newProviderUrl.equals(registeredUrl)) {
                try {
                    this.doReExport(originInvoker, exporter, registryUrl, registeredUrl, newProviderUrl);
                }
                catch (Exception e) {
                    ReExportTask oldTask = (ReExportTask)this.reExportFailedTasks.get(registeredUrl);
                    if (oldTask != null) {
                        return;
                    }
                    ReExportTask task = new ReExportTask(() -> this.doReExport(originInvoker, exporter, registryUrl, registeredUrl, newProviderUrl), registeredUrl, null);
                    oldTask = this.reExportFailedTasks.putIfAbsent(registeredUrl, task);
                    if (oldTask != null) break block4;
                    this.retryTimer.newTimeout(task, registryUrl.getParameter("retry.period", 5000), TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    private <T> void doReExport(Invoker<T> originInvoker, ExporterChangeableWrapper<T> exporter, URL registryUrl, URL oldProviderUrl, URL newProviderUrl) {
        if (this.getProviderUrl(originInvoker).getParameter("register", true)) {
            Registry registry = null;
            try {
                registry = this.getRegistry(originInvoker);
            }
            catch (Exception e) {
                throw new SkipFailbackWrapperException(e);
            }
            LOGGER.info("Try to unregister old url: " + oldProviderUrl);
            registry.reExportUnregister(oldProviderUrl);
            LOGGER.info("Try to register new url: " + newProviderUrl);
            registry.reExportRegister(newProviderUrl);
        }
        try {
            ProviderModel.RegisterStatedURL statedUrl = this.getStatedUrl(registryUrl, newProviderUrl);
            statedUrl.setProviderUrl(newProviderUrl);
            exporter.setRegisterUrl(newProviderUrl);
        }
        catch (Exception e) {
            throw new SkipFailbackWrapperException(e);
        }
    }

    private ProviderModel.RegisterStatedURL getStatedUrl(URL registryUrl, URL providerUrl) {
        ProviderModel providerModel = ApplicationModel.getServiceRepository().lookupExportedService(providerUrl.getServiceKey());
        List<ProviderModel.RegisterStatedURL> statedUrls = providerModel.getStatedUrl();
        return statedUrls.stream().filter(u -> u.getRegistryUrl().equals(registryUrl) && u.getProviderUrl().getProtocol().equals(providerUrl.getProtocol())).findFirst().orElseThrow(() -> new IllegalStateException("There should have at least one registered url."));
    }

    protected Registry getRegistry(Invoker<?> originInvoker) {
        URL registryUrl = this.getRegistryUrl(originInvoker);
        return this.getRegistry(registryUrl);
    }

    protected Registry getRegistry(URL url) {
        try {
            return this.registryFactory.getRegistry(url);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw t;
        }
    }

    protected URL getRegistryUrl(Invoker<?> originInvoker) {
        return originInvoker.getUrl();
    }

    protected URL getRegistryUrl(URL url) {
        if ("service-discovery-registry".equals(url.getProtocol())) {
            return url;
        }
        return url.addParameter("registry", url.getProtocol()).setProtocol("service-discovery-registry");
    }

    private URL getUrlToRegistry(URL providerUrl, URL registryUrl) {
        URL registeredProviderUrl = this.removeUselessParameters(providerUrl);
        if (!registryUrl.getParameter("simplified", false)) {
            return registeredProviderUrl.removeParameters(RegistryProtocol.getHiddenKeys(registeredProviderUrl)).removeParameters("monitor", "bind.ip", "bind.port", "qos.enable", "qos.host", "qos.port", "qos.accept.foreign.ip", "validation", "interfaces");
        }
        String extraKeys = registryUrl.getParameter("extra-keys", "");
        if (!registeredProviderUrl.getPath().equals(registeredProviderUrl.getParameter("interface"))) {
            if (StringUtils.isNotEmpty(extraKeys)) {
                extraKeys = extraKeys + ",";
            }
            extraKeys = extraKeys + "interface";
        }
        String[] paramsToRegistry = this.getParamsToRegistry(DEFAULT_REGISTER_PROVIDER_KEYS, CommonConstants.COMMA_SPLIT_PATTERN.split(extraKeys));
        return URL.valueOf(registeredProviderUrl, paramsToRegistry, registeredProviderUrl.getParameter("methods", (String[])null));
    }

    private URL removeUselessParameters(URL providerUrl) {
        return providerUrl.removeParameters("onconnect", "ondisconnect");
    }

    private URL getSubscribedOverrideUrl(URL registeredProviderUrl) {
        return registeredProviderUrl.setProtocol("provider").addParameters("category", "configurators", "check", String.valueOf(false));
    }

    private URL getProviderUrl(Invoker<?> originInvoker) {
        String export = originInvoker.getUrl().getParameterAndDecoded("export");
        if (export == null || export.length() == 0) {
            throw new IllegalArgumentException("The registry export url is null! registry: " + originInvoker.getUrl());
        }
        return URL.valueOf(export);
    }

    private String getCacheKey(Invoker<?> originInvoker) {
        URL providerUrl = this.getProviderUrl(originInvoker);
        String key = providerUrl.removeParameters("dynamic", "enabled").toFullString();
        return key;
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        url = this.getRegistryUrl(url);
        Registry registry = this.getRegistry(url);
        if (RegistryService.class.equals(type)) {
            return this.proxyFactory.getInvoker(registry, type, url);
        }
        Map<String, String> qs = StringUtils.parseQueryString(url.getParameterAndDecoded("refer"));
        String group = qs.get("group");
        if (group != null && group.length() > 0 && (CommonConstants.COMMA_SPLIT_PATTERN.split(group).length > 1 || "*".equals(group))) {
            return this.doRefer(Cluster.getCluster("mergeable"), registry, type, url, qs);
        }
        Cluster cluster = Cluster.getCluster(qs.get("cluster"));
        return this.doRefer(cluster, registry, type, url, qs);
    }

    protected <T> Invoker<T> doRefer(Cluster cluster, Registry registry, Class<T> type, URL url, Map<String, String> parameters) {
        URL consumerUrl = new URL("consumer", parameters.remove("register.ip"), 0, type.getName(), parameters);
        ClusterInvoker<T> migrationInvoker = this.getMigrationInvoker(this, cluster, registry, type, url, consumerUrl);
        return this.interceptInvoker(migrationInvoker, url, consumerUrl);
    }

    protected <T> ClusterInvoker<T> getMigrationInvoker(RegistryProtocol registryProtocol, Cluster cluster, Registry registry, Class<T> type, URL url, URL consumerUrl) {
        return new ServiceDiscoveryMigrationInvoker<T>(registryProtocol, cluster, registry, type, url, consumerUrl);
    }

    protected <T> Invoker<T> interceptInvoker(ClusterInvoker<T> invoker, URL url, URL consumerUrl) {
        List<RegistryProtocolListener> listeners = this.findRegistryProtocolListeners(url);
        if (CollectionUtils.isEmpty(listeners)) {
            return invoker;
        }
        for (RegistryProtocolListener listener : listeners) {
            listener.onRefer(this, invoker, consumerUrl);
        }
        return invoker;
    }

    public <T> ClusterInvoker<T> getServiceDiscoveryInvoker(Cluster cluster, Registry registry, Class<T> type, URL url) {
        ServiceDiscoveryRegistryDirectory<T> directory = new ServiceDiscoveryRegistryDirectory<T>(type, url);
        return this.doCreateInvoker(directory, cluster, registry, type);
    }

    public <T> ClusterInvoker<T> getInvoker(Cluster cluster, Registry registry, Class<T> type, URL url) {
        RegistryDirectory<T> directory = new RegistryDirectory<T>(type, url);
        return this.doCreateInvoker(directory, cluster, registry, type);
    }

    protected <T> ClusterInvoker<T> doCreateInvoker(DynamicDirectory<T> directory, Cluster cluster, Registry registry, Class<T> type) {
        directory.setRegistry(registry);
        directory.setProtocol(this.protocol);
        HashMap<String, String> parameters = new HashMap<String, String>(directory.getConsumerUrl().getParameters());
        URL urlToRegistry = new URL("consumer", (String)parameters.remove("register.ip"), 0, type.getName(), parameters);
        if (directory.isShouldRegister()) {
            directory.setRegisteredConsumerUrl(urlToRegistry);
            registry.register(directory.getRegisteredConsumerUrl());
        }
        directory.buildRouterChain(urlToRegistry);
        directory.subscribe(RegistryProtocol.toSubscribeUrl(urlToRegistry));
        return (ClusterInvoker)cluster.join(directory);
    }

    public <T> void reRefer(ClusterInvoker<?> invoker, URL newSubscribeUrl) {
        if (!(invoker instanceof MigrationClusterInvoker)) {
            LOGGER.error("Only invoker type of MigrationClusterInvoker supports reRefer, current invoker is " + invoker.getClass());
            return;
        }
        MigrationClusterInvoker migrationClusterInvoker = (MigrationClusterInvoker)invoker;
        migrationClusterInvoker.reRefer(newSubscribeUrl);
    }

    public static URL toSubscribeUrl(URL url) {
        return url.addParameter("category", "providers,configurators,routers");
    }

    protected List<RegistryProtocolListener> findRegistryProtocolListeners(URL url) {
        return ExtensionLoader.getExtensionLoader(RegistryProtocolListener.class).getActivateExtension(url, REGISTRY_PROTOCOL_LISTENER_KEY);
    }

    public String[] getParamsToRegistry(String[] defaultKeys, String[] additionalParameterKeys) {
        int additionalLen = additionalParameterKeys.length;
        String[] registryParams = new String[defaultKeys.length + additionalLen];
        System.arraycopy(defaultKeys, 0, registryParams, 0, defaultKeys.length);
        System.arraycopy(additionalParameterKeys, 0, registryParams, defaultKeys.length, additionalLen);
        return registryParams;
    }

    @Override
    public void destroy() {
        List<RegistryProtocolListener> listeners = ExtensionLoader.getExtensionLoader(RegistryProtocolListener.class).getLoadedExtensionInstances();
        if (CollectionUtils.isNotEmpty(listeners)) {
            for (RegistryProtocolListener registryProtocolListener : listeners) {
                registryProtocolListener.onDestroy();
            }
        }
        ArrayList exporters = new ArrayList(this.bounds.values());
        for (Exporter exporter : exporters) {
            exporter.unexport();
        }
        this.bounds.clear();
        String string = ApplicationModel.tryGetApplication();
        if (string == null) {
            return;
        }
        ExtensionLoader.getExtensionLoader(GovernanceRuleRepository.class).getDefaultExtension().removeListener(string + ".configurators", this.providerConfigurationListener);
    }

    @Override
    public List<ProtocolServer> getServers() {
        return this.protocol.getServers();
    }

    private static URL getConfiguredInvokerUrl(List<Configurator> configurators, URL url) {
        if (configurators != null && configurators.size() > 0) {
            for (Configurator configurator : configurators) {
                url = configurator.configure(url);
            }
        }
        return url;
    }

    public RegistryProtocol() {
        INSTANCE = this;
    }

    public static RegistryProtocol getRegistryProtocol() {
        if (INSTANCE == null) {
            ExtensionLoader.getExtensionLoader(Protocol.class).getExtension("registry");
        }
        return INSTANCE;
    }

    private class ExporterChangeableWrapper<T>
    implements Exporter<T> {
        private final ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("Exporter-Unexport", true));
        private final Invoker<T> originInvoker;
        private Exporter<T> exporter;
        private URL subscribeUrl;
        private URL registerUrl;
        private AtomicBoolean unexported = new AtomicBoolean(false);

        public ExporterChangeableWrapper(Exporter<T> exporter, Invoker<T> originInvoker) {
            this.exporter = exporter;
            this.originInvoker = originInvoker;
        }

        public Invoker<T> getOriginInvoker() {
            return this.originInvoker;
        }

        @Override
        public Invoker<T> getInvoker() {
            return this.exporter.getInvoker();
        }

        public void setExporter(Exporter<T> exporter) {
            this.exporter = exporter;
        }

        @Override
        public void unexport() {
            if (!this.unexported.compareAndSet(false, true)) {
                return;
            }
            String key = RegistryProtocol.this.getCacheKey(this.originInvoker);
            RegistryProtocol.this.bounds.remove(key);
            Registry registry = RegistryProtocol.this.getRegistry(this.originInvoker);
            try {
                registry.unregister(this.registerUrl);
            }
            catch (Throwable t) {
                LOGGER.warn(t.getMessage(), t);
            }
            try {
                NotifyListener listener = (NotifyListener)RegistryProtocol.this.overrideListeners.remove(this.subscribeUrl);
                registry.unsubscribe(this.subscribeUrl, listener);
                ExtensionLoader.getExtensionLoader(GovernanceRuleRepository.class).getDefaultExtension().removeListener(this.subscribeUrl.getServiceKey() + ".configurators", (ConfigurationListener)RegistryProtocol.this.serviceConfigurationListeners.get(this.subscribeUrl.getServiceKey()));
            }
            catch (Throwable t) {
                LOGGER.warn(t.getMessage(), t);
            }
            this.executor.submit(() -> {
                try {
                    int timeout = ConfigurationUtils.getServerShutdownTimeout();
                    if (timeout > 0) {
                        LOGGER.info("Waiting " + timeout + "ms for registry to notify all consumers before unexport. Usually, this is called when you use dubbo API");
                        Thread.sleep(timeout);
                    }
                    this.exporter.unexport();
                }
                catch (Throwable t) {
                    LOGGER.warn(t.getMessage(), t);
                }
            });
        }

        public void setSubscribeUrl(URL subscribeUrl) {
            this.subscribeUrl = subscribeUrl;
        }

        public void setRegisterUrl(URL registerUrl) {
            this.registerUrl = registerUrl;
        }

        public URL getRegisterUrl() {
            return this.registerUrl;
        }
    }

    private class ProviderConfigurationListener
    extends AbstractConfiguratorListener {
        public ProviderConfigurationListener() {
            this.initWith(ApplicationModel.getApplication() + ".configurators");
        }

        private <T> URL overrideUrl(URL providerUrl) {
            return RegistryProtocol.getConfiguredInvokerUrl(this.configurators, providerUrl);
        }

        @Override
        protected void notifyOverrides() {
            RegistryProtocol.this.overrideListeners.values().forEach(listener -> ((OverrideListener)listener).doOverrideIfNecessary());
        }
    }

    private class ServiceConfigurationListener
    extends AbstractConfiguratorListener {
        private URL providerUrl;
        private OverrideListener notifyListener;

        public ServiceConfigurationListener(URL providerUrl, OverrideListener notifyListener) {
            this.providerUrl = providerUrl;
            this.notifyListener = notifyListener;
            this.initWith(DynamicConfiguration.getRuleKey(providerUrl) + ".configurators");
        }

        private <T> URL overrideUrl(URL providerUrl) {
            return RegistryProtocol.getConfiguredInvokerUrl(this.configurators, providerUrl);
        }

        @Override
        protected void notifyOverrides() {
            this.notifyListener.doOverrideIfNecessary();
        }
    }

    private class OverrideListener
    implements NotifyListener {
        private final URL subscribeUrl;
        private final Invoker originInvoker;
        private List<Configurator> configurators;

        public OverrideListener(URL subscribeUrl, Invoker originalInvoker) {
            this.subscribeUrl = subscribeUrl;
            this.originInvoker = originalInvoker;
        }

        @Override
        public synchronized void notify(List<URL> urls) {
            LOGGER.debug("original override urls: " + urls);
            List<URL> matchedUrls = this.getMatchedUrls(urls, this.subscribeUrl.addParameter("category", "configurators"));
            LOGGER.debug("subscribe url: " + this.subscribeUrl + ", override urls: " + matchedUrls);
            if (matchedUrls.isEmpty()) {
                return;
            }
            this.configurators = Configurator.toConfigurators(UrlUtils.classifyUrls(matchedUrls, UrlUtils::isConfigurator)).orElse(this.configurators);
            this.doOverrideIfNecessary();
        }

        public synchronized void doOverrideIfNecessary() {
            Invoker invoker = this.originInvoker instanceof InvokerDelegate ? ((InvokerDelegate)this.originInvoker).getInvoker() : this.originInvoker;
            URL originUrl = RegistryProtocol.this.getProviderUrl(invoker);
            String key = RegistryProtocol.this.getCacheKey(this.originInvoker);
            ExporterChangeableWrapper exporter = (ExporterChangeableWrapper)RegistryProtocol.this.bounds.get(key);
            if (exporter == null) {
                LOGGER.warn(new IllegalStateException("error state, exporter should not be null"));
                return;
            }
            Invoker exporterInvoker = exporter.getInvoker();
            URL currentUrl = exporterInvoker == null ? null : exporterInvoker.getUrl();
            URL newUrl = RegistryProtocol.getConfiguredInvokerUrl(this.configurators, originUrl);
            newUrl = RegistryProtocol.getConfiguredInvokerUrl(RegistryProtocol.this.providerConfigurationListener.getConfigurators(), newUrl);
            newUrl = RegistryProtocol.getConfiguredInvokerUrl(((ServiceConfigurationListener)RegistryProtocol.this.serviceConfigurationListeners.get(originUrl.getServiceKey())).getConfigurators(), newUrl);
            if (!newUrl.equals(currentUrl)) {
                if (newUrl.getParameter("need-reexport", true)) {
                    RegistryProtocol.this.reExport(this.originInvoker, newUrl);
                }
                LOGGER.info("exported provider url changed, origin url: " + originUrl + ", old export url: " + currentUrl + ", new export url: " + newUrl);
            }
        }

        private List<URL> getMatchedUrls(List<URL> configuratorUrls, URL currentSubscribe) {
            ArrayList<URL> result = new ArrayList<URL>();
            Iterator<URL> iterator = configuratorUrls.iterator();
            while (iterator.hasNext()) {
                URL url;
                URL overrideUrl = url = iterator.next();
                if (url.getParameter("category") == null && "override".equals(url.getProtocol())) {
                    overrideUrl = url.addParameter("category", "configurators");
                }
                if (!UrlUtils.isMatch(currentSubscribe, overrideUrl)) continue;
                result.add(url);
            }
            return result;
        }
    }

    private static class DestroyableExporter<T>
    implements Exporter<T> {
        private Exporter<T> exporter;

        public DestroyableExporter(Exporter<T> exporter) {
            this.exporter = exporter;
        }

        @Override
        public Invoker<T> getInvoker() {
            return this.exporter.getInvoker();
        }

        @Override
        public void unexport() {
            this.exporter.unexport();
        }
    }

    public static class InvokerDelegate<T>
    extends InvokerWrapper<T> {
        private final Invoker<T> invoker;

        public InvokerDelegate(Invoker<T> invoker, URL url) {
            super(invoker, url);
            this.invoker = invoker;
        }

        public Invoker<T> getInvoker() {
            if (this.invoker instanceof InvokerDelegate) {
                return ((InvokerDelegate)this.invoker).getInvoker();
            }
            return this.invoker;
        }
    }
}

