/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.consul;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;

public enum ConsulParameter {
    ACL_TOKEN,
    TAGS,
    INSTANCE_ZONE,
    DEFAULT_ZONE_METADATA_NAME("zone"),
    INSTANCE_GROUP,
    CONSISTENCY_MODE;

    private final String name;
    private final String defaultValue;

    private ConsulParameter() {
        this(null);
    }

    private ConsulParameter(String defaultValue) {
        this(null, defaultValue);
    }

    private ConsulParameter(String name, String defaultValue) {
        this.name = StringUtils.isBlank(name) ? this.defaultName() : name;
        this.defaultValue = defaultValue;
    }

    private String defaultName() {
        return this.name().toLowerCase().replace('_', '-');
    }

    public String getValue(URL registryURL) {
        return registryURL.getParameter(this.name, this.defaultValue);
    }

    public <T> T getValue(URL registryURL, Class<T> valueType, T defaultValue) {
        return registryURL.getParameter(this.name, valueType, defaultValue);
    }
}

