/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.TimeoutException;
import org.apache.dubbo.remoting.exchange.ExchangeClient;
import org.apache.dubbo.remoting.exchange.support.header.HeaderExchangeClient;
import org.apache.dubbo.remoting.transport.ClientDelegate;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.protocol.AbstractInvoker;
import org.apache.dubbo.rpc.support.RpcUtils;

class ChannelWrappedInvoker<T>
extends AbstractInvoker<T> {
    private final Channel channel;
    private final String serviceKey;
    private final ExchangeClient currentClient;

    ChannelWrappedInvoker(Class<T> serviceType, Channel channel, URL url, String serviceKey) {
        super(serviceType, url, new String[]{"group", "token"});
        this.channel = channel;
        this.serviceKey = serviceKey;
        this.currentClient = new HeaderExchangeClient(new ChannelWrapper(this.channel), false);
    }

    @Override
    protected Result doInvoke(Invocation invocation) throws Throwable {
        RpcInvocation inv = (RpcInvocation)invocation;
        inv.setAttachment("path", this.getInterface().getName());
        inv.setAttachment("callback.service.instid", this.serviceKey);
        try {
            if (RpcUtils.isOneway(this.getUrl(), inv)) {
                this.currentClient.send(inv, this.getUrl().getMethodParameter(invocation.getMethodName(), "sent", false));
                return AsyncRpcResult.newDefaultAsyncResult(invocation);
            }
            String methodName = RpcUtils.getMethodName(invocation);
            int timeout = (int)RpcUtils.getTimeout(this.getUrl(), methodName, RpcContext.getContext(), 1000L);
            CompletionStage appResponseFuture = this.currentClient.request(inv, timeout, null).thenApply(obj -> (AppResponse)obj);
            return new AsyncRpcResult((CompletableFuture<AppResponse>)appResponseFuture, inv);
        }
        catch (RpcException e) {
            throw e;
        }
        catch (TimeoutException e) {
            throw new RpcException(2, e.getMessage(), e);
        }
        catch (RemotingException e) {
            throw new RpcException(1, e.getMessage(), e);
        }
        catch (Throwable e) {
            throw new RpcException(e.getMessage(), e);
        }
    }

    @Override
    public void destroy() {
    }

    public static class ChannelWrapper
    extends ClientDelegate {
        private final Channel channel;
        private final URL url;

        ChannelWrapper(Channel channel) {
            this.channel = channel;
            this.url = channel.getUrl().addParameter("codec", "dubbo");
        }

        @Override
        public URL getUrl() {
            return this.url;
        }

        @Override
        public ChannelHandler getChannelHandler() {
            return this.channel.getChannelHandler();
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return this.channel.getLocalAddress();
        }

        @Override
        public void close() {
            this.channel.close();
        }

        @Override
        public boolean isClosed() {
            return this.channel == null || this.channel.isClosed();
        }

        @Override
        public void reset(URL url) {
            throw new RpcException("ChannelInvoker can not reset.");
        }

        @Override
        public InetSocketAddress getRemoteAddress() {
            return this.channel.getLocalAddress();
        }

        @Override
        public boolean isConnected() {
            return this.channel != null && this.channel.isConnected();
        }

        @Override
        public boolean hasAttribute(String key) {
            return this.channel.hasAttribute(key);
        }

        @Override
        public Object getAttribute(String key) {
            return this.channel.getAttribute(key);
        }

        @Override
        public void setAttribute(String key, Object value) {
            this.channel.setAttribute(key, value);
        }

        @Override
        public void removeAttribute(String key) {
            this.channel.removeAttribute(key);
        }

        @Override
        public void reconnect() throws RemotingException {
        }

        @Override
        public void send(Object message) throws RemotingException {
            this.channel.send(message);
        }

        @Override
        public void send(Object message, boolean sent) throws RemotingException {
            this.channel.send(message, sent);
        }
    }
}

