/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.multiple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.apache.dubbo.registry.support.AbstractRegistry;

public class MultipleRegistry
extends AbstractRegistry {
    public static final String REGISTRY_FOR_SERVICE = "service-registry";
    public static final String REGISTRY_FOR_REFERENCE = "reference-registry";
    protected RegistryFactory registryFactory = ExtensionLoader.getExtensionLoader(RegistryFactory.class).getAdaptiveExtension();
    private final Map<String, Registry> serviceRegistries = new ConcurrentHashMap<String, Registry>(4);
    private final Map<String, Registry> referenceRegistries = new ConcurrentHashMap<String, Registry>(4);
    private final Map<NotifyListener, MultipleNotifyListenerWrapper> multipleNotifyListenerMap = new ConcurrentHashMap<NotifyListener, MultipleNotifyListenerWrapper>(32);
    protected List<String> origServiceRegistryURLs;
    protected List<String> origReferenceRegistryURLs;
    protected List<String> effectServiceRegistryURLs;
    protected List<String> effectReferenceRegistryURLs;
    private URL registryUrl;
    private String applicationName;

    public MultipleRegistry(URL url) {
        super(url);
        this.registryUrl = url;
        this.applicationName = url.getParameter("application");
        this.init();
        this.checkApplicationName(this.applicationName);
        this.origServiceRegistryURLs = url.getParameter(REGISTRY_FOR_SERVICE, new ArrayList<String>());
        this.origReferenceRegistryURLs = url.getParameter(REGISTRY_FOR_REFERENCE, new ArrayList<String>());
        this.effectServiceRegistryURLs = this.filterServiceRegistry(this.origServiceRegistryURLs);
        this.effectReferenceRegistryURLs = this.filterReferenceRegistry(this.origReferenceRegistryURLs);
        boolean defaultRegistry = url.getParameter("default", true);
        if (defaultRegistry && this.effectServiceRegistryURLs.isEmpty() && this.effectReferenceRegistryURLs.isEmpty()) {
            throw new IllegalArgumentException("Illegal registry url. You need to configure parameter service-registry or reference-registry");
        }
        HashSet<String> allURLs = new HashSet<String>(this.effectServiceRegistryURLs);
        allURLs.addAll(this.effectReferenceRegistryURLs);
        HashMap<String, Registry> tmpMap = new HashMap<String, Registry>(4);
        for (String tmpUrl : allURLs) {
            tmpMap.put(tmpUrl, this.registryFactory.getRegistry(URL.valueOf(tmpUrl)));
        }
        for (String serviceRegistyURL : this.effectServiceRegistryURLs) {
            this.serviceRegistries.put(serviceRegistyURL, (Registry)tmpMap.get(serviceRegistyURL));
        }
        for (String referenceReigstyURL : this.effectReferenceRegistryURLs) {
            this.referenceRegistries.put(referenceReigstyURL, (Registry)tmpMap.get(referenceReigstyURL));
        }
    }

    @Override
    public URL getUrl() {
        return this.registryUrl;
    }

    @Override
    public boolean isAvailable() {
        boolean available = this.serviceRegistries.isEmpty();
        for (Registry serviceRegistry : this.serviceRegistries.values()) {
            if (!serviceRegistry.isAvailable()) continue;
            available = true;
        }
        if (!available) {
            return false;
        }
        available = this.referenceRegistries.isEmpty();
        for (Registry referenceRegistry : this.referenceRegistries.values()) {
            if (!referenceRegistry.isAvailable()) continue;
            available = true;
        }
        return available;
    }

    @Override
    public void destroy() {
        HashSet<Registry> registries = new HashSet<Registry>(this.serviceRegistries.values());
        registries.addAll(this.referenceRegistries.values());
        for (Registry registry : registries) {
            registry.destroy();
        }
    }

    @Override
    public void register(URL url) {
        super.register(url);
        for (Registry registry : this.serviceRegistries.values()) {
            registry.register(url);
        }
    }

    @Override
    public void unregister(URL url) {
        super.unregister(url);
        for (Registry registry : this.serviceRegistries.values()) {
            registry.unregister(url);
        }
    }

    @Override
    public void subscribe(URL url, NotifyListener listener) {
        MultipleNotifyListenerWrapper multipleNotifyListenerWrapper = new MultipleNotifyListenerWrapper(listener);
        this.multipleNotifyListenerMap.put(listener, multipleNotifyListenerWrapper);
        for (Registry registry : this.referenceRegistries.values()) {
            SingleNotifyListener singleNotifyListener = new SingleNotifyListener(multipleNotifyListenerWrapper, registry);
            multipleNotifyListenerWrapper.putRegistryMap(registry.getUrl(), singleNotifyListener);
            registry.subscribe(url, singleNotifyListener);
        }
        super.subscribe(url, multipleNotifyListenerWrapper);
    }

    @Override
    public void unsubscribe(URL url, NotifyListener listener) {
        MultipleNotifyListenerWrapper notifyListener = this.multipleNotifyListenerMap.remove(listener);
        for (Registry registry : this.referenceRegistries.values()) {
            SingleNotifyListener singleNotifyListener = notifyListener.registryMap.get(registry.getUrl());
            registry.unsubscribe(url, singleNotifyListener);
        }
        if (notifyListener != null) {
            super.unsubscribe(url, notifyListener);
            notifyListener.destroy();
        }
    }

    @Override
    public List<URL> lookup(URL url) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Registry registry : this.referenceRegistries.values()) {
            List<URL> tmpUrls = registry.lookup(url);
            if (CollectionUtils.isEmpty(tmpUrls)) continue;
            urls.addAll(tmpUrls);
        }
        return urls;
    }

    protected void init() {
    }

    protected List<String> filterServiceRegistry(List<String> serviceRegistryURLs) {
        return serviceRegistryURLs;
    }

    protected List<String> filterReferenceRegistry(List<String> referenceRegistryURLs) {
        return referenceRegistryURLs;
    }

    protected void checkApplicationName(String applicationName) {
    }

    protected String getApplicationName() {
        return this.applicationName;
    }

    public Map<String, Registry> getServiceRegistries() {
        return this.serviceRegistries;
    }

    public Map<String, Registry> getReferenceRegistries() {
        return this.referenceRegistries;
    }

    public List<String> getOrigServiceRegistryURLs() {
        return this.origServiceRegistryURLs;
    }

    public List<String> getOrigReferenceRegistryURLs() {
        return this.origReferenceRegistryURLs;
    }

    public List<String> getEffectServiceRegistryURLs() {
        return this.effectServiceRegistryURLs;
    }

    public List<String> getEffectReferenceRegistryURLs() {
        return this.effectReferenceRegistryURLs;
    }

    protected static class SingleNotifyListener
    implements NotifyListener {
        MultipleNotifyListenerWrapper multipleNotifyListenerWrapper;
        Registry registry;
        volatile List<URL> urlList;

        public SingleNotifyListener(MultipleNotifyListenerWrapper multipleNotifyListenerWrapper, Registry registry) {
            this.registry = registry;
            this.multipleNotifyListenerWrapper = multipleNotifyListenerWrapper;
        }

        @Override
        public synchronized void notify(List<URL> urls) {
            this.urlList = urls;
            if (this.multipleNotifyListenerWrapper != null) {
                this.multipleNotifyListenerWrapper.notifySourceListener();
            }
        }

        public void destroy() {
            this.multipleNotifyListenerWrapper = null;
            this.registry = null;
        }

        public List<URL> getUrlList() {
            return this.urlList;
        }
    }

    protected static class MultipleNotifyListenerWrapper
    implements NotifyListener {
        Map<URL, SingleNotifyListener> registryMap = new ConcurrentHashMap<URL, SingleNotifyListener>(4);
        NotifyListener sourceNotifyListener;

        public MultipleNotifyListenerWrapper(NotifyListener sourceNotifyListener) {
            this.sourceNotifyListener = sourceNotifyListener;
        }

        public void putRegistryMap(URL registryURL, SingleNotifyListener singleNotifyListener) {
            this.registryMap.put(registryURL, singleNotifyListener);
        }

        public void destroy() {
            for (SingleNotifyListener singleNotifyListener : this.registryMap.values()) {
                if (singleNotifyListener == null) continue;
                singleNotifyListener.destroy();
            }
            this.registryMap.clear();
            this.sourceNotifyListener = null;
        }

        public synchronized void notifySourceListener() {
            ArrayList<URL> notifyURLs = new ArrayList<URL>();
            URL emptyURL = null;
            for (SingleNotifyListener singleNotifyListener : this.registryMap.values()) {
                List<URL> tmpUrls = singleNotifyListener.getUrlList();
                if (CollectionUtils.isEmpty(tmpUrls)) continue;
                if (tmpUrls.size() == 1 && tmpUrls.get(0) != null && "empty".equals(tmpUrls.get(0).getProtocol())) {
                    if (emptyURL != null) continue;
                    emptyURL = tmpUrls.get(0);
                    continue;
                }
                notifyURLs.addAll(tmpUrls);
            }
            if (emptyURL != null && notifyURLs.isEmpty()) {
                notifyURLs.add(emptyURL);
            }
            this.notify(notifyURLs);
        }

        @Override
        public void notify(List<URL> urls) {
            this.sourceNotifyListener.notify(urls);
        }

        public Map<URL, SingleNotifyListener> getRegistryMap() {
            return this.registryMap;
        }
    }
}

