/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.Collection;
import java.util.Set;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.apache.dubbo.registry.support.ProviderConsumerRegTable;
import org.apache.dubbo.registry.support.ProviderInvokerWrapper;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ProviderModel;

@Cmd(name="offline", summary="offline dubbo", example={"offline dubbo", "offline xx.xx.xxx.service"})
public class Offline
implements BaseCommand {
    private Logger logger = LoggerFactory.getLogger(Offline.class);
    private RegistryFactory registryFactory = ExtensionLoader.getExtensionLoader(RegistryFactory.class).getAdaptiveExtension();

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        this.logger.info("receive offline command");
        String servicePattern = ".*";
        if (args != null && args.length > 0) {
            servicePattern = args[0];
        }
        boolean hasService = false;
        Collection<ProviderModel> providerModelList = ApplicationModel.allProviderModels();
        for (ProviderModel providerModel : providerModelList) {
            if (!providerModel.getServiceName().matches(servicePattern)) continue;
            hasService = true;
            Set<ProviderInvokerWrapper> providerInvokerWrapperSet = ProviderConsumerRegTable.getProviderInvoker(providerModel.getServiceName());
            for (ProviderInvokerWrapper providerInvokerWrapper : providerInvokerWrapperSet) {
                if (!providerInvokerWrapper.isReg()) continue;
                Registry registry = this.registryFactory.getRegistry(providerInvokerWrapper.getRegistryUrl());
                registry.unregister(providerInvokerWrapper.getProviderUrl());
                providerInvokerWrapper.setReg(false);
            }
        }
        if (hasService) {
            return "OK";
        }
        return "service not found";
    }
}

