/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.metadata.definition.builder.DefaultTypeBuilder;
import org.apache.dubbo.metadata.definition.builder.TypeBuilder;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

public class TypeDefinitionBuilder {
    private static final List<TypeBuilder> BUILDERS;
    private Map<Class<?>, TypeDefinition> typeCache = new HashMap();

    public static TypeDefinition build(Type type, Class<?> clazz, Map<Class<?>, TypeDefinition> typeCache) {
        TypeBuilder builder = TypeDefinitionBuilder.getGenericTypeBuilder(type, clazz);
        TypeDefinition td = builder != null ? builder.build(type, clazz, typeCache) : DefaultTypeBuilder.build(clazz, typeCache);
        return td;
    }

    private static TypeBuilder getGenericTypeBuilder(Type type, Class<?> clazz) {
        for (TypeBuilder builder : BUILDERS) {
            if (!builder.accept(type, clazz)) continue;
            return builder;
        }
        return null;
    }

    public TypeDefinition build(Type type, Class<?> clazz) {
        return TypeDefinitionBuilder.build(type, clazz, this.typeCache);
    }

    public List<TypeDefinition> getTypeDefinitions() {
        return new ArrayList<TypeDefinition>(this.typeCache.values());
    }

    static {
        ArrayList<TypeBuilder> builders = new ArrayList<TypeBuilder>();
        ExtensionLoader<TypeBuilder> extensionLoader = ExtensionLoader.getExtensionLoader(TypeBuilder.class);
        for (String extensionName : extensionLoader.getSupportedExtensions()) {
            builders.add(extensionLoader.getExtension(extensionName));
        }
        BUILDERS = builders;
    }
}

