/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.grpc;

import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.HandlerRegistry;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceRepository;
import org.apache.dubbo.rpc.protocol.AbstractProxyProtocol;
import org.apache.dubbo.rpc.protocol.grpc.DubboHandlerRegistry;
import org.apache.dubbo.rpc.protocol.grpc.GrpcInvoker;
import org.apache.dubbo.rpc.protocol.grpc.GrpcOptionsUtils;
import org.apache.dubbo.rpc.protocol.grpc.ReferenceCountManagedChannel;

public class GrpcProtocol
extends AbstractProxyProtocol {
    public static final int DEFAULT_PORT = 50051;
    private final ConcurrentMap<String, ReferenceCountManagedChannel> channelMap = new ConcurrentHashMap<String, ReferenceCountManagedChannel>();
    private final Object lock = new Object();

    @Override
    protected <T> Runnable doExport(T proxiedImpl, Class<T> type, URL url) throws RpcException {
        String key = url.getAddress();
        ProtocolServer protocolServer = this.serverMap.computeIfAbsent(key, k -> {
            DubboHandlerRegistry registry = new DubboHandlerRegistry();
            NettyServerBuilder builder = (NettyServerBuilder)NettyServerBuilder.forPort((int)url.getPort()).fallbackHandlerRegistry((HandlerRegistry)registry);
            Server originalServer = GrpcOptionsUtils.buildServerBuilder(url, builder).build();
            GrpcRemotingServer remotingServer = new GrpcRemotingServer(originalServer, registry);
            return new AbstractProxyProtocol.ProxyProtocolServer(remotingServer);
        });
        GrpcRemotingServer grpcServer = (GrpcRemotingServer)protocolServer.getRemotingServer();
        ServiceRepository serviceRepository = ApplicationModel.getServiceRepository();
        ProviderModel providerModel = serviceRepository.lookupExportedService(url.getServiceKey());
        if (providerModel == null) {
            throw new IllegalStateException("Service " + url.getServiceKey() + "should have already been stored in service repository, but failed to find it.");
        }
        Object originalImpl = providerModel.getServiceInstance();
        Class<?> implClass = originalImpl.getClass();
        try {
            Method method = implClass.getMethod("setProxiedImpl", type);
            method.invoke(originalImpl, proxiedImpl);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to set dubbo proxied service impl to stub, please make sure your stub was generated by the dubbo-protoc-compiler.", e);
        }
        grpcServer.getRegistry().addService((BindableService)originalImpl, url.getServiceKey());
        if (!grpcServer.isStarted()) {
            grpcServer.start();
        }
        return () -> grpcServer.getRegistry().removeService(url.getServiceKey());
    }

    @Override
    protected <T> Invoker<T> protocolBindingRefer(Class<T> type, URL url) throws RpcException {
        Method dubboStubMethod;
        Class<?> enclosingClass = type.getEnclosingClass();
        if (enclosingClass == null) {
            throw new IllegalArgumentException(type.getName() + " must be declared inside protobuf generated classes, should be something like ServiceNameGrpc.IServiceName.");
        }
        try {
            dubboStubMethod = enclosingClass.getDeclaredMethod("getDubboStub", Channel.class, CallOptions.class, URL.class, ReferenceConfigBase.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Does not find getDubboStub in " + enclosingClass.getName() + ", please use the customized protoc-gen-dubbo-java to update the generated classes.");
        }
        ReferenceCountManagedChannel channel = this.getSharedChannel(url);
        try {
            Object stub = dubboStubMethod.invoke(null, new Object[]{channel, GrpcOptionsUtils.buildCallOptions(url), url, ApplicationModel.getConsumerModel(url.getServiceKey()).getReferenceConfig()});
            Invoker<Object> target = this.proxyFactory.getInvoker(stub, type, url);
            GrpcInvoker<Object> grpcInvoker = new GrpcInvoker<Object>(type, url, target, channel);
            this.invokers.add(grpcInvoker);
            return grpcInvoker;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Could not create stub through reflection.", e);
        }
    }

    @Override
    protected <T> T doRefer(Class<T> type, URL url) throws RpcException {
        throw new UnsupportedOperationException("not used");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReferenceCountManagedChannel getSharedChannel(URL url) {
        String key = url.getAddress();
        ReferenceCountManagedChannel channel = (ReferenceCountManagedChannel)((Object)this.channelMap.get(key));
        if (channel != null && !channel.isTerminated()) {
            channel.incrementAndGetCount();
            return channel;
        }
        Object object = this.lock;
        synchronized (object) {
            channel = (ReferenceCountManagedChannel)((Object)this.channelMap.get(key));
            if (channel != null && !channel.isTerminated()) {
                channel.incrementAndGetCount();
            } else {
                channel = new ReferenceCountManagedChannel(this.initChannel(url));
                this.channelMap.put(key, channel);
            }
        }
        return channel;
    }

    private ManagedChannel initChannel(URL url) {
        return GrpcOptionsUtils.buildManagedChannel(url);
    }

    @Override
    public int getDefaultPort() {
        return 50051;
    }

    @Override
    public void destroy() {
        this.serverMap.values().forEach(ProtocolServer::close);
        this.channelMap.values().forEach(ReferenceCountManagedChannel::shutdown);
        this.serverMap.clear();
        this.channelMap.clear();
        super.destroy();
    }

    public class GrpcRemotingServer
    extends AbstractProxyProtocol.RemotingServerAdapter {
        private Server originalServer;
        private DubboHandlerRegistry handlerRegistry;
        private volatile boolean started;

        public GrpcRemotingServer(Server server, DubboHandlerRegistry handlerRegistry) {
            this.originalServer = server;
            this.handlerRegistry = handlerRegistry;
        }

        public void start() throws RpcException {
            try {
                this.originalServer.start();
                this.started = true;
            }
            catch (IOException e) {
                throw new RpcException("Starting gRPC server failed. ", (Throwable)e);
            }
        }

        public DubboHandlerRegistry getRegistry() {
            return this.handlerRegistry;
        }

        @Override
        public Object getDelegateServer() {
            return this.originalServer;
        }

        public boolean isStarted() {
            return this.started;
        }

        @Override
        public void close() {
            this.originalServer.shutdown();
        }
    }
}

