/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.redis.jedis;

import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.redis.RedisClient;
import org.apache.dubbo.remoting.redis.support.AbstractRedisClient;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;

public class MonoRedisClient
extends AbstractRedisClient
implements RedisClient {
    private static final Logger logger = LoggerFactory.getLogger(MonoRedisClient.class);
    private static final String START_CURSOR = "0";
    private JedisPool jedisPool;

    public MonoRedisClient(URL url) {
        super(url);
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)this.getConfig(), url.getHost(), url.getPort(), url.getParameter("timeout", 1000), url.getPassword());
    }

    @Override
    public Long hset(String key, String field, String value) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.hset(key, field, value);
        jedis.close();
        return result;
    }

    @Override
    public Long publish(String channel, String message) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.publish(channel, message);
        jedis.close();
        return result;
    }

    @Override
    public boolean isConnected() {
        Jedis jedis = this.jedisPool.getResource();
        boolean connected = jedis.isConnected();
        jedis.close();
        return connected;
    }

    @Override
    public void destroy() {
        this.jedisPool.close();
    }

    @Override
    public Long hdel(String key, String ... fields) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.hdel(key, fields);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> scan(String pattern) {
        Jedis jedis = this.jedisPool.getResource();
        Set<String> result = super.scan(jedis, pattern);
        jedis.close();
        return result;
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        Jedis jedis = this.jedisPool.getResource();
        Map result = jedis.hgetAll(key);
        jedis.close();
        return result;
    }

    @Override
    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        Jedis jedis = this.jedisPool.getResource();
        jedis.psubscribe(jedisPubSub, patterns);
        jedis.close();
    }

    @Override
    public void disconnect() {
        this.jedisPool.close();
    }

    @Override
    public void close() {
        this.jedisPool.close();
    }
}

