/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.redis.jedis;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.redis.RedisClient;
import org.apache.dubbo.remoting.redis.support.AbstractRedisClient;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisSentinelPool;

public class SentinelRedisClient
extends AbstractRedisClient
implements RedisClient {
    private static final Logger logger = LoggerFactory.getLogger(SentinelRedisClient.class);
    private JedisSentinelPool sentinelPool;

    public SentinelRedisClient(URL url) {
        super(url);
        String masterName = url.getParameter("master.name", "Sentinel-master");
        String address = url.getAddress();
        String[] backupAddresses = url.getParameter("backup", new String[0]);
        if (backupAddresses.length == 0) {
            throw new IllegalStateException("Sentinel addresses can not be empty");
        }
        HashSet<String> sentinels = new HashSet<String>(Arrays.asList(backupAddresses));
        sentinels.add(address);
        this.sentinelPool = new JedisSentinelPool(masterName, sentinels, (GenericObjectPoolConfig)this.getConfig(), url.getPassword());
    }

    @Override
    public Long hset(String key, String field, String value) {
        Jedis jedis = this.sentinelPool.getResource();
        Long result = jedis.hset(key, field, value);
        jedis.close();
        return result;
    }

    @Override
    public Long publish(String channel, String message) {
        Jedis jedis = this.sentinelPool.getResource();
        Long result = jedis.publish(channel, message);
        jedis.close();
        return result;
    }

    @Override
    public boolean isConnected() {
        Jedis jedis = this.sentinelPool.getResource();
        boolean result = jedis.isConnected();
        jedis.close();
        return result;
    }

    @Override
    public void destroy() {
        this.sentinelPool.close();
    }

    @Override
    public Long hdel(String key, String ... fields) {
        Jedis jedis = this.sentinelPool.getResource();
        Long result = jedis.hdel(key, fields);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> scan(String pattern) {
        Jedis jedis = this.sentinelPool.getResource();
        Set<String> result = this.scan(jedis, pattern);
        jedis.close();
        return result;
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        Jedis jedis = this.sentinelPool.getResource();
        Map result = jedis.hgetAll(key);
        jedis.close();
        return result;
    }

    @Override
    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        Jedis jedis = this.sentinelPool.getResource();
        jedis.psubscribe(jedisPubSub, patterns);
        jedis.close();
    }

    @Override
    public void disconnect() {
        this.sentinelPool.close();
    }

    @Override
    public void close() {
        this.sentinelPool.close();
    }
}

