/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.serialize.hessian.serializer.java8;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.AbstractSerializer;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class Java8TimeSerializer<T>
extends AbstractSerializer {
    private Class<T> handleType;

    private Java8TimeSerializer(Class<T> handleType) {
        this.handleType = handleType;
    }

    public static <T> Java8TimeSerializer<T> create(Class<T> handleType) {
        return new Java8TimeSerializer<T>(handleType);
    }

    public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
        if (obj == null) {
            out.writeNull();
            return;
        }
        Object handle = null;
        try {
            Constructor<T> constructor = this.handleType.getConstructor(Object.class);
            handle = constructor.newInstance(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("the class :" + this.handleType.getName() + " construct failed:" + e.getMessage(), e);
        }
        out.writeObject(handle);
    }
}

