/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ProviderMethodModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceMetadata;

public class ProviderModel {
    private String serviceKey;
    private final Object serviceInstance;
    private final ServiceDescriptor serviceModel;
    private final ServiceConfigBase<?> serviceConfig;
    private final List<RegisterStatedURL> urls;
    private ServiceMetadata serviceMetadata;
    private final Map<String, List<ProviderMethodModel>> methods = new HashMap<String, List<ProviderMethodModel>>();

    public ProviderModel(String serviceKey, Object serviceInstance, ServiceDescriptor serviceModel, ServiceConfigBase<?> serviceConfig) {
        if (null == serviceInstance) {
            throw new IllegalArgumentException("Service[" + serviceKey + "]Target is NULL.");
        }
        this.serviceKey = serviceKey;
        this.serviceInstance = serviceInstance;
        this.serviceModel = serviceModel;
        this.serviceConfig = serviceConfig;
        this.urls = new ArrayList<RegisterStatedURL>(1);
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public Class<?> getServiceInterfaceClass() {
        return this.serviceModel.getServiceInterfaceClass();
    }

    public Object getServiceInstance() {
        return this.serviceInstance;
    }

    public Set<MethodDescriptor> getAllMethods() {
        return this.serviceModel.getAllMethods();
    }

    public ServiceDescriptor getServiceModel() {
        return this.serviceModel;
    }

    public ServiceConfigBase getServiceConfig() {
        return this.serviceConfig;
    }

    public List<RegisterStatedURL> getStatedUrl() {
        return this.urls;
    }

    public void addStatedUrl(RegisterStatedURL url) {
        this.urls.add(url);
    }

    public ProviderModel(String serviceKey, Object serviceInstance, ServiceDescriptor serviceModel, ServiceConfigBase<?> serviceConfig, ServiceMetadata serviceMetadata) {
        this(serviceKey, serviceInstance, serviceModel, serviceConfig);
        this.serviceMetadata = serviceMetadata;
        this.initMethod(serviceModel.getServiceInterfaceClass());
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
        if (this.serviceMetadata != null) {
            this.serviceMetadata.setServiceKey(serviceKey);
            this.serviceMetadata.setGroup(BaseServiceMetadata.groupFromServiceKey(serviceKey));
        }
    }

    public String getServiceName() {
        return this.serviceMetadata.getServiceKey();
    }

    public List<ProviderMethodModel> getAllMethodModels() {
        ArrayList<ProviderMethodModel> result = new ArrayList<ProviderMethodModel>();
        for (List<ProviderMethodModel> models : this.methods.values()) {
            result.addAll(models);
        }
        return result;
    }

    public ProviderMethodModel getMethodModel(String methodName, String[] argTypes) {
        List<ProviderMethodModel> methodModels = this.methods.get(methodName);
        if (methodModels != null) {
            for (ProviderMethodModel methodModel : methodModels) {
                if (!Arrays.equals(argTypes, methodModel.getMethodArgTypes())) continue;
                return methodModel;
            }
        }
        return null;
    }

    public List<ProviderMethodModel> getMethodModelList(String methodName) {
        List<ProviderMethodModel> resultList = this.methods.get(methodName);
        return resultList == null ? Collections.emptyList() : resultList;
    }

    private void initMethod(Class<?> serviceInterfaceClass) {
        Method[] methodsToExport;
        for (Method method : methodsToExport = serviceInterfaceClass.getMethods()) {
            ReflectUtils.makeAccessible(method);
            List<ProviderMethodModel> methodModels = this.methods.get(method.getName());
            if (methodModels == null) {
                methodModels = new ArrayList<ProviderMethodModel>();
                this.methods.put(method.getName(), methodModels);
            }
            methodModels.add(new ProviderMethodModel(method));
        }
    }

    public ServiceMetadata getServiceMetadata() {
        return this.serviceMetadata;
    }

    public static class RegisterStatedURL {
        private volatile URL registryUrl;
        private volatile URL providerUrl;
        private volatile boolean registered;

        public RegisterStatedURL(URL providerUrl, URL registryUrl, boolean registered) {
            this.providerUrl = providerUrl;
            this.registered = registered;
            this.registryUrl = registryUrl;
        }

        public URL getProviderUrl() {
            return this.providerUrl;
        }

        public void setProviderUrl(URL providerUrl) {
            this.providerUrl = providerUrl;
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public void setRegistered(boolean registered) {
            this.registered = registered;
        }

        public URL getRegistryUrl() {
            return this.registryUrl;
        }

        public void setRegistryUrl(URL registryUrl) {
            this.registryUrl = registryUrl;
        }
    }
}

