/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import com.alibaba.dubbo.rpc.service.GenericException;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.dubbo.common.beanutil.JavaBeanAccessor;
import org.apache.dubbo.common.beanutil.JavaBeanDescriptor;
import org.apache.dubbo.common.beanutil.JavaBeanSerializeUtil;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.io.UnsafeByteArrayInputStream;
import org.apache.dubbo.common.io.UnsafeByteArrayOutputStream;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.utils.PojoUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;

@Activate(group={"provider"}, order=-20000)
public class GenericFilter
implements Filter,
Filter.Listener {
    private static final Logger logger = LoggerFactory.getLogger(GenericFilter.class);

    @Override
    public Result invoke(Invoker<?> invoker, Invocation inv) throws RpcException {
        if ((inv.getMethodName().equals("$invoke") || inv.getMethodName().equals("$invokeAsync")) && inv.getArguments() != null && inv.getArguments().length == 3 && !GenericService.class.isAssignableFrom(invoker.getInterface())) {
            String name = ((String)inv.getArguments()[0]).trim();
            String[] types = (String[])inv.getArguments()[1];
            Object[] args = (Object[])inv.getArguments()[2];
            try {
                Method method;
                block48: {
                    method = ReflectUtils.findMethodByMethodSignature(invoker.getInterface(), name, types);
                    Class<?>[] params = method.getParameterTypes();
                    if (args == null) {
                        args = new Object[params.length];
                    }
                    if (types == null) {
                        types = new String[params.length];
                    }
                    if (args.length != types.length) {
                        throw new RpcException("GenericFilter#invoke args.length != types.length, please check your params");
                    }
                    String generic = inv.getAttachment("generic");
                    if (StringUtils.isBlank(generic)) {
                        generic = RpcContext.getContext().getAttachment("generic");
                    }
                    if (StringUtils.isEmpty(generic) || ProtocolUtils.isDefaultGenericSerialization(generic) || ProtocolUtils.isGenericReturnRawResult(generic)) {
                        args = PojoUtils.realize(args, params, method.getGenericParameterTypes());
                    } else if (ProtocolUtils.isJavaGenericSerialization(generic)) {
                        Configuration configuration = ApplicationModel.getEnvironment().getConfiguration();
                        if (!configuration.getBoolean("dubbo.security.serialize.generic.native-java-enable", false)) {
                            String notice = "Trigger the safety barrier! Native Java Serializer is not allowed by default.This means currently maybe being attacking by others. If you are sure this is a mistake, please set `dubbo.security.serialize.generic.native-java-enable` enable in configuration! Before doing so, please make sure you have configure JEP290 to prevent serialization attack.";
                            logger.error(notice);
                            throw new RpcException(new IllegalStateException(notice));
                        }
                        for (int i = 0; i < args.length; ++i) {
                            if (byte[].class == args[i].getClass()) {
                                try (UnsafeByteArrayInputStream is = new UnsafeByteArrayInputStream((byte[])args[i]);){
                                    args[i] = ExtensionLoader.getExtensionLoader(Serialization.class).getExtension("nativejava").deserialize(null, is).readObject();
                                    continue;
                                }
                                catch (Exception e) {
                                    throw new RpcException("Deserialize argument [" + (i + 1) + "] failed.", (Throwable)e);
                                }
                            }
                            throw new RpcException("Generic serialization [nativejava] only support message type " + byte[].class + " and your message type is " + args[i].getClass());
                        }
                    } else if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                        for (int i = 0; i < args.length; ++i) {
                            if (!(args[i] instanceof JavaBeanDescriptor)) {
                                throw new RpcException("Generic serialization [bean] only support message type " + JavaBeanDescriptor.class.getName() + " and your message type is " + args[i].getClass().getName());
                            }
                            args[i] = JavaBeanSerializeUtil.deserialize((JavaBeanDescriptor)args[i]);
                        }
                    } else if (ProtocolUtils.isProtobufGenericSerialization(generic)) {
                        if (args.length == 1 && args[0] instanceof String) {
                            try (UnsafeByteArrayInputStream is = new UnsafeByteArrayInputStream(((String)args[0]).getBytes());){
                                args[0] = ExtensionLoader.getExtensionLoader(Serialization.class).getExtension("protobuf-json").deserialize(null, is).readObject(method.getParameterTypes()[0]);
                                break block48;
                            }
                            catch (Exception e) {
                                throw new RpcException("Deserialize argument failed.", (Throwable)e);
                            }
                        }
                        throw new RpcException("Generic serialization [protobuf-json] only support one " + String.class.getName() + " argument and your message size is " + args.length + " and type is" + args[0].getClass().getName());
                    }
                }
                RpcInvocation rpcInvocation = new RpcInvocation(method, invoker.getInterface().getName(), invoker.getUrl().getProtocolServiceKey(), args, inv.getObjectAttachments(), inv.getAttributes());
                rpcInvocation.setInvoker(inv.getInvoker());
                rpcInvocation.setTargetServiceUniqueName(inv.getTargetServiceUniqueName());
                return invoker.invoke(rpcInvocation);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new RpcException(e.getMessage(), (Throwable)e);
            }
        }
        return invoker.invoke(inv);
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation inv) {
        if ((inv.getMethodName().equals("$invoke") || inv.getMethodName().equals("$invokeAsync")) && inv.getArguments() != null && inv.getArguments().length == 3 && !GenericService.class.isAssignableFrom(invoker.getInterface())) {
            UnsafeByteArrayOutputStream os;
            String generic = inv.getAttachment("generic");
            if (StringUtils.isBlank(generic)) {
                generic = RpcContext.getContext().getAttachment("generic");
            }
            if (appResponse.hasException()) {
                Throwable appException = appResponse.getException();
                if (appException instanceof org.apache.dubbo.rpc.service.GenericException) {
                    org.apache.dubbo.rpc.service.GenericException tmp = (org.apache.dubbo.rpc.service.GenericException)appException;
                    appException = new GenericException(tmp.getExceptionClass(), tmp.getExceptionMessage());
                }
                if (!(appException instanceof GenericException)) {
                    appException = new GenericException(appException);
                }
                appResponse.setException(appException);
            }
            if (ProtocolUtils.isJavaGenericSerialization(generic)) {
                try {
                    os = new UnsafeByteArrayOutputStream(512);
                    ExtensionLoader.getExtensionLoader(Serialization.class).getExtension("nativejava").serialize(null, os).writeObject(appResponse.getValue());
                    appResponse.setValue(os.toByteArray());
                }
                catch (IOException e) {
                    throw new RpcException("Generic serialization [nativejava] serialize result failed.", (Throwable)e);
                }
            } else if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                appResponse.setValue(JavaBeanSerializeUtil.serialize(appResponse.getValue(), JavaBeanAccessor.METHOD));
            } else if (ProtocolUtils.isProtobufGenericSerialization(generic)) {
                try {
                    os = new UnsafeByteArrayOutputStream(512);
                    ExtensionLoader.getExtensionLoader(Serialization.class).getExtension("protobuf-json").serialize(null, os).writeObject(appResponse.getValue());
                    appResponse.setValue(os.toString());
                }
                catch (IOException e) {
                    throw new RpcException("Generic serialization [protobuf-json] serialize result failed.", (Throwable)e);
                }
            } else {
                if (ProtocolUtils.isGenericReturnRawResult(generic)) {
                    return;
                }
                appResponse.setValue(PojoUtils.generalize(appResponse.getValue()));
            }
        }
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
    }
}

