/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.support.AccessLogData;

@Activate(group={"provider"}, value={"accesslog"})
public class AccessLogFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(AccessLogFilter.class);
    private static final String LOG_KEY = "dubbo.accesslog";
    private static final int LOG_MAX_BUFFER = 5000;
    private static final long LOG_OUTPUT_INTERVAL = 5000L;
    private static final String FILE_DATE_FORMAT = "yyyyMMdd";
    private static final DateFormat FILE_NAME_FORMATTER = new SimpleDateFormat("yyyyMMdd");
    private static final Map<String, Set<AccessLogData>> LOG_ENTRIES = new ConcurrentHashMap<String, Set<AccessLogData>>();
    private static final ScheduledExecutorService LOG_SCHEDULED = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-Access-Log", true));

    public AccessLogFilter() {
        LOG_SCHEDULED.scheduleWithFixedDelay(this::writeLogToFile, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation inv) throws RpcException {
        try {
            String accessLogKey = invoker.getUrl().getParameter("accesslog");
            if (ConfigUtils.isNotEmpty(accessLogKey)) {
                AccessLogData logData = AccessLogData.newLogData();
                logData.buildAccessLogData(invoker, inv);
                this.log(accessLogKey, logData);
            }
        }
        catch (Throwable t) {
            logger.warn("Exception in AccessLogFilter of service(" + invoker + " -> " + inv + ")", t);
        }
        return invoker.invoke(inv);
    }

    private void log(String accessLog, AccessLogData accessLogData) {
        Set logSet = LOG_ENTRIES.computeIfAbsent(accessLog, k -> new ConcurrentHashSet());
        if (logSet.size() < 5000) {
            logSet.add(accessLogData);
        } else {
            logger.warn("AccessLog buffer is full. Do a force writing to file to clear buffer.");
            this.writeLogSetToFile(accessLog, logSet);
            logSet.add(accessLogData);
        }
    }

    private void writeLogSetToFile(String accessLog, Set<AccessLogData> logSet) {
        try {
            if (ConfigUtils.isDefault(accessLog)) {
                this.processWithServiceLogger(logSet);
            } else {
                File file = new File(accessLog);
                this.createIfLogDirAbsent(file);
                if (logger.isDebugEnabled()) {
                    logger.debug("Append log to " + accessLog);
                }
                this.renameFile(file);
                this.processWithAccessKeyLogger(logSet, file);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    private void writeLogToFile() {
        if (!LOG_ENTRIES.isEmpty()) {
            for (Map.Entry<String, Set<AccessLogData>> entry : LOG_ENTRIES.entrySet()) {
                String accessLog = entry.getKey();
                Set<AccessLogData> logSet = entry.getValue();
                this.writeLogSetToFile(accessLog, logSet);
            }
        }
    }

    private void processWithAccessKeyLogger(Set<AccessLogData> logSet, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file, true);){
            Iterator<AccessLogData> iterator = logSet.iterator();
            while (iterator.hasNext()) {
                writer.write(iterator.next().getLogMessage());
                writer.write(System.getProperty("line.separator"));
                iterator.remove();
            }
            writer.flush();
        }
    }

    private void processWithServiceLogger(Set<AccessLogData> logSet) {
        Iterator<AccessLogData> iterator = logSet.iterator();
        while (iterator.hasNext()) {
            AccessLogData logData = iterator.next();
            LoggerFactory.getLogger("dubbo.accesslog." + logData.getServiceName()).info(logData.getLogMessage());
            iterator.remove();
        }
    }

    private void createIfLogDirAbsent(File file) {
        File dir = file.getParentFile();
        if (null != dir && !dir.exists()) {
            dir.mkdirs();
        }
    }

    private void renameFile(File file) {
        String last;
        String now;
        if (file.exists() && !(now = FILE_NAME_FORMATTER.format(new Date())).equals(last = FILE_NAME_FORMATTER.format(new Date(file.lastModified())))) {
            File archive = new File(file.getAbsolutePath() + "." + last);
            file.renameTo(archive);
        }
    }
}

