/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.zookeeper.curator;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryNTimes;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.zookeeper.ChildListener;
import org.apache.dubbo.remoting.zookeeper.DataListener;
import org.apache.dubbo.remoting.zookeeper.EventType;
import org.apache.dubbo.remoting.zookeeper.support.AbstractZookeeperClient;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class CuratorZookeeperClient
extends AbstractZookeeperClient<CuratorWatcherImpl, CuratorWatcherImpl> {
    protected static final Logger logger = LoggerFactory.getLogger(CuratorZookeeperClient.class);
    private static final String ZK_SESSION_EXPIRE_KEY = "zk.session.expire";
    static final Charset CHARSET = StandardCharsets.UTF_8;
    private final CuratorFramework client;
    private Map<String, TreeCache> treeCacheMap = new ConcurrentHashMap<String, TreeCache>();

    public CuratorZookeeperClient(URL url) {
        super(url);
        try {
            int timeout = url.getParameter("timeout", this.DEFAULT_CONNECTION_TIMEOUT_MS);
            int sessionExpireMs = url.getParameter(ZK_SESSION_EXPIRE_KEY, this.DEFAULT_SESSION_TIMEOUT_MS);
            CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(url.getBackupAddress()).retryPolicy((RetryPolicy)new RetryNTimes(1, 1000)).connectionTimeoutMs(timeout).sessionTimeoutMs(sessionExpireMs);
            String authority = url.getAuthority();
            if (authority != null && authority.length() > 0) {
                builder = builder.authorization("digest", authority.getBytes());
            }
            this.client = builder.build();
            this.client.getConnectionStateListenable().addListener((Object)new CuratorConnectionStateListener(url));
            this.client.start();
            boolean connected = this.client.blockUntilConnected(timeout, TimeUnit.MILLISECONDS);
            if (!connected) {
                throw new IllegalStateException("zookeeper not connected");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void createPersistent(String path) {
        try {
            this.client.create().forPath(path);
        }
        catch (KeeperException.NodeExistsException e) {
            logger.warn("ZNode " + path + " already exists.", e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void createEphemeral(String path) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).forPath(path);
        }
        catch (KeeperException.NodeExistsException e) {
            logger.warn("ZNode " + path + " already exists, since we will only try to recreate a node on a session expiration, this duplication might be caused by a delete delay from the zk server, which means the old expired session may still holds this ZNode and the server just hasn't got time to do the deletion. In this case, we can just try to delete and create again.", e);
            this.deletePath(path);
            this.createEphemeral(path);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void createPersistent(String path, String data) {
        byte[] dataBytes = data.getBytes(CHARSET);
        try {
            this.client.create().forPath(path, dataBytes);
        }
        catch (KeeperException.NodeExistsException e) {
            try {
                this.client.setData().forPath(path, dataBytes);
            }
            catch (Exception e1) {
                throw new IllegalStateException(e.getMessage(), e1);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void createEphemeral(String path, String data) {
        byte[] dataBytes = data.getBytes(CHARSET);
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).forPath(path, dataBytes);
        }
        catch (KeeperException.NodeExistsException e) {
            logger.warn("ZNode " + path + " already exists, since we will only try to recreate a node on a session expiration, this duplication might be caused by a delete delay from the zk server, which means the old expired session may still holds this ZNode and the server just hasn't got time to do the deletion. In this case, we can just try to delete and create again.", e);
            this.deletePath(path);
            this.createEphemeral(path, data);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void deletePath(String path) {
        try {
            this.client.delete().deletingChildrenIfNeeded().forPath(path);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public List<String> getChildren(String path) {
        try {
            return (List)this.client.getChildren().forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public boolean checkExists(String path) {
        try {
            if (this.client.checkExists().forPath(path) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.client.getZookeeperClient().isConnected();
    }

    @Override
    public String doGetContent(String path) {
        try {
            byte[] dataBytes = (byte[])this.client.getData().forPath(path);
            return dataBytes == null || dataBytes.length == 0 ? null : new String(dataBytes, CHARSET);
        }
        catch (KeeperException.NoNodeException dataBytes) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public void doClose() {
        this.client.close();
    }

    @Override
    public CuratorWatcherImpl createTargetChildListener(String path, ChildListener listener) {
        return new CuratorWatcherImpl(this.client, listener, path);
    }

    @Override
    public List<String> addTargetChildListener(String path, CuratorWatcherImpl listener) {
        try {
            return (List)((BackgroundPathable)this.client.getChildren().usingWatcher((CuratorWatcher)listener)).forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected CuratorWatcherImpl createTargetDataListener(String path, DataListener listener) {
        return new CuratorWatcherImpl(this.client, listener);
    }

    @Override
    protected void addTargetDataListener(String path, CuratorWatcherImpl treeCacheListener) {
        this.addTargetDataListener(path, treeCacheListener, (Executor)null);
    }

    @Override
    protected void addTargetDataListener(String path, CuratorWatcherImpl treeCacheListener, Executor executor) {
        try {
            TreeCache treeCache = TreeCache.newBuilder((CuratorFramework)this.client, (String)path).setCacheData(false).build();
            this.treeCacheMap.putIfAbsent(path, treeCache);
            if (executor == null) {
                treeCache.getListenable().addListener((Object)treeCacheListener);
            } else {
                treeCache.getListenable().addListener((Object)treeCacheListener, executor);
            }
            treeCache.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Add treeCache listener for path:" + path, e);
        }
    }

    @Override
    protected void removeTargetDataListener(String path, CuratorWatcherImpl treeCacheListener) {
        TreeCache treeCache = this.treeCacheMap.get(path);
        if (treeCache != null) {
            treeCache.getListenable().removeListener((Object)treeCacheListener);
        }
        treeCacheListener.dataListener = null;
    }

    @Override
    public void removeTargetChildListener(String path, CuratorWatcherImpl listener) {
        listener.unwatch();
    }

    CuratorFramework getClient() {
        return this.client;
    }

    private class CuratorConnectionStateListener
    implements ConnectionStateListener {
        private final long UNKNOWN_SESSION_ID = -1L;
        private long lastSessionId;
        private int timeout;
        private int sessionExpireMs;

        public CuratorConnectionStateListener(URL url) {
            this.timeout = url.getParameter("timeout", CuratorZookeeperClient.this.DEFAULT_CONNECTION_TIMEOUT_MS);
            this.sessionExpireMs = url.getParameter(CuratorZookeeperClient.ZK_SESSION_EXPIRE_KEY, CuratorZookeeperClient.this.DEFAULT_SESSION_TIMEOUT_MS);
        }

        public void stateChanged(CuratorFramework client, ConnectionState state) {
            long sessionId = -1L;
            try {
                sessionId = client.getZookeeperClient().getZooKeeper().getSessionId();
            }
            catch (Exception e) {
                logger.warn("Curator client state changed, but failed to get the related zk session instance.");
            }
            if (state == ConnectionState.LOST) {
                logger.warn("Curator zookeeper session " + Long.toHexString(this.lastSessionId) + " expired.");
                CuratorZookeeperClient.this.stateChanged(0);
            } else if (state == ConnectionState.SUSPENDED) {
                logger.warn("Curator zookeeper connection of session " + Long.toHexString(sessionId) + " timed out. connection timeout value is " + this.timeout + ", session expire timeout value is " + this.sessionExpireMs);
                CuratorZookeeperClient.this.stateChanged(3);
            } else if (state == ConnectionState.CONNECTED) {
                this.lastSessionId = sessionId;
                logger.info("Curator zookeeper client instance initiated successfully, session id is " + Long.toHexString(sessionId));
                CuratorZookeeperClient.this.stateChanged(1);
            } else if (state == ConnectionState.RECONNECTED) {
                if (this.lastSessionId == sessionId && sessionId != -1L) {
                    logger.warn("Curator zookeeper connection recovered from connection lose, reuse the old session " + Long.toHexString(sessionId));
                    CuratorZookeeperClient.this.stateChanged(2);
                } else {
                    logger.warn("New session created after old session lost, old session " + Long.toHexString(this.lastSessionId) + ", new session " + Long.toHexString(sessionId));
                    this.lastSessionId = sessionId;
                    CuratorZookeeperClient.this.stateChanged(4);
                }
            }
        }
    }

    static class CuratorWatcherImpl
    implements CuratorWatcher,
    TreeCacheListener {
        private CuratorFramework client;
        private volatile ChildListener childListener;
        private volatile DataListener dataListener;
        private String path;

        public CuratorWatcherImpl(CuratorFramework client, ChildListener listener, String path) {
            this.client = client;
            this.childListener = listener;
            this.path = path;
        }

        public CuratorWatcherImpl(CuratorFramework client, DataListener dataListener) {
            this.dataListener = dataListener;
        }

        protected CuratorWatcherImpl() {
        }

        public void unwatch() {
            this.childListener = null;
        }

        public void process(WatchedEvent event) throws Exception {
            if (event.getType() == Watcher.Event.EventType.None) {
                return;
            }
            if (this.childListener != null) {
                this.childListener.childChanged(this.path, (List)((BackgroundPathable)this.client.getChildren().usingWatcher((CuratorWatcher)this)).forPath(this.path));
            }
        }

        public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
            if (this.dataListener != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("listen the zookeeper changed. The changed data:" + event.getData());
                }
                TreeCacheEvent.Type type = event.getType();
                EventType eventType = null;
                String content = null;
                String path = null;
                switch (type) {
                    case NODE_ADDED: {
                        eventType = EventType.NodeCreated;
                        path = event.getData().getPath();
                        content = event.getData().getData() == null ? "" : new String(event.getData().getData(), CHARSET);
                        break;
                    }
                    case NODE_UPDATED: {
                        eventType = EventType.NodeDataChanged;
                        path = event.getData().getPath();
                        content = event.getData().getData() == null ? "" : new String(event.getData().getData(), CHARSET);
                        break;
                    }
                    case NODE_REMOVED: {
                        path = event.getData().getPath();
                        eventType = EventType.NodeDeleted;
                        break;
                    }
                    case INITIALIZED: {
                        eventType = EventType.INITIALIZED;
                        break;
                    }
                    case CONNECTION_LOST: {
                        eventType = EventType.CONNECTION_LOST;
                        break;
                    }
                    case CONNECTION_RECONNECTED: {
                        eventType = EventType.CONNECTION_RECONNECTED;
                        break;
                    }
                    case CONNECTION_SUSPENDED: {
                        eventType = EventType.CONNECTION_SUSPENDED;
                    }
                }
                this.dataListener.dataChanged(path, content, eventType);
            }
        }
    }
}

