/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.etcd;

import com.google.gson.Gson;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.event.EventDispatcher;
import org.apache.dubbo.event.EventListener;
import org.apache.dubbo.registry.client.AbstractServiceDiscovery;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.remoting.etcd.ChildListener;
import org.apache.dubbo.remoting.etcd.EtcdClient;
import org.apache.dubbo.remoting.etcd.EtcdTransporter;
import org.apache.dubbo.remoting.etcd.option.OptionUtil;
import org.apache.dubbo.rpc.RpcException;

public class EtcdServiceDiscovery
extends AbstractServiceDiscovery
implements EventListener<ServiceInstancesChangedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(EtcdServiceDiscovery.class);
    private final String root = "/services";
    private final Set<String> services = new ConcurrentHashSet<String>();
    private final Map<String, ChildListener> childListenerMap = new ConcurrentHashMap<String, ChildListener>();
    EtcdClient etcdClient;
    EventDispatcher dispatcher;

    @Override
    public void onEvent(ServiceInstancesChangedEvent event) {
        this.registerServiceWatcher(event.getServiceName());
    }

    @Override
    public void initialize(URL registryURL) throws Exception {
        EtcdTransporter etcdTransporter = ExtensionLoader.getExtensionLoader(EtcdTransporter.class).getAdaptiveExtension();
        if (registryURL.isAnyHost()) {
            throw new IllegalStateException("Service discovery address is invalid, actual: '" + registryURL.getHost() + "'");
        }
        this.etcdClient = etcdTransporter.connect(registryURL);
        this.etcdClient.addStateListener(state -> {
            if (state == 1) {
                try {
                    this.recover();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            }
        });
        this.dispatcher = EventDispatcher.getDefaultExtension();
        this.dispatcher.addEventListener(this);
    }

    @Override
    public void destroy() {
        if (this.etcdClient != null && this.etcdClient.isConnected()) {
            this.etcdClient.close();
        }
    }

    @Override
    public void doRegister(ServiceInstance serviceInstance) {
        try {
            String path = this.toPath(serviceInstance);
            this.etcdClient.putEphemeral(path, new Gson().toJson((Object)serviceInstance));
            this.services.add(serviceInstance.getServiceName());
        }
        catch (Throwable e) {
            throw new RpcException("Failed to register " + serviceInstance + " to etcd " + this.etcdClient.getUrl() + ", cause: " + (OptionUtil.isProtocolError(e) ? "etcd3 registry may not be supported yet or etcd3 registry is not available." : e.getMessage()), e);
        }
    }

    String toPath(ServiceInstance serviceInstance) {
        return "/services" + File.separator + serviceInstance.getServiceName() + File.separator + serviceInstance.getHost() + ":" + serviceInstance.getPort();
    }

    String toParentPath(String serviceName) {
        return "/services" + File.separator + serviceName;
    }

    @Override
    public void doUpdate(ServiceInstance serviceInstance) {
        try {
            String path = this.toPath(serviceInstance);
            this.etcdClient.putEphemeral(path, new Gson().toJson((Object)serviceInstance));
            this.services.add(serviceInstance.getServiceName());
        }
        catch (Throwable e) {
            throw new RpcException("Failed to register " + serviceInstance + " to etcd " + this.etcdClient.getUrl() + ", cause: " + (OptionUtil.isProtocolError(e) ? "etcd3 registry may not be supported yet or etcd3 registry is not available." : e.getMessage()), e);
        }
    }

    @Override
    public void unregister(ServiceInstance serviceInstance) throws RuntimeException {
        try {
            String path = this.toPath(serviceInstance);
            this.etcdClient.delete(path);
            this.services.remove(serviceInstance.getServiceName());
            this.serviceInstance = null;
        }
        catch (Throwable e) {
            throw new RpcException("Failed to unregister " + serviceInstance + " to etcd " + this.etcdClient.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    @Override
    public Set<String> getServices() {
        return Collections.unmodifiableSet(this.services);
    }

    @Override
    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        listener.getServiceNames().forEach(serviceName -> this.registerServiceWatcher((String)serviceName));
    }

    @Override
    public List<ServiceInstance> getInstances(String serviceName) {
        List<String> children = this.etcdClient.getChildren(this.toParentPath(serviceName));
        if (CollectionUtils.isEmpty(children)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ServiceInstance> list = new ArrayList<ServiceInstance>(children.size());
        for (String child : children) {
            ServiceInstance serviceInstance = (ServiceInstance)new Gson().fromJson(this.etcdClient.getKVValue(child), DefaultServiceInstance.class);
            list.add(serviceInstance);
        }
        return list;
    }

    protected void registerServiceWatcher(String serviceName) {
        String path = "/services" + File.separator + serviceName;
        ChildListener childListener = Optional.ofNullable(this.childListenerMap.get(serviceName)).orElseGet(() -> {
            ChildListener watchListener = (parentPath, currentChildren) -> this.dispatchServiceInstancesChangedEvent(serviceName);
            ChildListener prev = this.childListenerMap.putIfAbsent(serviceName, watchListener);
            return prev != null ? prev : watchListener;
        });
        this.etcdClient.create(path);
        this.etcdClient.addChildListener(path, childListener);
    }

    private void recover() throws Exception {
        if (this.serviceInstance != null) {
            if (logger.isInfoEnabled()) {
                logger.info("Recover application register: " + this.serviceInstance);
            }
            this.register(this.serviceInstance);
        }
    }
}

