/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.MetadataServiceURLBuilder;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.client.metadata.store.RemoteMetadataServiceImpl;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;

public class MetadataUtils {
    private static final Object REMOTE_LOCK = new Object();
    public static ConcurrentMap<String, MetadataService> metadataServiceProxies = new ConcurrentHashMap<String, MetadataService>();
    private static final ProxyFactory proxyFactory = ExtensionLoader.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
    private static final Protocol protocol = ExtensionLoader.getExtensionLoader(Protocol.class).getAdaptiveExtension();
    public static RemoteMetadataServiceImpl remoteMetadataService;
    public static WritableMetadataService localMetadataService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteMetadataServiceImpl getRemoteMetadataService() {
        if (remoteMetadataService == null) {
            Object object = REMOTE_LOCK;
            synchronized (object) {
                if (remoteMetadataService == null) {
                    remoteMetadataService = new RemoteMetadataServiceImpl(WritableMetadataService.getDefaultExtension());
                }
            }
        }
        return remoteMetadataService;
    }

    public static void publishServiceDefinition(URL url) {
        WritableMetadataService.getDefaultExtension().publishServiceDefinition(url);
        MetadataUtils.getRemoteMetadataService().publishServiceDefinition(url);
    }

    public static MetadataService getMetadataServiceProxy(ServiceInstance instance, ServiceDiscovery serviceDiscovery) {
        String key = instance.getServiceName() + "##" + ServiceInstanceMetadataUtils.getExportedServicesRevision(instance);
        return metadataServiceProxies.computeIfAbsent(key, k -> {
            MetadataServiceURLBuilder builder = null;
            ExtensionLoader<MetadataServiceURLBuilder> loader = ExtensionLoader.getExtensionLoader(MetadataServiceURLBuilder.class);
            Map<String, String> metadata = instance.getMetadata();
            String dubboURLsJSON = metadata.get("dubbo.metadata-service.urls");
            builder = StringUtils.isNotEmpty(dubboURLsJSON) ? loader.getExtension("spring-cloud") : loader.getExtension("standard");
            List<URL> urls = builder.build(instance);
            if (CollectionUtils.isEmpty(urls)) {
                throw new IllegalStateException("You have enabled introspection service discovery mode for instance " + instance + ", but no metadata service can build from it.");
            }
            Invoker<MetadataService> invoker = protocol.refer(MetadataService.class, urls.get(0));
            return proxyFactory.getProxy(invoker);
        });
    }
}

