/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.report.identifier.BaseMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.report.support.AbstractMetadataReport;
import org.apache.dubbo.metadata.store.nacos.NacosConfigServiceWrapper;
import org.apache.dubbo.rpc.RpcException;

public class NacosMetadataReport
extends AbstractMetadataReport {
    private NacosConfigServiceWrapper configService;
    private String group;

    public NacosMetadataReport(URL url) {
        super(url);
        this.configService = this.buildConfigService(url);
        this.group = url.getParameter("group", "dubbo");
    }

    public NacosConfigServiceWrapper buildConfigService(URL url) {
        Properties nacosProperties = this.buildNacosProperties(url);
        try {
            this.configService = new NacosConfigServiceWrapper(NacosFactory.createConfigService((Properties)nacosProperties));
        }
        catch (NacosException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(e.getErrMsg(), e);
            }
            throw new IllegalStateException(e);
        }
        return this.configService;
    }

    private Properties buildNacosProperties(URL url) {
        Properties properties = new Properties();
        this.setServerAddr(url, properties);
        NacosMetadataReport.setProperties(url, properties);
        return properties;
    }

    private void setServerAddr(URL url, Properties properties) {
        StringBuilder serverAddrBuilder = new StringBuilder(url.getHost()).append(":").append(url.getPort());
        String backup = url.getParameter("backup");
        if (backup != null) {
            serverAddrBuilder.append(",").append(backup);
        }
        String serverAddr = serverAddrBuilder.toString();
        properties.put("serverAddr", serverAddr);
    }

    private static void setProperties(URL url, Properties properties) {
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "com.alibaba.nacos.naming.log.filename");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "isUseCloudNamespaceParsing");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "isUseEndpointParsingRule");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "endpoint");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "endpointPort");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "namespace");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "accessKey");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "secretKey");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "ramRoleName");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "contextPath");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "clusterName");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "encode");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "configLongPollTimeout");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "configRetryTime");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "maxRetry");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "enableRemoteSyncConfig");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "namingLoadCacheAtStart", "true");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "namingClientBeatThreadCount");
        NacosMetadataReport.putPropertyIfAbsent(url, properties, "namingPollingThreadCount");
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty(propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        }
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName, String defaultValue) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty(propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        } else {
            properties.setProperty(propertyName, defaultValue);
        }
    }

    @Override
    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.storeMetadata(providerMetadataIdentifier, serviceDefinitions);
    }

    @Override
    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String value) {
        this.storeMetadata(consumerMetadataIdentifier, value);
    }

    @Override
    protected void doSaveMetadata(ServiceMetadataIdentifier serviceMetadataIdentifier, URL url) {
        this.storeMetadata(serviceMetadataIdentifier, URL.encode(url.toFullString()));
    }

    @Override
    protected void doRemoveMetadata(ServiceMetadataIdentifier serviceMetadataIdentifier) {
        this.deleteMetadata(serviceMetadataIdentifier);
    }

    @Override
    protected List<String> doGetExportedURLs(ServiceMetadataIdentifier metadataIdentifier) {
        String content = this.getConfig(metadataIdentifier);
        if (StringUtils.isEmpty(content)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(URL.decode(content)));
    }

    @Override
    protected void doSaveSubscriberData(SubscriberMetadataIdentifier subscriberMetadataIdentifier, String urlListStr) {
        this.storeMetadata(subscriberMetadataIdentifier, urlListStr);
    }

    @Override
    protected String doGetSubscribedURLs(SubscriberMetadataIdentifier subscriberMetadataIdentifier) {
        return this.getConfig(subscriberMetadataIdentifier);
    }

    @Override
    public String getServiceDefinition(MetadataIdentifier metadataIdentifier) {
        return this.getConfig(metadataIdentifier);
    }

    private void storeMetadata(BaseMetadataIdentifier identifier, String value) {
        try {
            boolean publishResult = this.configService.publishConfig(identifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY), this.group, value);
            if (!publishResult) {
                throw new RuntimeException("publish nacos metadata failed");
            }
        }
        catch (Throwable t) {
            this.logger.error("Failed to put " + identifier + " to nacos " + value + ", cause: " + t.getMessage(), t);
            throw new RpcException("Failed to put " + identifier + " to nacos " + value + ", cause: " + t.getMessage(), t);
        }
    }

    private void deleteMetadata(BaseMetadataIdentifier identifier) {
        try {
            boolean publishResult = this.configService.removeConfig(identifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY), this.group);
            if (!publishResult) {
                throw new RuntimeException("remove nacos metadata failed");
            }
        }
        catch (Throwable t) {
            this.logger.error("Failed to remove " + identifier + " from nacos , cause: " + t.getMessage(), t);
            throw new RpcException("Failed to remove " + identifier + " from nacos , cause: " + t.getMessage(), t);
        }
    }

    private String getConfig(BaseMetadataIdentifier identifier) {
        try {
            return this.configService.getConfig(identifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY), this.group, 3000L);
        }
        catch (Throwable t) {
            this.logger.error("Failed to get " + identifier + " from nacos , cause: " + t.getMessage(), t);
            throw new RpcException("Failed to get " + identifier + " from nacos , cause: " + t.getMessage(), t);
        }
    }
}

