/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.failover;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.definition.model.ServiceDefinition;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportFactory;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.store.failover.StrategyMetadataReport;

public class FailoverMetadataReport
extends StrategyMetadataReport {
    private static final Logger logger = LoggerFactory.getLogger(FailoverMetadataReport.class);
    private static final String PROTOCOL_KEY = "protocol";
    private static final String CLUSTER_KEY = "clusters";
    private static final String HOST_KEY = "hosts";
    private static final Pattern HOST_SPLIT_PATTERN = Pattern.compile("\\s*[|:]+\\s*");
    private List<URL> failoverUrls = this.fetchBackupUrls();
    private List<MetadataReportHolder> proxyReports = this.buildProxyReports();
    private MetadataReportHolder localDataCenterReportHolder;

    public FailoverMetadataReport(URL url) {
        super(url);
    }

    protected List<URL> fetchBackupUrls() {
        URL url;
        String protocol = this.url.getParameter(PROTOCOL_KEY);
        if (protocol == null || !ExtensionLoader.getExtensionLoader(MetadataReportFactory.class).hasExtension(protocol)) {
            throw new IllegalArgumentException("No '" + protocol + "' metadata report extension found, please check if metadata report module dependencies are included.");
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        String clusters = this.url.getParameter(CLUSTER_KEY);
        String backupHost = this.url.getParameter(HOST_KEY);
        URL metadataURL = url = this.url.removeParameters(CLUSTER_KEY, HOST_KEY, PROTOCOL_KEY).setProtocol(protocol);
        if (backupHost != null && backupHost.length() > 0) {
            metadataURL = metadataURL.addParameter("backup", backupHost);
        }
        urls.add(metadataURL);
        if (clusters != null && (clusters = clusters.trim()).length() > 0) {
            String[] addresses;
            for (String address : addresses = CommonConstants.REGISTRY_SPLIT_PATTERN.split(clusters)) {
                String[] hosts = CommonConstants.COMMA_SPLIT_PATTERN.split(address);
                if (hosts.length <= 0) continue;
                String node = hosts[0];
                String username = null;
                String password = null;
                int index = node.indexOf("@");
                if (index > 0) {
                    String[] authority = HOST_SPLIT_PATTERN.split(node.substring(0, index));
                    username = authority[0];
                    password = authority[1];
                    node = node.substring(index + 1);
                }
                String[] hostInfo = HOST_SPLIT_PATTERN.split(node);
                String host = hostInfo[0];
                int port = Integer.parseInt(hostInfo[1]);
                URL clusterURL = new URL(protocol, username, password, host, port, url.getPath(), url.getParameters());
                if (hosts.length > 1) {
                    StringBuilder buffer = new StringBuilder();
                    for (int i = 1; i < hosts.length; ++i) {
                        if (i > 1) {
                            buffer.append(",");
                        }
                        buffer.append(hosts[i]);
                    }
                    clusterURL = clusterURL.addParameters("backup", buffer.toString());
                }
                urls.add(clusterURL);
            }
        }
        return urls;
    }

    protected List<MetadataReportHolder> buildProxyReports() {
        ArrayList<MetadataReportHolder> reports = new ArrayList<MetadataReportHolder>();
        if (this.failoverUrls != null && !this.failoverUrls.isEmpty()) {
            ExtensionLoader<MetadataReportFactory> factoryLoader = ExtensionLoader.getExtensionLoader(MetadataReportFactory.class);
            for (URL url : this.failoverUrls) {
                try {
                    MetadataReportHolder holder2 = new MetadataReportHolder(url, factoryLoader.getExtension(url.getProtocol()).getMetadataReport(url));
                    reports.add(holder2);
                }
                catch (Exception e) {
                    if (url.getParameter("check", true)) {
                        throw new RuntimeException("Failed to create + '" + url.getProtocol() + "' metadata report extension instance", e);
                    }
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("Failed to create + '" + url.getProtocol() + "' metadata report extension instance, check=false found.");
                }
            }
        }
        Collections.shuffle(reports);
        reports.forEach(holder -> {
            if (this.isLocalDataCenter(holder.url)) {
                this.localDataCenterReportHolder = holder;
            }
        });
        return reports;
    }

    @Override
    public void storeProviderMetadata(MetadataIdentifier providerMetadataIdentifier, ServiceDefinition serviceDefinition) {
        this.proxyReports.forEach(holder -> {
            if (this.shouldRegister(holder.url)) {
                try {
                    holder.report.storeProviderMetadata(providerMetadataIdentifier, serviceDefinition);
                    return;
                }
                catch (Exception e) {
                    if (!this.url.getParameter("check", true)) return;
                    throw e;
                }
            } else {
                if (!logger.isInfoEnabled()) return;
                logger.info("Cancel to store provider metadata, register is false. url " + holder.url);
            }
        });
    }

    @Override
    public void storeConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, Map<String, String> serviceParameterMap) {
        this.proxyReports.forEach(holder -> {
            if (this.shouldRegister(holder.url)) {
                try {
                    holder.report.storeConsumerMetadata(consumerMetadataIdentifier, serviceParameterMap);
                    return;
                }
                catch (Exception e) {
                    if (!this.url.getParameter("check", true)) return;
                    throw e;
                }
            } else {
                if (!logger.isInfoEnabled()) return;
                logger.info("Cancel to store consumer metadata, register is false. url " + holder.url);
            }
        });
    }

    @Override
    public void publishAppMetadata(SubscriberMetadataIdentifier identifier, MetadataInfo metadataInfo) {
        this.proxyReports.forEach(holder -> {
            if (this.shouldRegister(holder.url)) {
                try {
                    holder.report.publishAppMetadata(identifier, metadataInfo);
                    return;
                }
                catch (Exception e) {
                    if (!this.url.getParameter("check", true)) return;
                    throw e;
                }
            } else {
                if (!logger.isInfoEnabled()) return;
                logger.info("Cancel to publish app metadata, register is false. url " + holder.url);
            }
        });
    }

    @Override
    public String getServiceDefinition(MetadataIdentifier metadataIdentifier) {
        MetadataReportHolder localReportHolder;
        block9: {
            localReportHolder = this.localDataCenterReportHolder;
            if (localReportHolder != null && this.shouldQuery(localReportHolder.url)) {
                try {
                    String definition = localReportHolder.report.getServiceDefinition(metadataIdentifier);
                    if (definition != null && definition.length() > 0) {
                        return definition;
                    }
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block9;
                    logger.warn("Failed to get service definition from local metadata report center, url " + localReportHolder.url);
                }
            }
        }
        for (MetadataReportHolder holder : this.proxyReports) {
            block10: {
                if (localReportHolder != null && holder.url == localReportHolder.url) continue;
                if (this.shouldQuery(holder.url)) {
                    try {
                        String definition = holder.report.getServiceDefinition(metadataIdentifier);
                        if (definition != null && definition.length() > 0) {
                            return definition;
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isWarnEnabled()) break block10;
                        logger.warn("Failed to get service definition from metadata report center, url " + holder.url);
                    }
                }
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info("Cancel to get service definition, should query is false. url " + holder.url);
        }
        return null;
    }

    @Override
    public MetadataInfo getAppMetadata(SubscriberMetadataIdentifier identifier, Map<String, String> instanceMetadata) {
        MetadataReportHolder localReportHolder;
        block9: {
            localReportHolder = this.localDataCenterReportHolder;
            if (localReportHolder != null && this.shouldQuery(localReportHolder.url)) {
                try {
                    MetadataInfo metadataInfo = localReportHolder.report.getAppMetadata(identifier, instanceMetadata);
                    if (metadataInfo != null) {
                        return metadataInfo;
                    }
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block9;
                    logger.warn("Failed to get app metadata from local metadata report center, url " + localReportHolder.url);
                }
            }
        }
        for (MetadataReportHolder holder : this.proxyReports) {
            block10: {
                if (localReportHolder != null && holder.url == localReportHolder.url) continue;
                if (this.shouldQuery(holder.url)) {
                    try {
                        MetadataInfo metadataInfo = holder.report.getAppMetadata(identifier, instanceMetadata);
                        if (metadataInfo != null) {
                            return metadataInfo;
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isWarnEnabled()) break block10;
                        logger.warn("Failed to get app metadata from metadata report center, url " + holder.url);
                    }
                }
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info("Cancel to get app metadata, should query is false. url " + holder.url);
        }
        return null;
    }

    @Override
    public Set<String> getServiceAppMapping(String serviceKey, MappingListener listener, URL url) {
        MetadataReportHolder localReportHolder;
        block9: {
            localReportHolder = this.localDataCenterReportHolder;
            if (localReportHolder != null && this.shouldQuery(localReportHolder.url)) {
                try {
                    Set<String> appMapping = localReportHolder.report.getServiceAppMapping(serviceKey, listener, url);
                    if (appMapping != null && !appMapping.isEmpty()) {
                        return appMapping;
                    }
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block9;
                    logger.warn("Failed to get service mapping from local metadata report center, url " + localReportHolder.url);
                }
            }
        }
        for (MetadataReportHolder holder : this.proxyReports) {
            block10: {
                if (localReportHolder != null && holder.url == localReportHolder.url) continue;
                if (this.shouldQuery(holder.url)) {
                    try {
                        Set<String> appMapping = holder.report.getServiceAppMapping(serviceKey, listener, url);
                        if (appMapping != null && !appMapping.isEmpty()) {
                            return appMapping;
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isWarnEnabled()) break block10;
                        logger.warn("Failed to get service mapping from metadata report center, url " + holder.url);
                    }
                }
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info("Cancel to get service mapping, should query is false. url " + holder.url);
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public void registerServiceAppMapping(String serviceKey, String application, URL url) {
        this.proxyReports.forEach(holder -> {
            if (this.shouldRegister(holder.url)) {
                try {
                    holder.report.registerServiceAppMapping(serviceKey, application, url);
                    return;
                }
                catch (Exception e) {
                    if (!url.getParameter("check", true)) return;
                    throw e;
                }
            } else {
                if (!logger.isInfoEnabled()) return;
                logger.info("Cancel to register service app mapping, register is false. url " + holder.url);
            }
        });
    }

    @Override
    public void saveServiceMetadata(ServiceMetadataIdentifier metadataIdentifier, URL url) {
        this.proxyReports.forEach(holder -> {
            if (this.shouldRegister(holder.url)) {
                try {
                    holder.report.saveServiceMetadata(metadataIdentifier, url);
                    return;
                }
                catch (Exception e) {
                    if (!url.getParameter("check", true)) return;
                    throw e;
                }
            } else {
                if (!logger.isInfoEnabled()) return;
                logger.info("Cancel to register service app mapping, register is false. url " + holder.url);
            }
        });
    }

    @Override
    public void saveSubscribedData(SubscriberMetadataIdentifier subscriberMetadataIdentifier, Set<String> urls) {
        this.proxyReports.forEach(holder -> {
            if (this.shouldRegister(holder.url)) {
                try {
                    holder.report.saveSubscribedData(subscriberMetadataIdentifier, urls);
                    return;
                }
                catch (Exception e) {
                    if (!this.url.getParameter("check", true)) return;
                    throw e;
                }
            } else {
                if (!logger.isInfoEnabled()) return;
                logger.info("Cancel to register service app mapping, register is false. url " + holder.url);
            }
        });
    }

    @Override
    public void removeServiceMetadata(ServiceMetadataIdentifier metadataIdentifier) {
        this.proxyReports.forEach(holder -> {
            block3: {
                if (this.shouldRegister(holder.url)) {
                    try {
                        holder.report.removeServiceMetadata(metadataIdentifier);
                    }
                    catch (Exception e) {
                        if (!this.url.getParameter("check", true)) break block3;
                        throw e;
                    }
                }
            }
        });
    }

    @Override
    public List<String> getExportedURLs(ServiceMetadataIdentifier metadataIdentifier) {
        MetadataReportHolder localReportHolder;
        block9: {
            localReportHolder = this.localDataCenterReportHolder;
            if (localReportHolder != null && this.shouldQuery(localReportHolder.url)) {
                try {
                    List<String> exportedURLs = localReportHolder.report.getExportedURLs(metadataIdentifier);
                    if (exportedURLs != null && !exportedURLs.isEmpty()) {
                        return exportedURLs;
                    }
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block9;
                    logger.warn("Failed to get exported urls from local metadata report center, url " + localReportHolder.url);
                }
            }
        }
        for (MetadataReportHolder holder : this.proxyReports) {
            block10: {
                if (localReportHolder != null && holder.url == localReportHolder.url) continue;
                if (this.shouldQuery(holder.url)) {
                    try {
                        List<String> exportedURLs = holder.report.getExportedURLs(metadataIdentifier);
                        if (exportedURLs != null && !exportedURLs.isEmpty()) {
                            return exportedURLs;
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isWarnEnabled()) break block10;
                        logger.warn("Failed to get exported urls from metadata report center, url " + holder.url);
                    }
                }
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info("Cancel to get exported urls, should query is false. url " + holder.url);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<String> getSubscribedURLs(SubscriberMetadataIdentifier subscriberMetadataIdentifier) {
        MetadataReportHolder localReportHolder;
        block9: {
            localReportHolder = this.localDataCenterReportHolder;
            if (localReportHolder != null && this.shouldQuery(localReportHolder.url)) {
                try {
                    List<String> subscribedURLs = localReportHolder.report.getSubscribedURLs(subscriberMetadataIdentifier);
                    if (subscribedURLs != null && !subscribedURLs.isEmpty()) {
                        return subscribedURLs;
                    }
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block9;
                    logger.warn("Failed to get subscribed urls from local metadata report center, url " + localReportHolder.url);
                }
            }
        }
        for (MetadataReportHolder holder : this.proxyReports) {
            block10: {
                if (localReportHolder != null && holder.url == localReportHolder.url) continue;
                if (this.shouldQuery(holder.url)) {
                    try {
                        List<String> subscribedURLs = holder.report.getSubscribedURLs(subscriberMetadataIdentifier);
                        if (subscribedURLs != null && !subscribedURLs.isEmpty()) {
                            return subscribedURLs;
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isWarnEnabled()) break block10;
                        logger.warn("Failed to get subscribed urls from metadata report center, url " + holder.url);
                    }
                }
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info("Cancel to get subscribed urls, should query is false. url " + holder.url);
        }
        return Collections.EMPTY_LIST;
    }

    public List<MetadataReportHolder> getProxyReports() {
        return this.proxyReports;
    }

    class MetadataReportHolder {
        final URL url;
        final MetadataReport report;

        public MetadataReportHolder(URL url, MetadataReport report) {
            this.url = url;
            this.report = report;
        }
    }
}

