/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.zookeeper;

import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.TreePathDynamicConfiguration;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.configcenter.support.zookeeper.CacheListener;
import org.apache.dubbo.remoting.zookeeper.ZookeeperClient;
import org.apache.dubbo.remoting.zookeeper.ZookeeperTransporter;

public class ZookeeperDynamicConfiguration
extends TreePathDynamicConfiguration {
    private Executor executor;
    private String rootPath;
    private final ZookeeperClient zkClient;
    private CountDownLatch initializedLatch;
    private CacheListener cacheListener;
    private URL url;

    ZookeeperDynamicConfiguration(URL url, ZookeeperTransporter zookeeperTransporter) {
        super(url);
        this.url = url;
        this.rootPath = this.getRootPath(url);
        this.initializedLatch = new CountDownLatch(1);
        this.cacheListener = new CacheListener(this.rootPath, this.initializedLatch);
        this.executor = Executors.newFixedThreadPool(1, new NamedThreadFactory(this.getClass().getSimpleName(), true));
        this.zkClient = zookeeperTransporter.connect(url);
        this.zkClient.addDataListener(this.rootPath, this.cacheListener, this.executor);
        try {
            long timeout = url.getParameter("init.timeout", 5000);
            boolean isCountDown = this.initializedLatch.await(timeout, TimeUnit.MILLISECONDS);
            if (!isCountDown) {
                throw new IllegalStateException("Failed to receive INITIALIZED event from zookeeper, pls. check if url " + url + " is correct");
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("Failed to build local cache for config center (zookeeper)." + url);
        }
    }

    @Override
    public String getInternalProperty(String key) {
        return this.zkClient.getContent(this.buildPathKey("", key));
    }

    @Override
    protected void doClose() throws Exception {
        this.zkClient.close();
    }

    @Override
    protected boolean doPublishConfig(String pathKey, String content) throws Exception {
        this.zkClient.create(pathKey, content, false);
        return true;
    }

    @Override
    protected String doGetConfig(String pathKey) throws Exception {
        return this.zkClient.getContent(pathKey);
    }

    @Override
    protected boolean doRemoveConfig(String pathKey) throws Exception {
        this.zkClient.delete(pathKey);
        return true;
    }

    @Override
    protected Collection<String> doGetConfigKeys(String groupPath) {
        return this.zkClient.getChildren(groupPath);
    }

    @Override
    protected void doAddListener(String pathKey, ConfigurationListener listener) {
        this.cacheListener.addListener(pathKey, listener);
    }

    @Override
    protected void doRemoveListener(String pathKey, ConfigurationListener listener) {
        this.cacheListener.removeListener(pathKey, listener);
    }
}

