/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.proxy.wrapper;

import java.lang.reflect.Constructor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.bytecode.Wrapper;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.service.GenericService;

public class StubProxyFactoryWrapper
implements ProxyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(StubProxyFactoryWrapper.class);
    private final ProxyFactory proxyFactory;
    private Protocol protocol;

    public StubProxyFactoryWrapper(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public <T> T getProxy(Invoker<T> invoker, boolean generic) throws RpcException {
        return this.proxyFactory.getProxy(invoker, generic);
    }

    @Override
    public <T> T getProxy(Invoker<T> invoker) throws RpcException {
        String stub;
        Object proxy = this.proxyFactory.getProxy(invoker);
        if (GenericService.class != invoker.getInterface() && ConfigUtils.isNotEmpty(stub = invoker.getUrl().getParameter("stub", invoker.getUrl().getParameter("local")))) {
            Class<T> serviceType = invoker.getInterface();
            if (ConfigUtils.isDefault(stub)) {
                stub = invoker.getUrl().hasParameter("stub") ? serviceType.getName() + "Stub" : serviceType.getName() + "Local";
            }
            try {
                Class<?> stubClass = ReflectUtils.forName(stub);
                if (!serviceType.isAssignableFrom(stubClass)) {
                    throw new IllegalStateException("The stub implementation class " + stubClass.getName() + " not implement interface " + serviceType.getName());
                }
                try {
                    Constructor<?> constructor = ReflectUtils.findConstructor(stubClass, serviceType);
                    proxy = constructor.newInstance(proxy);
                    URL url = invoker.getUrl();
                    if (url.getParameter("dubbo.stub.event", false)) {
                        url = url.addParameter("dubbo.stub.event.methods", StringUtils.join(Wrapper.getWrapper(proxy.getClass()).getDeclaredMethodNames(), ","));
                        url = url.addParameter("isserver", Boolean.FALSE.toString());
                        try {
                            this.export(proxy, invoker.getInterface(), url);
                        }
                        catch (Exception e) {
                            LOGGER.error("export a stub service error.", e);
                        }
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("No such constructor \"public " + stubClass.getSimpleName() + "(" + serviceType.getName() + ")\" in stub implementation class " + stubClass.getName(), e);
                }
            }
            catch (Throwable t) {
                LOGGER.error("Failed to create stub implementation class " + stub + " in consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + ", cause: " + t.getMessage(), t);
            }
        }
        return (T)proxy;
    }

    @Override
    public <T> Invoker<T> getInvoker(T proxy, Class<T> type, URL url) throws RpcException {
        return this.proxyFactory.getInvoker(proxy, type, url);
    }

    private <T> Exporter<T> export(T instance, Class<T> type, URL url) {
        return this.protocol.export(this.proxyFactory.getInvoker(instance, type, url));
    }
}

