/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.zookeeper.zkclient;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.zookeeper.Watcher;

public class ZkClientWrapper {
    private Logger logger = LoggerFactory.getLogger(ZkClientWrapper.class);
    private long timeout;
    private ZkClient client;
    private volatile Watcher.Event.KeeperState state;
    private CompletableFuture<ZkClient> completableFuture;
    private volatile boolean started = false;

    public ZkClientWrapper(String serverAddr, long timeout) {
        this.timeout = timeout;
        this.completableFuture = CompletableFuture.supplyAsync(() -> new ZkClient(serverAddr, Integer.MAX_VALUE));
    }

    public void start() {
        if (!this.started) {
            try {
                this.client = this.completableFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (Throwable t) {
                this.logger.error("Timeout! zookeeper server can not be connected in : " + this.timeout + "ms!", t);
                this.completableFuture.whenComplete(this::makeClientReady);
            }
            this.started = true;
        } else {
            this.logger.warn("Zkclient has already been started!");
        }
    }

    public void addListener(IZkStateListener listener) {
        this.completableFuture.whenComplete((value, exception) -> {
            this.makeClientReady((ZkClient)value, (Throwable)exception);
            if (exception == null) {
                this.client.subscribeStateChanges(listener);
            }
        });
    }

    public boolean isConnected() {
        return this.client != null;
    }

    public void createPersistent(String path) {
        Assert.notNull((Object)this.client, new IllegalStateException("Zookeeper is not connected yet!"));
        this.client.createPersistent(path, true);
    }

    public void createEphemeral(String path) {
        Assert.notNull((Object)this.client, new IllegalStateException("Zookeeper is not connected yet!"));
        this.client.createEphemeral(path);
    }

    public void createPersistent(String path, String data) {
        Assert.notNull((Object)this.client, new IllegalStateException("Zookeeper is not connected yet!"));
        this.client.createPersistent(path, (Object)data);
    }

    public void createEphemeral(String path, String data) {
        Assert.notNull((Object)this.client, new IllegalStateException("Zookeeper is not connected yet!"));
        this.client.createEphemeral(path, (Object)data);
    }

    public void delete(String path) {
        Assert.notNull((Object)this.client, new IllegalStateException("Zookeeper is not connected yet!"));
        this.client.delete(path);
    }

    public List<String> getChildren(String path) {
        Assert.notNull((Object)this.client, new IllegalStateException("Zookeeper is not connected yet!"));
        return this.client.getChildren(path);
    }

    public String getData(String path) {
        Assert.notNull((Object)this.client, new IllegalStateException("Zookeeper is not connected yet!"));
        return (String)this.client.readData(path);
    }

    public boolean exists(String path) {
        Assert.notNull((Object)this.client, new IllegalStateException("Zookeeper is not connected yet!"));
        return this.client.exists(path);
    }

    public void close() {
        Assert.notNull((Object)this.client, new IllegalStateException("Zookeeper is not connected yet!"));
        this.client.close();
    }

    public List<String> subscribeChildChanges(String path, IZkChildListener listener) {
        Assert.notNull((Object)this.client, new IllegalStateException("Zookeeper is not connected yet!"));
        return this.client.subscribeChildChanges(path, listener);
    }

    public void unsubscribeChildChanges(String path, IZkChildListener listener) {
        Assert.notNull((Object)this.client, new IllegalStateException("Zookeeper is not connected yet!"));
        this.client.unsubscribeChildChanges(path, listener);
    }

    private void makeClientReady(ZkClient client, Throwable e) {
        if (e != null) {
            this.logger.error("Got an exception when trying to create zkclient instance, can not connect to zookeeper server, please check!", e);
        } else {
            this.client = client;
        }
    }
}

