/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.zookeeper.support;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.zookeeper.ChildListener;
import org.apache.dubbo.remoting.zookeeper.StateListener;
import org.apache.dubbo.remoting.zookeeper.ZookeeperClient;

public abstract class AbstractZookeeperClient<TargetChildListener>
implements ZookeeperClient {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractZookeeperClient.class);
    private final URL url;
    private final Set<StateListener> stateListeners = new CopyOnWriteArraySet<StateListener>();
    private final ConcurrentMap<String, ConcurrentMap<ChildListener, TargetChildListener>> childListeners = new ConcurrentHashMap<String, ConcurrentMap<ChildListener, TargetChildListener>>();
    private volatile boolean closed = false;

    public AbstractZookeeperClient(URL url) {
        this.url = url;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void create(String path, boolean ephemeral) {
        if (!ephemeral && this.checkExists(path)) {
            return;
        }
        int i = path.lastIndexOf(47);
        if (i > 0) {
            this.create(path.substring(0, i), false);
        }
        if (ephemeral) {
            this.createEphemeral(path);
        } else {
            this.createPersistent(path);
        }
    }

    @Override
    public void addStateListener(StateListener listener) {
        this.stateListeners.add(listener);
    }

    @Override
    public void removeStateListener(StateListener listener) {
        this.stateListeners.remove(listener);
    }

    public Set<StateListener> getSessionListeners() {
        return this.stateListeners;
    }

    @Override
    public List<String> addChildListener(String path, ChildListener listener) {
        Object targetListener;
        ConcurrentMap listeners = (ConcurrentMap)this.childListeners.get(path);
        if (listeners == null) {
            this.childListeners.putIfAbsent(path, new ConcurrentHashMap());
            listeners = (ConcurrentMap)this.childListeners.get(path);
        }
        if ((targetListener = listeners.get(listener)) == null) {
            listeners.putIfAbsent(listener, this.createTargetChildListener(path, listener));
            targetListener = listeners.get(listener);
        }
        return this.addTargetChildListener(path, targetListener);
    }

    @Override
    public void removeChildListener(String path, ChildListener listener) {
        Object targetListener;
        ConcurrentMap listeners = (ConcurrentMap)this.childListeners.get(path);
        if (listeners != null && (targetListener = listeners.remove(listener)) != null) {
            this.removeTargetChildListener(path, targetListener);
        }
    }

    protected void stateChanged(int state) {
        for (StateListener sessionListener : this.getSessionListeners()) {
            sessionListener.stateChanged(state);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.doClose();
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
    }

    @Override
    public void create(String path, String content, boolean ephemeral) {
        int i;
        if (this.checkExists(path)) {
            this.delete(path);
        }
        if ((i = path.lastIndexOf(47)) > 0) {
            this.create(path.substring(0, i), false);
        }
        if (ephemeral) {
            this.createEphemeral(path, content);
        } else {
            this.createPersistent(path, content);
        }
    }

    @Override
    public String getContent(String path) {
        if (!this.checkExists(path)) {
            return null;
        }
        return this.doGetContent(path);
    }

    protected abstract void doClose();

    protected abstract void createPersistent(String var1);

    protected abstract void createEphemeral(String var1);

    protected abstract void createPersistent(String var1, String var2);

    protected abstract void createEphemeral(String var1, String var2);

    protected abstract boolean checkExists(String var1);

    protected abstract TargetChildListener createTargetChildListener(String var1, ChildListener var2);

    protected abstract List<String> addTargetChildListener(String var1, TargetChildListener var2);

    protected abstract void removeTargetChildListener(String var1, TargetChildListener var2);

    protected abstract String doGetContent(String var1);
}

