/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.dubbo.common.Constants;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.bytecode.Wrapper;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.AbstractReferenceConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.metadata.integration.MetadataReportService;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.directory.StaticDirectory;
import org.apache.dubbo.rpc.cluster.support.ClusterUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.protocol.injvm.InjvmProtocol;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public class ReferenceConfig<T>
extends AbstractReferenceConfig {
    private static final long serialVersionUID = -5864351140409987595L;
    private static final Protocol refprotocol = ExtensionLoader.getExtensionLoader(Protocol.class).getAdaptiveExtension();
    private static final Cluster cluster = ExtensionLoader.getExtensionLoader(Cluster.class).getAdaptiveExtension();
    private static final ProxyFactory proxyFactory = ExtensionLoader.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
    private final List<URL> urls = new ArrayList<URL>();
    private String interfaceName;
    private Class<?> interfaceClass;
    private String client;
    private String url;
    private List<MethodConfig> methods;
    private ConsumerConfig consumer;
    private String protocol;
    private volatile transient T ref;
    private volatile transient Invoker<?> invoker;
    private volatile transient boolean initialized;
    private volatile transient boolean destroyed;
    private final Object finalizerGuardian = new Object(){

        protected void finalize() throws Throwable {
            super.finalize();
            if (!ReferenceConfig.this.destroyed) {
                AbstractConfig.logger.warn("ReferenceConfig(" + ReferenceConfig.this.url + ") is not DESTROYED when FINALIZE");
            }
        }
    };

    public ReferenceConfig() {
    }

    public ReferenceConfig(Reference reference) {
        this.appendAnnotation(Reference.class, reference);
    }

    public URL toUrl() {
        return this.urls.isEmpty() ? null : this.urls.iterator().next();
    }

    public List<URL> toUrls() {
        return this.urls;
    }

    public void checkAndUpdateSubConfigs() {
        if (this.interfaceName == null || this.interfaceName.length() == 0) {
            throw new IllegalStateException("<dubbo:reference interface=\"\" /> interface not allow null!");
        }
        this.completeCompoundConfigs();
        this.startConfigCenter();
        this.checkDefault();
        this.refresh();
        if (this.getGeneric() == null && this.getConsumer() != null) {
            this.setGeneric(this.getConsumer().getGeneric());
        }
        if (ProtocolUtils.isGeneric(this.getGeneric())) {
            this.interfaceClass = GenericService.class;
        } else {
            try {
                this.interfaceClass = Class.forName(this.interfaceName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            this.checkInterfaceAndMethods(this.interfaceClass, this.methods);
        }
        this.resolveFile();
        this.checkApplication();
        this.checkMetadataReport();
    }

    public synchronized T get() {
        this.checkAndUpdateSubConfigs();
        if (this.destroyed) {
            throw new IllegalStateException("Already destroyed!");
        }
        if (this.ref == null) {
            this.init();
        }
        return this.ref;
    }

    public synchronized void destroy() {
        if (this.ref == null) {
            return;
        }
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        try {
            this.invoker.destroy();
        }
        catch (Throwable t) {
            logger.warn("Unexpected err when destroy invoker of ReferenceConfig(" + this.url + ").", t);
        }
        this.invoker = null;
        this.ref = null;
    }

    private void init() {
        String hostToRegistry;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.checkStubAndLocal(this.interfaceClass);
        this.checkMock(this.interfaceClass);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("side", "consumer");
        ReferenceConfig.appendRuntimeParameters(map);
        if (!this.isGeneric().booleanValue()) {
            Object methods;
            String revision = Version.getVersion(this.interfaceClass, this.version);
            if (revision != null && revision.length() > 0) {
                map.put("revision", revision);
            }
            if (((String[])(methods = Wrapper.getWrapper(this.interfaceClass).getMethodNames())).length == 0) {
                logger.warn("NO method found in service interface " + this.interfaceClass.getName());
                map.put("methods", "*");
            } else {
                map.put("methods", StringUtils.join(new HashSet<String>(Arrays.asList(methods)), ","));
            }
        }
        map.put("interface", this.interfaceName);
        ReferenceConfig.appendParameters(map, this.application);
        ReferenceConfig.appendParameters(map, this.module);
        ReferenceConfig.appendParameters(map, this.consumer, "default");
        ReferenceConfig.appendParameters(map, this);
        HashMap<String, Object> attributes = null;
        if (this.methods != null && !this.methods.isEmpty()) {
            attributes = new HashMap<String, Object>();
            for (MethodConfig methodConfig : this.methods) {
                String retryValue;
                ReferenceConfig.appendParameters(map, methodConfig, methodConfig.getName());
                String retryKey = methodConfig.getName() + ".retry";
                if (map.containsKey(retryKey) && "false".equals(retryValue = (String)map.remove(retryKey))) {
                    map.put(methodConfig.getName() + ".retries", "0");
                }
                attributes.put(methodConfig.getName(), ReferenceConfig.convertMethodConfig2AyncInfo(methodConfig));
            }
        }
        if ((hostToRegistry = ConfigUtils.getSystemProperty("DUBBO_IP_TO_REGISTRY")) == null || hostToRegistry.length() == 0) {
            hostToRegistry = NetUtils.getLocalHost();
        } else if (NetUtils.isInvalidLocalHost(hostToRegistry)) {
            throw new IllegalArgumentException("Specified invalid registry ip from property:DUBBO_IP_TO_REGISTRY, value:" + hostToRegistry);
        }
        map.put("register.ip", hostToRegistry);
        this.ref = this.createProxy(map);
        ConsumerModel consumerModel = new ConsumerModel(this.getUniqueServiceName(), this.interfaceClass, this.ref, this.interfaceClass.getMethods(), attributes);
        ApplicationModel.initConsumerModel(this.getUniqueServiceName(), consumerModel);
    }

    private T createProxy(Map<String, String> map) {
        URL tmpUrl = new URL("temp", "localhost", 0, map);
        boolean isJvmRefer = this.isInjvm() == null ? (this.url != null && this.url.length() > 0 ? false : InjvmProtocol.getInjvmProtocol().isInjvmRefer(tmpUrl)) : this.isInjvm();
        if (isJvmRefer) {
            URL url = new URL("injvm", "127.0.0.1", 0, this.interfaceClass.getName()).addParameters(map);
            this.invoker = refprotocol.refer(this.interfaceClass, url);
            if (logger.isInfoEnabled()) {
                logger.info("Using injvm service " + this.interfaceClass.getName());
            }
        } else {
            String[] us;
            if (this.url != null && this.url.length() > 0) {
                us = Constants.SEMICOLON_SPLIT_PATTERN.split(this.url);
                if (us != null && us.length > 0) {
                    for (String u : us) {
                        URL url = URL.valueOf(u);
                        if (url.getPath() == null || url.getPath().length() == 0) {
                            url = url.setPath(this.interfaceName);
                        }
                        if ("registry".equals(url.getProtocol())) {
                            this.urls.add(url.addParameterAndEncoded("refer", StringUtils.toQueryString(map)));
                            continue;
                        }
                        this.urls.add(ClusterUtils.mergeUrl(url, map));
                    }
                }
            } else {
                this.checkRegistry();
                us = this.loadRegistries(false);
                if (us != null && !us.isEmpty()) {
                    for (URL uRL : us) {
                        URL monitorUrl = this.loadMonitor(uRL);
                        if (monitorUrl != null) {
                            map.put("monitor", URL.encode(monitorUrl.toFullString()));
                        }
                        this.urls.add(uRL.addParameterAndEncoded("refer", StringUtils.toQueryString(map)));
                    }
                }
                if (this.urls.isEmpty()) {
                    throw new IllegalStateException("No such any registry to reference " + this.interfaceName + " on the consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + ", please config <dubbo:registry address=\"...\" /> to your spring config.");
                }
            }
            if (this.urls.size() == 1) {
                this.invoker = refprotocol.refer(this.interfaceClass, this.urls.get(0));
            } else {
                ArrayList invokers = new ArrayList();
                URL registryURL = null;
                for (URL url : this.urls) {
                    invokers.add(refprotocol.refer(this.interfaceClass, url));
                    if (!"registry".equals(url.getProtocol())) continue;
                    registryURL = url;
                }
                if (registryURL != null) {
                    URL uRL = registryURL.addParameter("cluster", "registryaware");
                    this.invoker = cluster.join(new StaticDirectory(uRL, invokers));
                } else {
                    this.invoker = cluster.join(new StaticDirectory(invokers));
                }
            }
        }
        Boolean c = this.check;
        if (c == null && this.consumer != null) {
            c = this.consumer.isCheck();
        }
        if (c == null) {
            c = true;
        }
        if (c.booleanValue() && !this.invoker.isAvailable()) {
            this.initialized = false;
            throw new IllegalStateException("Failed to check the status of the service " + this.interfaceName + ". No provider available for the service " + (this.group == null ? "" : this.group + "/") + this.interfaceName + (this.version == null ? "" : ":" + this.version) + " from the url " + this.invoker.getUrl() + " to the consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion());
        }
        if (logger.isInfoEnabled()) {
            logger.info("Refer dubbo service " + this.interfaceClass.getName() + " from url " + this.invoker.getUrl());
        }
        MetadataReportService metadataReportService = null;
        metadataReportService = this.getMetadataReportService();
        if (metadataReportService != null) {
            URL uRL = new URL("consumer", map.remove("register.ip"), 0, map.get("interface"), map);
            metadataReportService.publishConsumer(uRL);
        }
        return (T)proxyFactory.getProxy(this.invoker);
    }

    private void checkDefault() {
        this.createConsumerIfAbsent();
    }

    private void createConsumerIfAbsent() {
        if (this.consumer != null) {
            return;
        }
        this.setConsumer(ConfigManager.getInstance().getDefaultConsumer().orElseGet(() -> {
            ConsumerConfig consumerConfig = new ConsumerConfig();
            consumerConfig.refresh();
            return consumerConfig;
        }));
    }

    private void completeCompoundConfigs() {
        if (this.consumer != null) {
            if (this.application == null) {
                this.setApplication(this.consumer.getApplication());
            }
            if (this.module == null) {
                this.setModule(this.consumer.getModule());
            }
            if (this.registries == null) {
                this.setRegistries(this.consumer.getRegistries());
            }
            if (this.monitor == null) {
                this.setMonitor(this.consumer.getMonitor());
            }
        }
        if (this.module != null) {
            if (this.registries == null) {
                this.setRegistries(this.module.getRegistries());
            }
            if (this.monitor == null) {
                this.setMonitor(this.module.getMonitor());
            }
        }
        if (this.application != null) {
            if (this.registries == null) {
                this.setRegistries(this.application.getRegistries());
            }
            if (this.monitor == null) {
                this.setMonitor(this.application.getMonitor());
            }
        }
    }

    public Class<?> getInterfaceClass() {
        if (this.interfaceClass != null) {
            return this.interfaceClass;
        }
        if (this.isGeneric().booleanValue() || this.getConsumer() != null && this.getConsumer().isGeneric().booleanValue()) {
            return GenericService.class;
        }
        try {
            if (this.interfaceName != null && this.interfaceName.length() > 0) {
                this.interfaceClass = Class.forName(this.interfaceName, true, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (ClassNotFoundException t) {
            throw new IllegalStateException(t.getMessage(), t);
        }
        return this.interfaceClass;
    }

    @Deprecated
    public void setInterfaceClass(Class<?> interfaceClass) {
        this.setInterface(interfaceClass);
    }

    public String getInterface() {
        return this.interfaceName;
    }

    public void setInterface(String interfaceName) {
        this.interfaceName = interfaceName;
        if (this.id == null || this.id.length() == 0) {
            this.id = interfaceName;
        }
    }

    public void setInterface(Class<?> interfaceClass) {
        if (interfaceClass != null && !interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        this.interfaceClass = interfaceClass;
        this.setInterface(interfaceClass == null ? null : interfaceClass.getName());
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        ReferenceConfig.checkName("client", client);
        this.client = client;
    }

    @Parameter(excluded=true)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<MethodConfig> getMethods() {
        return this.methods;
    }

    public void setMethods(List<? extends MethodConfig> methods) {
        this.methods = methods;
    }

    public ConsumerConfig getConsumer() {
        return this.consumer;
    }

    public void setConsumer(ConsumerConfig consumer) {
        ConfigManager.getInstance().addConsumer(consumer);
        this.consumer = consumer;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    Invoker<?> getInvoker() {
        return this.invoker;
    }

    @Parameter(excluded=true)
    public String getUniqueServiceName() {
        StringBuilder buf = new StringBuilder();
        if (this.group != null && this.group.length() > 0) {
            buf.append(this.group).append("/");
        }
        buf.append(this.interfaceName);
        if (this.version != null && this.version.length() > 0) {
            buf.append(":").append(this.version);
        }
        return buf.toString();
    }

    @Override
    @Parameter(excluded=true)
    public String getPrefix() {
        return "dubbo.reference." + this.interfaceName;
    }

    private void resolveFile() {
        String resolve = System.getProperty(this.interfaceName);
        String resolveFile = null;
        if (resolve == null || resolve.length() == 0) {
            File userResolveFile;
            resolveFile = System.getProperty("dubbo.resolve.file");
            if ((resolveFile == null || resolveFile.length() == 0) && (userResolveFile = new File(new File(System.getProperty("user.home")), "dubbo-resolve.properties")).exists()) {
                resolveFile = userResolveFile.getAbsolutePath();
            }
            if (resolveFile != null && resolveFile.length() > 0) {
                Properties properties = new Properties();
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(new File(resolveFile));
                    properties.load(fis);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unload " + resolveFile + ", cause: " + e.getMessage(), e);
                }
                finally {
                    try {
                        if (null != fis) {
                            fis.close();
                        }
                    }
                    catch (IOException e) {
                        logger.warn(e.getMessage(), e);
                    }
                }
                resolve = properties.getProperty(this.interfaceName);
            }
        }
        if (resolve != null && resolve.length() > 0) {
            this.url = resolve;
            if (logger.isWarnEnabled()) {
                if (resolveFile != null) {
                    logger.warn("Using default dubbo resolve file " + resolveFile + " replace " + this.interfaceName + "" + resolve + " to p2p invoke remote service.");
                } else {
                    logger.warn("Using -D" + this.interfaceName + "=" + resolve + " to p2p invoke remote service.");
                }
            }
        }
    }
}

