/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.CompositeConfiguration;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.config.InmemoryConfiguration;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassHelper;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.DubboShutdownHook;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ConsumerMethodModel;

public abstract class AbstractConfig
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractConfig.class);
    private static final long serialVersionUID = 4267533505537413570L;
    private static final int MAX_LENGTH = 200;
    private static final int MAX_PATH_LENGTH = 200;
    private static final Pattern PATTERN_NAME = Pattern.compile("[\\-._0-9a-zA-Z]+");
    private static final Pattern PATTERN_MULTI_NAME = Pattern.compile("[,\\-._0-9a-zA-Z]+");
    private static final Pattern PATTERN_METHOD_NAME = Pattern.compile("[a-zA-Z][0-9a-zA-Z]*");
    private static final Pattern PATTERN_PATH = Pattern.compile("[/\\-$._0-9a-zA-Z]+");
    private static final Pattern PATTERN_NAME_HAS_SYMBOL = Pattern.compile("[:*,\\s/\\-._0-9a-zA-Z]+");
    private static final Pattern PATTERN_KEY = Pattern.compile("[*,\\-._0-9a-zA-Z]+");
    private static final Map<String, String> legacyProperties = new HashMap<String, String>();
    private static final String[] SUFFIXES = new String[]{"Config", "Bean"};
    protected String id;
    protected String prefix;

    private static String convertLegacyValue(String key, String value) {
        if (value != null && value.length() > 0) {
            if ("dubbo.service.max.retry.providers".equals(key)) {
                return String.valueOf(Integer.parseInt(value) - 1);
            }
            if ("dubbo.service.allow.no.provider".equals(key)) {
                return String.valueOf(!Boolean.parseBoolean(value));
            }
        }
        return value;
    }

    private static String getTagName(Class<?> cls) {
        String tag = cls.getSimpleName();
        for (String suffix : SUFFIXES) {
            if (!tag.endsWith(suffix)) continue;
            tag = tag.substring(0, tag.length() - suffix.length());
            break;
        }
        return StringUtils.camelToSplitName(tag, "-");
    }

    protected static void appendParameters(Map<String, String> parameters, Object config) {
        AbstractConfig.appendParameters(parameters, config, null);
    }

    protected static void appendParameters(Map<String, String> parameters, Object config, String prefix) {
        Method[] methods;
        if (config == null) {
            return;
        }
        for (Method method : methods = config.getClass().getMethods()) {
            try {
                Map map;
                String name = method.getName();
                if (ClassHelper.isGetter(method)) {
                    Parameter parameter = method.getAnnotation(Parameter.class);
                    if (method.getReturnType() == Object.class || parameter != null && parameter.excluded()) continue;
                    String key = parameter != null && parameter.key().length() > 0 ? parameter.key() : AbstractConfig.calculatePropertyFromGetter(name);
                    Object value = method.invoke(config, new Object[0]);
                    String str = String.valueOf(value).trim();
                    if (value != null && str.length() > 0) {
                        if (parameter != null && parameter.escaped()) {
                            str = URL.encode(str);
                        }
                        if (parameter != null && parameter.append()) {
                            String pre = parameters.get("default." + key);
                            if (pre != null && pre.length() > 0) {
                                str = pre + "," + str;
                            }
                            if ((pre = parameters.get(key)) != null && pre.length() > 0) {
                                str = pre + "," + str;
                            }
                        }
                        if (prefix != null && prefix.length() > 0) {
                            key = prefix + "." + key;
                        }
                        parameters.put(key, str);
                        continue;
                    }
                    if (parameter == null || !parameter.required()) continue;
                    throw new IllegalStateException(config.getClass().getSimpleName() + "." + key + " == null");
                }
                if (!"getParameters".equals(name) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() != Map.class || (map = (Map)method.invoke(config, new Object[0])) == null || map.size() <= 0) continue;
                String pre = prefix != null && prefix.length() > 0 ? prefix + "." : "";
                for (Map.Entry entry : map.entrySet()) {
                    parameters.put(pre + ((String)entry.getKey()).replace('-', '.'), (String)entry.getValue());
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    protected static void appendAttributes(Map<String, Object> parameters, Object config) {
        AbstractConfig.appendAttributes(parameters, config, null);
    }

    protected static void appendAttributes(Map<String, Object> parameters, Object config, String prefix) {
        Method[] methods;
        if (config == null) {
            return;
        }
        for (Method method : methods = config.getClass().getMethods()) {
            try {
                Parameter parameter = method.getAnnotation(Parameter.class);
                if (parameter == null || !parameter.attribute()) continue;
                String name = method.getName();
                if (!ClassHelper.isGetter(method)) continue;
                String key = parameter.key().length() > 0 ? parameter.key() : AbstractConfig.calculateAttributeFromGetter(name);
                Object value = method.invoke(config, new Object[0]);
                if (value == null) continue;
                if (prefix != null && prefix.length() > 0) {
                    key = prefix + "." + key;
                }
                parameters.put(key, value);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    protected static ConsumerMethodModel.AsyncMethodInfo convertMethodConfig2AyncInfo(MethodConfig methodConfig) {
        if (methodConfig == null || methodConfig.getOninvoke() == null && methodConfig.getOnreturn() == null && methodConfig.getOnthrow() == null) {
            return null;
        }
        if (Boolean.FALSE.equals(methodConfig.isReturn()) && (methodConfig.getOnreturn() != null || methodConfig.getOnthrow() != null)) {
            throw new IllegalStateException("method config error : return attribute must be set true when onreturn or onthrow has been set.");
        }
        ConsumerMethodModel.AsyncMethodInfo asyncMethodInfo = new ConsumerMethodModel.AsyncMethodInfo();
        asyncMethodInfo.setOninvokeInstance(methodConfig.getOninvoke());
        asyncMethodInfo.setOnreturnInstance(methodConfig.getOnreturn());
        asyncMethodInfo.setOnthrowInstance(methodConfig.getOnthrow());
        try {
            String onthrowMethod;
            String onreturnMethod;
            String oninvokeMethod = methodConfig.getOninvokeMethod();
            if (StringUtils.isNotEmpty(oninvokeMethod)) {
                asyncMethodInfo.setOninvokeMethod(AbstractConfig.getMethodByName(methodConfig.getOninvoke().getClass(), oninvokeMethod));
            }
            if (StringUtils.isNotEmpty(onreturnMethod = methodConfig.getOnreturnMethod())) {
                asyncMethodInfo.setOnreturnMethod(AbstractConfig.getMethodByName(methodConfig.getOnreturn().getClass(), onreturnMethod));
            }
            if (StringUtils.isNotEmpty(onthrowMethod = methodConfig.getOnthrowMethod())) {
                asyncMethodInfo.setOnthrowMethod(AbstractConfig.getMethodByName(methodConfig.getOnthrow().getClass(), onthrowMethod));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return asyncMethodInfo;
    }

    private static Method getMethodByName(Class<?> clazz, String methodName) {
        try {
            return ReflectUtils.findMethodByMethodName(clazz, methodName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected static void checkExtension(Class<?> type, String property, String value) {
        AbstractConfig.checkName(property, value);
        if (StringUtils.isNotEmpty(value) && !ExtensionLoader.getExtensionLoader(type).hasExtension(value)) {
            throw new IllegalStateException("No such extension " + value + " for " + property + "/" + type.getName());
        }
    }

    protected static void checkMultiExtension(Class<?> type, String property, String value) {
        AbstractConfig.checkMultiName(property, value);
        if (StringUtils.isNotEmpty(value)) {
            String[] values;
            for (String v : values = value.split("\\s*[,]+\\s*")) {
                if (v.startsWith("-")) {
                    v = v.substring(1);
                }
                if ("default".equals(v) || ExtensionLoader.getExtensionLoader(type).hasExtension(v)) continue;
                throw new IllegalStateException("No such extension " + v + " for " + property + "/" + type.getName());
            }
        }
    }

    protected static void checkLength(String property, String value) {
        AbstractConfig.checkProperty(property, value, 200, null);
    }

    protected static void checkPathLength(String property, String value) {
        AbstractConfig.checkProperty(property, value, 200, null);
    }

    protected static void checkName(String property, String value) {
        AbstractConfig.checkProperty(property, value, 200, PATTERN_NAME);
    }

    protected static void checkNameHasSymbol(String property, String value) {
        AbstractConfig.checkProperty(property, value, 200, PATTERN_NAME_HAS_SYMBOL);
    }

    protected static void checkKey(String property, String value) {
        AbstractConfig.checkProperty(property, value, 200, PATTERN_KEY);
    }

    protected static void checkMultiName(String property, String value) {
        AbstractConfig.checkProperty(property, value, 200, PATTERN_MULTI_NAME);
    }

    protected static void checkPathName(String property, String value) {
        AbstractConfig.checkProperty(property, value, 200, PATTERN_PATH);
    }

    protected static void checkMethodName(String property, String value) {
        AbstractConfig.checkProperty(property, value, 200, PATTERN_METHOD_NAME);
    }

    protected static void checkParameterName(Map<String, String> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return;
        }
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            AbstractConfig.checkNameHasSymbol(entry.getKey(), entry.getValue());
        }
    }

    protected static void checkProperty(String property, String value, int maxlength, Pattern pattern) {
        Matcher matcher;
        if (StringUtils.isEmpty(value)) {
            return;
        }
        if (value.length() > maxlength) {
            throw new IllegalStateException("Invalid " + property + "=\"" + value + "\" is longer than " + maxlength);
        }
        if (pattern != null && !(matcher = pattern.matcher(value)).matches()) {
            throw new IllegalStateException("Invalid " + property + "=\"" + value + "\" contains illegal character, only digit, letter, '-', '_' or '.' is legal.");
        }
    }

    protected static Set<String> getSubProperties(Map<String, String> properties, String prefix) {
        return properties.keySet().stream().filter(k -> k.contains(prefix)).map(k -> {
            k = k.substring(prefix.length());
            return k.substring(0, k.indexOf("."));
        }).collect(Collectors.toSet());
    }

    private static String extractPropertyName(Class<?> clazz, Method setter) throws Exception {
        String propertyName = setter.getName().substring("set".length());
        Method getter = null;
        try {
            getter = clazz.getMethod("get" + propertyName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            getter = clazz.getMethod("is" + propertyName, new Class[0]);
        }
        Parameter parameter = getter.getAnnotation(Parameter.class);
        propertyName = parameter != null && StringUtils.isNotEmpty(parameter.key()) && parameter.useKeyAsProperty() ? parameter.key() : propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
        return propertyName;
    }

    private static String calculatePropertyFromGetter(String name) {
        int i = name.startsWith("get") ? 3 : 2;
        return StringUtils.camelToSplitName(name.substring(i, i + 1).toLowerCase() + name.substring(i + 1), ".");
    }

    private static String calculateAttributeFromGetter(String getter) {
        int i = getter.startsWith("get") ? 3 : 2;
        return getter.substring(i, i + 1).toLowerCase() + getter.substring(i + 1);
    }

    @Parameter(excluded=true)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void updateIdIfAbsent(String value) {
        if (StringUtils.isNotEmpty(value) && StringUtils.isEmpty(this.id)) {
            this.id = value;
        }
    }

    protected void appendAnnotation(Class<?> annotationClass, Object annotation) {
        Method[] methods;
        for (Method method : methods = annotationClass.getMethods()) {
            if (method.getDeclaringClass() == Object.class || method.getReturnType() == Void.TYPE || method.getParameterTypes().length != 0 || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
            try {
                String property = method.getName();
                if ("interfaceClass".equals(property) || "interfaceName".equals(property)) {
                    property = "interface";
                }
                String setter = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
                Map<String, String> value = method.invoke(annotation, new Object[0]);
                if (value == null || ((Object)value).equals(method.getDefaultValue())) continue;
                Class<Object> parameterType = ReflectUtils.getBoxedClass(method.getReturnType());
                if ("filter".equals(property) || "listener".equals(property)) {
                    parameterType = String.class;
                    value = StringUtils.join((String[])value, ",");
                } else if ("parameters".equals(property)) {
                    parameterType = Map.class;
                    value = CollectionUtils.toStringMap((String[])value);
                }
                try {
                    Method setterMethod = this.getClass().getMethod(setter, parameterType);
                    setterMethod.invoke((Object)this, value);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    public Map<String, String> getMetaData() {
        Method[] methods;
        HashMap<String, String> metaData = new HashMap<String, String>();
        for (Method method : methods = this.getClass().getMethods()) {
            try {
                Map map;
                String name = method.getName();
                if ((name.startsWith("get") || name.startsWith("is")) && !name.equals("get") && !"getClass".equals(name) && Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0 && ClassHelper.isPrimitive(method.getReturnType())) {
                    String prop = AbstractConfig.calculateAttributeFromGetter(name);
                    Parameter parameter = method.getAnnotation(Parameter.class);
                    String key = parameter != null && parameter.key().length() > 0 && parameter.useKeyAsProperty() ? parameter.key() : prop;
                    if (method.getReturnType() == Object.class) {
                        metaData.put(key, null);
                        continue;
                    }
                    Object value = method.invoke((Object)this, new Object[0]);
                    String str = String.valueOf(value).trim();
                    if (value != null && str.length() > 0) {
                        metaData.put(key, str);
                        continue;
                    }
                    metaData.put(key, null);
                    continue;
                }
                if (!"getParameters".equals(name) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() != Map.class || (map = (Map)method.invoke((Object)this, new Object[0])) == null || map.size() <= 0) continue;
                for (Map.Entry entry : map.entrySet()) {
                    metaData.put(((String)entry.getKey()).replace('-', '.'), (String)entry.getValue());
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return metaData;
    }

    @Parameter(excluded=true)
    public String getPrefix() {
        return StringUtils.isNotEmpty(this.prefix) ? this.prefix : "dubbo." + AbstractConfig.getTagName(this.getClass());
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void refresh() {
        try {
            Method[] methods;
            CompositeConfiguration compositeConfiguration = Environment.getInstance().getConfiguration(this.getPrefix(), this.getId());
            InmemoryConfiguration config = new InmemoryConfiguration(this.getPrefix(), this.getId());
            config.addProperties(this.getMetaData());
            if (Environment.getInstance().isConfigCenterFirst()) {
                compositeConfiguration.addConfiguration(3, config);
            } else {
                compositeConfiguration.addConfiguration(1, config);
            }
            for (Method method : methods = this.getClass().getMethods()) {
                if (!ClassHelper.isSetter(method)) continue;
                try {
                    String value = compositeConfiguration.getString(AbstractConfig.extractPropertyName(this.getClass(), method));
                    if (!StringUtils.isNotEmpty(value) || !ClassHelper.isTypeMatch(method.getParameterTypes()[0], value)) continue;
                    method.invoke((Object)this, ClassHelper.convertPrimitive(method.getParameterTypes()[0], value));
                }
                catch (NoSuchMethodException e) {
                    logger.info("Failed to override the property " + method.getName() + " in " + this.getClass().getSimpleName() + ", please make sure every property has getter/setter method provided.");
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to override ", e);
        }
    }

    public String toString() {
        try {
            Method[] methods;
            StringBuilder buf = new StringBuilder();
            buf.append("<dubbo:");
            buf.append(AbstractConfig.getTagName(this.getClass()));
            for (Method method : methods = this.getClass().getMethods()) {
                try {
                    if (!ClassHelper.isGetter(method)) continue;
                    String name = method.getName();
                    String key = AbstractConfig.calculateAttributeFromGetter(name);
                    Object value = method.invoke((Object)this, new Object[0]);
                    if (value == null) continue;
                    buf.append(" ");
                    buf.append(key);
                    buf.append("=\"");
                    buf.append(value);
                    buf.append("\"");
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), e);
                }
            }
            buf.append(" />");
            return buf.toString();
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
            return super.toString();
        }
    }

    @Parameter(excluded=true)
    public boolean isValid() {
        return true;
    }

    public boolean equals(Object obj) {
        Method[] methods;
        if (obj == null || !obj.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        for (Method method1 : methods = this.getClass().getMethods()) {
            Parameter parameter;
            if (!ClassHelper.isGetter(method1) || !ClassHelper.isPrimitive(method1.getReturnType()) || (parameter = method1.getAnnotation(Parameter.class)) != null && parameter.excluded()) continue;
            try {
                Method method2 = obj.getClass().getMethod(method1.getName(), method1.getParameterTypes());
                Object value1 = method1.invoke((Object)this, new Object[0]);
                Object value2 = method2.invoke(obj, new Object[0]);
                if (value1 == null || value2 == null || value1.equals(value2)) continue;
                return false;
            }
            catch (Exception e) {
                return true;
            }
        }
        return true;
    }

    static {
        legacyProperties.put("dubbo.protocol.name", "dubbo.service.protocol");
        legacyProperties.put("dubbo.protocol.host", "dubbo.service.server.host");
        legacyProperties.put("dubbo.protocol.port", "dubbo.service.server.port");
        legacyProperties.put("dubbo.protocol.threads", "dubbo.service.max.thread.pool.size");
        legacyProperties.put("dubbo.consumer.timeout", "dubbo.service.invoke.timeout");
        legacyProperties.put("dubbo.consumer.retries", "dubbo.service.max.retry.providers");
        legacyProperties.put("dubbo.consumer.check", "dubbo.service.allow.no.provider");
        legacyProperties.put("dubbo.service.url", "dubbo.service.address");
        DubboShutdownHook.getDubboShutdownHook().register();
    }
}

