/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

public class InternalTypeEnumeration {
    private String descriptor;
    private int formalTypeParametersIndex;
    private int openIndex;
    private int closeIndex;
    private int index;

    public InternalTypeEnumeration(String descriptor) {
        this.descriptor = descriptor;
        if (descriptor.charAt(0) == '<') {
            this.formalTypeParametersIndex = 1;
            int nestingLevel = 1;
            do {
                char c = descriptor.charAt(this.formalTypeParametersIndex++);
                switch (c) {
                    case '<': {
                        ++nestingLevel;
                        break;
                    }
                    case '>': {
                        --nestingLevel;
                    }
                }
            } while (nestingLevel > 0);
        }
        this.openIndex = descriptor.indexOf(40, this.formalTypeParametersIndex);
        this.closeIndex = this.openIndex >= 0 ? descriptor.indexOf(41, this.openIndex) : descriptor.length();
        this.index = this.openIndex >= 0 ? this.openIndex + 1 : this.formalTypeParametersIndex;
    }

    public boolean hasFormalTypeParameters() {
        return this.formalTypeParametersIndex > 0;
    }

    public String formalTypeParameters() {
        return this.descriptor.substring(0, this.formalTypeParametersIndex);
    }

    public boolean isMethodSignature() {
        return this.openIndex >= 0;
    }

    public boolean hasMoreTypes() {
        return this.index < this.closeIndex;
    }

    public String nextType() {
        int startIndex = this.index;
        this.skipArray();
        char c = this.descriptor.charAt(this.index++);
        switch (c) {
            case 'L': 
            case 'T': {
                this.skipClass();
                break;
            }
            case '<': {
                this.skipGeneric();
            }
        }
        return this.descriptor.substring(startIndex, this.index);
    }

    public String returnType() {
        return this.descriptor.substring(this.closeIndex + 1);
    }

    private void skipArray() {
        while (this.descriptor.charAt(this.index) == '[') {
            ++this.index;
        }
    }

    private void skipClass() {
        while (true) {
            char c = this.descriptor.charAt(this.index++);
            switch (c) {
                case '<': {
                    this.skipGeneric();
                    break;
                }
                case ';': {
                    return;
                }
            }
        }
    }

    private void skipGeneric() {
        int nestingLevel = 1;
        do {
            char c = this.descriptor.charAt(this.index++);
            switch (c) {
                case '<': {
                    ++nestingLevel;
                    break;
                }
                case '>': {
                    --nestingLevel;
                }
            }
        } while (nestingLevel > 0);
    }

    public static void main(String[] args) {
        try {
            for (int index = 0; index < args.length; ++index) {
                String descriptor = args[index];
                System.out.println("Descriptor [" + descriptor + "]");
                InternalTypeEnumeration enumeration = new InternalTypeEnumeration(descriptor);
                if (enumeration.hasFormalTypeParameters()) {
                    System.out.println("  Formal type parameters [" + enumeration.formalTypeParameters() + "]");
                }
                while (enumeration.hasMoreTypes()) {
                    System.out.println("  Type [" + enumeration.nextType() + "]");
                }
                if (!enumeration.isMethodSignature()) continue;
                System.out.println("  Return type [" + enumeration.returnType() + "]");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

