/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.JHtmlLabel;
import org.jets3t.gui.skins.SkinsFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.utils.ServiceUtils;

public class ErrorDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -1120587010395375292L;
    private static final Log log = LogFactory.getLog(ErrorDialog.class);
    private final Jets3tProperties jets3tProperties = Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME);
    private Properties applicationProperties = null;
    private HyperlinkActivatedListener hyperlinkListener = null;
    private SkinsFactory skinsFactory = null;
    private final Insets insetsDefault = new Insets(3, 5, 3, 5);

    private ErrorDialog(Frame ownerFrame, HyperlinkActivatedListener hyperlinkListener, Properties applicationProperties) {
        super(ownerFrame, "Error Message", true);
        this.hyperlinkListener = hyperlinkListener;
        this.applicationProperties = applicationProperties;
    }

    private ErrorDialog(JDialog ownerDialog, HyperlinkActivatedListener hyperlinkListener, Properties applicationProperties) {
        super(ownerDialog, "Error Message", true);
        this.hyperlinkListener = hyperlinkListener;
        this.applicationProperties = applicationProperties;
    }

    private void initGui(String message, String details) {
        this.skinsFactory = SkinsFactory.getInstance(this.applicationProperties);
        LookAndFeel lookAndFeel = this.skinsFactory.createSkinnedMetalTheme("SkinnedLookAndFeel");
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (UnsupportedLookAndFeelException e) {
            log.error((Object)"Unable to set skinned LookAndFeel", (Throwable)e);
        }
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        JHtmlLabel messageLabel = this.skinsFactory.createSkinnedJHtmlLabel("ErrorMessageLabel", this.hyperlinkListener);
        messageLabel.setText(message);
        messageLabel.setHorizontalAlignment(0);
        JHtmlLabel detailsLabel = this.skinsFactory.createSkinnedJHtmlLabel("ErrorDetailsLabel", this.hyperlinkListener);
        detailsLabel.setText(details);
        JButton okButton = this.skinsFactory.createSkinnedJButton("ErrorOkButton");
        okButton.setName("OK");
        okButton.setText("OK");
        okButton.addActionListener(this);
        this.getRootPane().setDefaultButton(okButton);
        JPanel dialogPanel = this.skinsFactory.createSkinnedJPanel("ErrorDialogPanel");
        int row = 0;
        dialogPanel.setLayout(new GridBagLayout());
        dialogPanel.add((Component)messageLabel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 1, new Insets(12, 5, 12, 5), 0, 0));
        dialogPanel.add((Component)detailsLabel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 1, this.insetsDefault, 0, 0));
        dialogPanel.add((Component)okButton, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 0, this.insetsDefault, 0, 0));
        this.getContentPane().add(dialogPanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void actionPerformed(ActionEvent e) {
        if ("OK".equals(e.getActionCommand())) {
            this.setVisible(false);
        }
    }

    private String buildDetailedText(Throwable throwable) {
        if (!this.jets3tProperties.getBoolProperty("gui.verboseErrorDialog", true)) {
            return null;
        }
        StringBuffer detailsText = new StringBuffer();
        if (throwable instanceof S3ServiceException) {
            detailsText.append("<table border=\"0\">");
            S3ServiceException s3se = (S3ServiceException)throwable;
            if (s3se.getS3ErrorCode() != null) {
                detailsText.append("<tr><td><b>S3 Error Code</b></td><td>").append(s3se.getS3ErrorCode()).append("</td></tr>");
            } else {
                String msg = throwable.getMessage();
                if (msg.length() > 80) {
                    ServiceUtils.wrapString(msg, "<br/>", 80);
                }
                detailsText.append("<tr><td><b>Exception message</b></td></tr><tr><td>").append(msg).append("</td></tr>");
            }
            if (s3se.getS3ErrorMessage() != null) {
                detailsText.append("<tr><td><b>S3 Message</b></td><td>").append(s3se.getS3ErrorMessage()).append("</td></tr>");
            }
            detailsText.append("<tr><td><b>HTTP Status Code</b></td><td>").append(s3se.getResponseCode()).append("</td></tr>");
            if (s3se.getS3ErrorRequestId() != null) {
                detailsText.append("<tr><td><b>S3 Request Id</b></td><td>").append(s3se.getS3ErrorRequestId()).append("</td></tr>");
            }
            if (s3se.getS3ErrorHostId() != null) {
                detailsText.append("<tr><td><b>S3 Host Id</b></td><td>").append(s3se.getS3ErrorHostId()).append("</td></tr>");
            }
            boolean firstCause = true;
            for (Throwable cause = s3se.getCause(); cause != null && cause.getMessage() != null; cause = cause.getCause()) {
                if (firstCause) {
                    detailsText.append("<tr><td><b>Cause</b></td></tr>");
                }
                detailsText.append("<tr><td>").append(cause.getMessage()).append("</td></tr>");
                firstCause = false;
            }
            detailsText.append("</table>");
        } else {
            boolean firstCause = true;
            for (Throwable cause = throwable; cause != null && cause.getMessage() != null; cause = cause.getCause()) {
                if (firstCause) {
                    detailsText.append("<tr><td><b>Cause</b></td></tr>");
                }
                detailsText.append("<tr><td>").append(cause.getMessage()).append("</td></tr>");
                firstCause = false;
            }
        }
        if (detailsText.length() > 0) {
            detailsText.insert(0, "<html>");
            detailsText.append("</html>");
        }
        return detailsText.toString();
    }

    public static void showDialog(Frame ownerFrame, HyperlinkActivatedListener hyperlinkListener, Properties applicationProperties, String message, Throwable throwable) {
        log.warn((Object)("Showing ErrorDialog: message=" + message), throwable);
        ErrorDialog dialog = new ErrorDialog(ownerFrame, hyperlinkListener, applicationProperties);
        dialog.initGui(message, dialog.buildDetailedText(throwable));
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void showDialog(JDialog ownerDialog, HyperlinkActivatedListener hyperlinkListener, Properties applicationProperties, String message, Throwable throwable) {
        ErrorDialog dialog = new ErrorDialog(ownerDialog, hyperlinkListener, applicationProperties);
        dialog.initGui(message, dialog.buildDetailedText(throwable));
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void showDialog(Frame ownerFrame, HyperlinkActivatedListener hyperlinkListener, String message, Throwable throwable) {
        ErrorDialog.showDialog(ownerFrame, hyperlinkListener, null, message, throwable);
    }

    public static void showDialog(JDialog ownerDialog, HyperlinkActivatedListener hyperlinkListener, String message, Throwable throwable) {
        ErrorDialog.showDialog(ownerDialog, hyperlinkListener, null, message, throwable);
    }
}

