/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.javacc.parser.JavaCCErrors;
import org.javacc.utils.OptionInfo;
import org.javacc.utils.OptionType;

public class Options {
    public static final String NONUSER_OPTION__NAMESPACE_CLOSE = "NAMESPACE_CLOSE";
    public static final String NONUSER_OPTION__HAS_NAMESPACE = "HAS_NAMESPACE";
    public static final String NONUSER_OPTION__NAMESPACE_OPEN = "NAMESPACE_OPEN";
    public static final String NONUSER_OPTION__PARSER_NAME = "PARSER_NAME";
    public static final String NONUSER_OPTION__LEGACY_EXCEPTION_HANDLING = "LEGACY_EXCEPTION_HANDLING";
    public static final String USEROPTION__JAVA_TEMPLATE_TYPE = "JAVA_TEMPLATE_TYPE";
    public static final String USEROPTION__GENERATE_BOILERPLATE = "GENERATE_BOILERPLATE";
    public static final String USEROPTION__OUTPUT_LANGUAGE = "OUTPUT_LANGUAGE";
    public static final String USEROPTION__PARSER_CODE_GENERATOR = "PARSER_CODE_GENERATOR";
    public static final String USEROPTION__TOKEN_MANAGER_CODE_GENERATOR = "TOKEN_MANAGER_CODE_GENERATOR";
    public static final String USEROPTION__NO_DFA = "NO_DFA";
    public static final String USEROPTION__STATIC = "STATIC";
    public static final String USEROPTION__LOOKAHEAD = "LOOKAHEAD";
    public static final String USEROPTION__IGNORE_CASE = "IGNORE_CASE";
    public static final String USEROPTION__UNICODE_INPUT = "UNICODE_INPUT";
    public static final String USEROPTION__JAVA_UNICODE_ESCAPE = "JAVA_UNICODE_ESCAPE";
    public static final String USEROPTION__ERROR_REPORTING = "ERROR_REPORTING";
    public static final String USEROPTION__DEBUG_TOKEN_MANAGER = "DEBUG_TOKEN_MANAGER";
    public static final String USEROPTION__DEBUG_LOOKAHEAD = "DEBUG_LOOKAHEAD";
    public static final String USEROPTION__DEBUG_PARSER = "DEBUG_PARSER";
    public static final String USEROPTION__OTHER_AMBIGUITY_CHECK = "OTHER_AMBIGUITY_CHECK";
    public static final String USEROPTION__CHOICE_AMBIGUITY_CHECK = "CHOICE_AMBIGUITY_CHECK";
    public static final String USEROPTION__CACHE_TOKENS = "CACHE_TOKENS";
    public static final String USEROPTION__COMMON_TOKEN_ACTION = "COMMON_TOKEN_ACTION";
    public static final String USEROPTION__FORCE_LA_CHECK = "FORCE_LA_CHECK";
    public static final String USEROPTION__SANITY_CHECK = "SANITY_CHECK";
    public static final String USEROPTION__BUILD_TOKEN_MANAGER = "BUILD_TOKEN_MANAGER";
    public static final String USEROPTION__BUILD_PARSER = "BUILD_PARSER";
    public static final String USEROPTION__USER_CHAR_STREAM = "USER_CHAR_STREAM";
    public static final String USEROPTION__USER_TOKEN_MANAGER = "USER_TOKEN_MANAGER";
    public static final String USEROPTION__JDK_VERSION = "JDK_VERSION";
    public static final String USEROPTION__SUPPORT_CLASS_VISIBILITY_PUBLIC = "SUPPORT_CLASS_VISIBILITY_PUBLIC";
    public static final String USEROPTION__GENERATE_ANNOTATIONS = "GENERATE_ANNOTATIONS";
    public static final String USEROPTION__GENERATE_STRING_BUILDER = "GENERATE_STRING_BUILDER";
    public static final String USEROPTION__GENERATE_GENERICS = "GENERATE_GENERICS";
    public static final String USEROPTION__GENERATE_CHAINED_EXCEPTION = "GENERATE_CHAINED_EXCEPTION";
    public static final String USEROPTION__OUTPUT_DIRECTORY = "OUTPUT_DIRECTORY";
    public static final String USEROPTION__KEEP_LINE_COLUMN = "KEEP_LINE_COLUMN";
    public static final String USEROPTION__GRAMMAR_ENCODING = "GRAMMAR_ENCODING";
    public static final String USEROPTION__TOKEN_FACTORY = "TOKEN_FACTORY";
    public static final String USEROPTION__TOKEN_EXTENDS = "TOKEN_EXTENDS";
    public static final String USEROPTION__DEPTH_LIMIT = "DEPTH_LIMIT";
    public static final String USEROPTION__TOKEN_MANAGER_USES_PARSER = "TOKEN_MANAGER_USES_PARSER";
    public static final String USEROPTION__TOKEN_SUPER_CLASS = "TOKEN_SUPER_CLASS";
    public static final String USEROPTION__PARSER_SUPER_CLASS = "PARSER_SUPER_CLASS";
    public static final String USEROPTION__TOKEN_MANAGER_SUPER_CLASS = "TOKEN_MANAGER_SUPER_CLASS";
    public static final String USEROPTION__CPP_NAMESPACE = "NAMESPACE";
    public static final String USEROPTION__CPP_IGNORE_ACTIONS = "IGNORE_ACTIONS";
    public static final String USEROPTION__CPP_STOP_ON_FIRST_ERROR = "STOP_ON_FIRST_ERROR";
    public static final String USEROPTION__CPP_STACK_LIMIT = "STACK_LIMIT";
    public static final String USEROPTION__CPP_TOKEN_INCLUDE = "TOKEN_INCLUDE";
    public static final String USEROPTION__CPP_PARSER_INCLUDE = "PARSER_INCLUDE";
    public static final String USEROPTION__CPP_TOKEN_MANAGER_INCLUDE = "TOKEN_MANAGER_INCLUDE";
    public static final String OUTPUT_LANGUAGE__CPP = "c++";
    public static final String OUTPUT_LANGUAGE__JAVA = "java";
    public static Language language = Language.java;
    public static final String JAVA_TEMPLATE_TYPE_MODERN = "modern";
    public static final String JAVA_TEMPLATE_TYPE_CLASSIC = "classic";
    static final Set<OptionInfo> userOptions;
    protected static Map<String, Object> optionValues;
    private static Set<String> cmdLineSetting;
    private static Set<String> inputFileSetting;
    private static final Set<String> supportedJavaTemplateTypes;
    private static final Set<String> supportedLanguages;

    protected Options() {
    }

    public static void init() {
        optionValues = new HashMap<String, Object>();
        cmdLineSetting = new HashSet<String>();
        inputFileSetting = new HashSet<String>();
        for (OptionInfo t : userOptions) {
            optionValues.put(t.getName(), t.getDefault());
        }
        Object object = optionValues.get(USEROPTION__JAVA_TEMPLATE_TYPE);
        boolean isLegacy = JAVA_TEMPLATE_TYPE_CLASSIC.equals(object);
        optionValues.put(NONUSER_OPTION__LEGACY_EXCEPTION_HANDLING, isLegacy);
    }

    public static int intValue(String option) {
        return (Integer)optionValues.get(option);
    }

    public static boolean booleanValue(String option) {
        return (Boolean)optionValues.get(option);
    }

    public static String stringValue(String option) {
        return (String)optionValues.get(option);
    }

    public static Object objectValue(String option) {
        return optionValues.get(option);
    }

    public static Map<String, Object> getOptions() {
        HashMap<String, Object> ret = new HashMap<String, Object>(optionValues);
        return ret;
    }

    public static String getOptionsString(String[] interestingOptions) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < interestingOptions.length; ++i) {
            String key = interestingOptions[i];
            sb.append(key);
            sb.append('=');
            sb.append(optionValues.get(key));
            if (i == interestingOptions.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static String getTokenMgrErrorClass() {
        return Options.isOutputLanguageJava() ? (Options.isLegacyExceptionHandling() ? "TokenMgrError" : "TokenMgrException") : "TokenMgrError";
    }

    public static boolean isOption(String opt) {
        return opt != null && opt.length() > 1 && opt.charAt(0) == '-';
    }

    public static Object upgradeValue(String name, Object value) {
        if (name.equalsIgnoreCase("NODE_FACTORY") && value.getClass() == Boolean.class) {
            value = (Boolean)value != false ? "*" : "";
        }
        return value;
    }

    public static void setInputFileOption(Object nameloc, Object valueloc, String name, Object value) {
        String nameUpperCase = name.toUpperCase();
        if (!optionValues.containsKey(nameUpperCase)) {
            JavaCCErrors.warning(nameloc, "Bad option name \"" + name + "\".  Option setting will be ignored.");
            return;
        }
        Object existingValue = optionValues.get(nameUpperCase);
        value = Options.upgradeValue(name, value);
        if (existingValue != null) {
            boolean isValidInteger;
            boolean isIndirectProperty = nameUpperCase.equalsIgnoreCase(NONUSER_OPTION__LEGACY_EXCEPTION_HANDLING);
            Object object = null;
            object = value instanceof List ? ((List)value).get(0) : value;
            boolean bl = isValidInteger = object instanceof Integer && (Integer)value <= 0;
            if (isIndirectProperty || existingValue.getClass() != object.getClass() || isValidInteger) {
                JavaCCErrors.warning(valueloc, "Bad option value \"" + value + "\" for \"" + name + "\".  Option setting will be ignored.");
                return;
            }
            if (inputFileSetting.contains(nameUpperCase)) {
                JavaCCErrors.warning(nameloc, "Duplicate option setting for \"" + name + "\" will be ignored.");
                return;
            }
            if (cmdLineSetting.contains(nameUpperCase)) {
                if (!existingValue.equals(value)) {
                    JavaCCErrors.warning(nameloc, "Command line setting of \"" + name + "\" modifies option value in file.");
                }
                return;
            }
        }
        optionValues.put(nameUpperCase, value);
        inputFileSetting.add(nameUpperCase);
        if (nameUpperCase.equalsIgnoreCase(USEROPTION__JAVA_TEMPLATE_TYPE)) {
            String templateType = (String)value;
            if (!Options.isValidJavaTemplateType(templateType)) {
                JavaCCErrors.warning(valueloc, "Bad option value \"" + value + "\" for \"" + name + "\".  Option setting will be ignored. Valid options : " + Options.getAllValidJavaTemplateTypes());
                return;
            }
            boolean isLegacy = JAVA_TEMPLATE_TYPE_CLASSIC.equals(templateType);
            optionValues.put(NONUSER_OPTION__LEGACY_EXCEPTION_HANDLING, isLegacy);
        } else if (nameUpperCase.equalsIgnoreCase(USEROPTION__OUTPUT_LANGUAGE)) {
            String outputLanguage = (String)value;
            if (!Options.isValidOutputLanguage(outputLanguage)) {
                JavaCCErrors.warning(valueloc, "Bad option value \"" + value + "\" for \"" + name + "\".  Option setting will be ignored. Valid options : " + Options.getAllValidLanguages());
                return;
            }
            if (Options.isOutputLanguageJava()) {
                language = Language.java;
            } else if (Options.isOutputLanguageCpp()) {
                language = Language.cpp;
            }
        } else if (nameUpperCase.equalsIgnoreCase(USEROPTION__CPP_NAMESPACE)) {
            Options.processCPPNamespaceOption((String)value);
        }
    }

    private static String getAllValidJavaTemplateTypes() {
        return Arrays.toString(supportedJavaTemplateTypes.toArray(new String[supportedJavaTemplateTypes.size()]));
    }

    private static String getAllValidLanguages() {
        return Arrays.toString(supportedLanguages.toArray(new String[supportedLanguages.size()]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setCmdLineOption(String arg) {
        Object Val;
        String name;
        block15: {
            int index;
            String s;
            block16: {
                s = arg.charAt(0) == '-' ? arg.substring(1) : arg;
                int index1 = s.indexOf(61);
                int index2 = s.indexOf(58);
                index = index1 < 0 ? index2 : (index2 < 0 ? index1 : (index1 < index2 ? index1 : index2));
                if (index >= 0) break block16;
                name = s.toUpperCase();
                if (optionValues.containsKey(name)) {
                    Val = Boolean.TRUE;
                    break block15;
                } else if (name.length() > 2 && name.charAt(0) == 'N' && name.charAt(1) == 'O') {
                    Val = Boolean.FALSE;
                    name = name.substring(2);
                    break block15;
                } else {
                    System.out.println("Warning: Bad option \"" + arg + "\" will be ignored.");
                    return;
                }
            }
            name = s.substring(0, index).toUpperCase();
            if (s.substring(index + 1).equalsIgnoreCase("TRUE")) {
                Val = Boolean.TRUE;
            } else if (s.substring(index + 1).equalsIgnoreCase("FALSE")) {
                Val = Boolean.FALSE;
            } else {
                try {
                    int i = Integer.parseInt(s.substring(index + 1));
                    if (i <= 0) {
                        System.out.println("Warning: Bad option value in \"" + arg + "\" will be ignored.");
                        return;
                    }
                    Val = i;
                }
                catch (NumberFormatException e) {
                    Val = s.substring(index + 1);
                    if (s.length() <= index + 2 || s.charAt(index + 1) != '\"' || s.charAt(s.length() - 1) != '\"') break block15;
                    Val = s.substring(index + 2, s.length() - 1);
                }
            }
        }
        if (!optionValues.containsKey(name)) {
            System.out.println("Warning: Bad option \"" + arg + "\" will be ignored.");
            return;
        }
        Object valOrig = optionValues.get(name);
        if (Val.getClass() != valOrig.getClass()) {
            System.out.println("Warning: Bad option value in \"" + arg + "\" will be ignored.");
            return;
        }
        if (cmdLineSetting.contains(name)) {
            System.out.println("Warning: Duplicate option setting \"" + arg + "\" will be ignored.");
            return;
        }
        Val = Options.upgradeValue(name, Val);
        optionValues.put(name, Val);
        cmdLineSetting.add(name);
        if (name.equalsIgnoreCase(USEROPTION__CPP_NAMESPACE)) {
            Options.processCPPNamespaceOption((String)Val);
        }
    }

    public static void normalize() {
        if (Options.getDebugLookahead() && !Options.getDebugParser()) {
            if (cmdLineSetting.contains(USEROPTION__DEBUG_PARSER) || inputFileSetting.contains(USEROPTION__DEBUG_PARSER)) {
                JavaCCErrors.warning("True setting of option DEBUG_LOOKAHEAD overrides false setting of option DEBUG_PARSER.");
            }
            optionValues.put(USEROPTION__DEBUG_PARSER, Boolean.TRUE);
        }
        optionValues.put(USEROPTION__GENERATE_CHAINED_EXCEPTION, Options.jdkVersionAtLeast(1.4));
        optionValues.put(USEROPTION__GENERATE_GENERICS, Options.jdkVersionAtLeast(1.5));
        optionValues.put(USEROPTION__GENERATE_STRING_BUILDER, Options.jdkVersionAtLeast(1.5));
        optionValues.put(USEROPTION__GENERATE_ANNOTATIONS, Options.jdkVersionAtLeast(1.5));
    }

    public static int getLookahead() {
        return Options.intValue(USEROPTION__LOOKAHEAD);
    }

    public static int getChoiceAmbiguityCheck() {
        return Options.intValue(USEROPTION__CHOICE_AMBIGUITY_CHECK);
    }

    public static int getOtherAmbiguityCheck() {
        return Options.intValue(USEROPTION__OTHER_AMBIGUITY_CHECK);
    }

    public static boolean getStatic() {
        return Options.booleanValue(USEROPTION__STATIC);
    }

    public static String getParserCodeGenerator() {
        String retVal = Options.stringValue(USEROPTION__PARSER_CODE_GENERATOR);
        return retVal.equals("") ? null : retVal;
    }

    public static String getTokenManagerCodeGenerator() {
        String retVal = Options.stringValue(USEROPTION__TOKEN_MANAGER_CODE_GENERATOR);
        return retVal.equals("") ? null : retVal;
    }

    public static boolean getNoDfa() {
        return Options.booleanValue(USEROPTION__NO_DFA);
    }

    public static boolean getDebugParser() {
        return Options.booleanValue(USEROPTION__DEBUG_PARSER);
    }

    public static boolean getDebugLookahead() {
        return Options.booleanValue(USEROPTION__DEBUG_LOOKAHEAD);
    }

    public static boolean getDebugTokenManager() {
        return Options.booleanValue(USEROPTION__DEBUG_TOKEN_MANAGER);
    }

    public static boolean getErrorReporting() {
        return Options.booleanValue(USEROPTION__ERROR_REPORTING);
    }

    public static boolean getJavaUnicodeEscape() {
        return Options.booleanValue(USEROPTION__JAVA_UNICODE_ESCAPE);
    }

    public static boolean getUnicodeInput() {
        return Options.booleanValue(USEROPTION__UNICODE_INPUT);
    }

    public static boolean getIgnoreCase() {
        return Options.booleanValue(USEROPTION__IGNORE_CASE);
    }

    public static boolean getUserTokenManager() {
        return Options.booleanValue(USEROPTION__USER_TOKEN_MANAGER);
    }

    public static boolean getUserCharStream() {
        return Options.booleanValue(USEROPTION__USER_CHAR_STREAM);
    }

    public static boolean getBuildParser() {
        return Options.booleanValue(USEROPTION__BUILD_PARSER);
    }

    public static boolean getBuildTokenManager() {
        return Options.booleanValue(USEROPTION__BUILD_TOKEN_MANAGER);
    }

    public static boolean getTokenManagerUsesParser() {
        return Options.booleanValue(USEROPTION__TOKEN_MANAGER_USES_PARSER) && !Options.getStatic();
    }

    public static boolean getSanityCheck() {
        return Options.booleanValue(USEROPTION__SANITY_CHECK);
    }

    public static boolean getForceLaCheck() {
        return Options.booleanValue(USEROPTION__FORCE_LA_CHECK);
    }

    public static boolean getCommonTokenAction() {
        return Options.booleanValue(USEROPTION__COMMON_TOKEN_ACTION);
    }

    public static boolean getCacheTokens() {
        return Options.booleanValue(USEROPTION__CACHE_TOKENS);
    }

    public static boolean getKeepLineColumn() {
        return Options.booleanValue(USEROPTION__KEEP_LINE_COLUMN);
    }

    public static String getJdkVersion() {
        return Options.stringValue(USEROPTION__JDK_VERSION);
    }

    public static boolean getGenerateChainedException() {
        return Options.booleanValue(USEROPTION__GENERATE_CHAINED_EXCEPTION);
    }

    public static boolean isGenerateBoilerplateCode() {
        return Options.booleanValue(USEROPTION__GENERATE_BOILERPLATE);
    }

    public static boolean isLegacyExceptionHandling() {
        boolean booleanValue = Options.booleanValue(NONUSER_OPTION__LEGACY_EXCEPTION_HANDLING);
        return booleanValue;
    }

    public static boolean getGenerateGenerics() {
        return Options.booleanValue(USEROPTION__GENERATE_GENERICS);
    }

    public static boolean getGenerateStringBuilder() {
        return Options.booleanValue(USEROPTION__GENERATE_STRING_BUILDER);
    }

    public static boolean getGenerateAnnotations() {
        return Options.booleanValue(USEROPTION__GENERATE_ANNOTATIONS);
    }

    public static boolean getSupportClassVisibilityPublic() {
        return Options.booleanValue(USEROPTION__SUPPORT_CLASS_VISIBILITY_PUBLIC);
    }

    public static boolean jdkVersionAtLeast(double version) {
        double jdkVersion = Double.parseDouble(Options.getJdkVersion());
        return jdkVersion >= version;
    }

    public static String getTokenExtends() {
        return Options.stringValue(USEROPTION__TOKEN_EXTENDS);
    }

    public static String getTokenFactory() {
        return Options.stringValue(USEROPTION__TOKEN_FACTORY);
    }

    public static String getGrammarEncoding() {
        if (Options.stringValue(USEROPTION__GRAMMAR_ENCODING).equals("")) {
            return System.getProperties().getProperty("file.encoding");
        }
        return Options.stringValue(USEROPTION__GRAMMAR_ENCODING);
    }

    public static File getOutputDirectory() {
        return new File(Options.stringValue(USEROPTION__OUTPUT_DIRECTORY));
    }

    public static String stringBufOrBuild() {
        if (Options.isOutputLanguageJava() && Options.getGenerateStringBuilder()) {
            return Options.getGenerateStringBuilder() ? "StringBuilder" : "StringBuffer";
        }
        if (Options.getOutputLanguage().equals(OUTPUT_LANGUAGE__CPP)) {
            return "StringBuffer";
        }
        throw new RuntimeException("Output language type not fully implemented : " + Options.getOutputLanguage());
    }

    public static boolean isValidOutputLanguage(String language) {
        return language == null ? false : supportedLanguages.contains(language.toLowerCase(Locale.ENGLISH));
    }

    public static boolean isValidJavaTemplateType(String type) {
        return type == null ? false : supportedJavaTemplateTypes.contains(type.toLowerCase(Locale.ENGLISH));
    }

    public static String getOutputLanguage() {
        return Options.stringValue(USEROPTION__OUTPUT_LANGUAGE);
    }

    public static String getJavaTemplateType() {
        return Options.stringValue(USEROPTION__JAVA_TEMPLATE_TYPE);
    }

    public static void setStringOption(String optionName, String optionValue) {
        optionValues.put(optionName, optionValue);
        if (optionName.equalsIgnoreCase(USEROPTION__CPP_NAMESPACE)) {
            Options.processCPPNamespaceOption(optionValue);
        }
    }

    public static void processCPPNamespaceOption(String optionValue) {
        String ns = optionValue;
        if (ns.length() > 0) {
            StringTokenizer st = new StringTokenizer(ns, "::");
            String expanded_ns = st.nextToken() + " {";
            String ns_close = "}";
            while (st.hasMoreTokens()) {
                expanded_ns = expanded_ns + "\nnamespace " + st.nextToken() + " {";
                ns_close = ns_close + "\n}";
            }
            optionValues.put(NONUSER_OPTION__NAMESPACE_OPEN, expanded_ns);
            optionValues.put(NONUSER_OPTION__HAS_NAMESPACE, Boolean.TRUE);
            optionValues.put(NONUSER_OPTION__NAMESPACE_CLOSE, ns_close);
        }
    }

    public static String getLongType() {
        if (Options.isOutputLanguageJava()) {
            return "long";
        }
        if (Options.getOutputLanguage().equals(OUTPUT_LANGUAGE__CPP)) {
            return "unsigned long long";
        }
        throw new RuntimeException("Language type not fully supported : " + Options.getOutputLanguage());
    }

    public static String getBooleanType() {
        if (Options.isOutputLanguageJava()) {
            return "boolean";
        }
        if (Options.getOutputLanguage().equals(OUTPUT_LANGUAGE__CPP)) {
            return "bool";
        }
        throw new RuntimeException("Language type not fully supported : " + Options.getOutputLanguage());
    }

    public static boolean isOutputLanguageJava() {
        return Options.getOutputLanguage().equalsIgnoreCase(OUTPUT_LANGUAGE__JAVA);
    }

    public static boolean isOutputLanguageCpp() {
        return Options.getOutputLanguage().equalsIgnoreCase(OUTPUT_LANGUAGE__CPP);
    }

    public static boolean isTokenManagerRequiresParserAccess() {
        return Options.getTokenManagerUsesParser() && !Options.getStatic();
    }

    public static int getDepthLimit() {
        return Options.intValue(USEROPTION__DEPTH_LIMIT);
    }

    public static String getStackLimit() {
        String limit = Options.stringValue(USEROPTION__CPP_STACK_LIMIT);
        if (limit.equals("0")) {
            return "";
        }
        return limit;
    }

    public static Set<OptionInfo> getUserOptions() {
        return userOptions;
    }

    static {
        TreeSet<OptionInfo> temp = new TreeSet<OptionInfo>();
        temp.add(new OptionInfo(USEROPTION__LOOKAHEAD, OptionType.INTEGER, 1));
        temp.add(new OptionInfo(USEROPTION__CHOICE_AMBIGUITY_CHECK, OptionType.INTEGER, 2));
        temp.add(new OptionInfo(USEROPTION__OTHER_AMBIGUITY_CHECK, OptionType.INTEGER, 1));
        temp.add(new OptionInfo(USEROPTION__STATIC, OptionType.BOOLEAN, Boolean.TRUE));
        temp.add(new OptionInfo(USEROPTION__PARSER_CODE_GENERATOR, OptionType.STRING, ""));
        temp.add(new OptionInfo(USEROPTION__TOKEN_MANAGER_CODE_GENERATOR, OptionType.STRING, ""));
        temp.add(new OptionInfo(USEROPTION__NO_DFA, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__DEBUG_PARSER, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__DEBUG_LOOKAHEAD, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__DEBUG_TOKEN_MANAGER, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__ERROR_REPORTING, OptionType.BOOLEAN, Boolean.TRUE));
        temp.add(new OptionInfo(USEROPTION__JAVA_UNICODE_ESCAPE, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__UNICODE_INPUT, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__IGNORE_CASE, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__USER_TOKEN_MANAGER, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__USER_CHAR_STREAM, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__BUILD_PARSER, OptionType.BOOLEAN, Boolean.TRUE));
        temp.add(new OptionInfo(USEROPTION__BUILD_TOKEN_MANAGER, OptionType.BOOLEAN, Boolean.TRUE));
        temp.add(new OptionInfo(USEROPTION__TOKEN_MANAGER_USES_PARSER, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__SANITY_CHECK, OptionType.BOOLEAN, Boolean.TRUE));
        temp.add(new OptionInfo(USEROPTION__FORCE_LA_CHECK, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__COMMON_TOKEN_ACTION, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__CACHE_TOKENS, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__KEEP_LINE_COLUMN, OptionType.BOOLEAN, Boolean.TRUE));
        temp.add(new OptionInfo(USEROPTION__GENERATE_CHAINED_EXCEPTION, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__GENERATE_GENERICS, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__GENERATE_BOILERPLATE, OptionType.BOOLEAN, Boolean.TRUE));
        temp.add(new OptionInfo(USEROPTION__GENERATE_STRING_BUILDER, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__GENERATE_ANNOTATIONS, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__SUPPORT_CLASS_VISIBILITY_PUBLIC, OptionType.BOOLEAN, Boolean.TRUE));
        temp.add(new OptionInfo(USEROPTION__OUTPUT_DIRECTORY, OptionType.STRING, "."));
        temp.add(new OptionInfo(USEROPTION__JDK_VERSION, OptionType.STRING, "1.5"));
        temp.add(new OptionInfo(USEROPTION__TOKEN_FACTORY, OptionType.STRING, ""));
        temp.add(new OptionInfo(USEROPTION__TOKEN_EXTENDS, OptionType.STRING, ""));
        temp.add(new OptionInfo(USEROPTION__GRAMMAR_ENCODING, OptionType.STRING, ""));
        temp.add(new OptionInfo(USEROPTION__OUTPUT_LANGUAGE, OptionType.STRING, OUTPUT_LANGUAGE__JAVA));
        language = Language.java;
        temp.add(new OptionInfo(USEROPTION__JAVA_TEMPLATE_TYPE, OptionType.STRING, JAVA_TEMPLATE_TYPE_CLASSIC));
        temp.add(new OptionInfo(USEROPTION__CPP_NAMESPACE, OptionType.STRING, ""));
        temp.add(new OptionInfo(USEROPTION__TOKEN_SUPER_CLASS, OptionType.STRING, null));
        temp.add(new OptionInfo(USEROPTION__PARSER_SUPER_CLASS, OptionType.STRING, null));
        temp.add(new OptionInfo(USEROPTION__TOKEN_MANAGER_SUPER_CLASS, OptionType.STRING, null));
        temp.add(new OptionInfo(USEROPTION__CPP_TOKEN_INCLUDE, OptionType.STRING, ""));
        temp.add(new OptionInfo(USEROPTION__CPP_PARSER_INCLUDE, OptionType.STRING, ""));
        temp.add(new OptionInfo(USEROPTION__CPP_TOKEN_MANAGER_INCLUDE, OptionType.STRING, ""));
        temp.add(new OptionInfo(USEROPTION__CPP_IGNORE_ACTIONS, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__CPP_STOP_ON_FIRST_ERROR, OptionType.BOOLEAN, Boolean.FALSE));
        temp.add(new OptionInfo(USEROPTION__DEPTH_LIMIT, OptionType.INTEGER, 0));
        temp.add(new OptionInfo(USEROPTION__CPP_STACK_LIMIT, OptionType.STRING, ""));
        userOptions = Collections.unmodifiableSet(temp);
        optionValues = null;
        cmdLineSetting = null;
        inputFileSetting = null;
        supportedJavaTemplateTypes = new HashSet<String>();
        supportedJavaTemplateTypes.add(JAVA_TEMPLATE_TYPE_CLASSIC);
        supportedJavaTemplateTypes.add(JAVA_TEMPLATE_TYPE_MODERN);
        supportedLanguages = new HashSet<String>();
        supportedLanguages.add(OUTPUT_LANGUAGE__JAVA);
        supportedLanguages.add(OUTPUT_LANGUAGE__CPP);
    }

    public static enum Language {
        java,
        cpp;

    }
}

