/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.javacc.parser.JavaCCErrors;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.Options;
import org.javacc.parser.Token;
import org.javacc.utils.OutputFileGenerator;

public class CodeGenerator {
    protected StringBuffer mainBuffer = new StringBuffer();
    protected StringBuffer includeBuffer = new StringBuffer();
    protected StringBuffer staticsBuffer = new StringBuffer();
    protected StringBuffer outputBuffer = this.mainBuffer;
    protected int cline;
    protected int ccol;

    public void genStringLiteralArrayCPP(String varName, String[] arr) {
        int i;
        for (i = 0; i < arr.length; ++i) {
            this.genCodeLine("static const JJChar " + varName + "_arr_" + i + "[] = ");
            this.genStringLiteralInCPP(arr[i]);
            this.genCodeLine(";");
        }
        this.genCodeLine("static const JJString " + varName + "[] = {");
        for (i = 0; i < arr.length; ++i) {
            this.genCodeLine(varName + "_arr_" + i + ", ");
        }
        this.genCodeLine("};");
    }

    public void genStringLiteralInCPP(String s) {
        this.outputBuffer.append("{");
        for (int i = 0; i < s.length(); ++i) {
            this.outputBuffer.append("0x" + Integer.toHexString(s.charAt(i)) + ", ");
        }
        this.outputBuffer.append("0}");
    }

    public void genCodeLine(Object ... code) {
        this.genCode(code);
        this.genCode("\n");
    }

    public void genCode(Object ... code) {
        for (Object s : code) {
            this.outputBuffer.append(s);
        }
    }

    public void saveOutput(String fileName) {
        if (!this.isJavaLanguage()) {
            String incfilePath = fileName.replace(".cc", ".h");
            String incfileName = new File(incfilePath).getName();
            this.includeBuffer.insert(0, "#define " + incfileName.replace('.', '_').toUpperCase() + "\n");
            this.includeBuffer.insert(0, "#ifndef " + incfileName.replace('.', '_').toUpperCase() + "\n");
            this.mainBuffer.insert(0, this.staticsBuffer);
            if (Options.stringValue("NAMESPACE").length() > 0) {
                this.mainBuffer.insert(0, "namespace " + Options.stringValue("NAMESPACE_OPEN") + "\n");
                this.mainBuffer.append(Options.stringValue("NAMESPACE_CLOSE") + "\n");
                this.includeBuffer.append(Options.stringValue("NAMESPACE_CLOSE") + "\n");
            }
            if (JavaCCGlobals.jjtreeGenerated) {
                this.mainBuffer.insert(0, "#include \"SimpleNode.h\"\n");
            }
            if (Options.getTokenManagerUsesParser()) {
                this.mainBuffer.insert(0, "#include \"" + JavaCCGlobals.cu_name + ".h\"\n");
            }
            this.mainBuffer.insert(0, "#include \"TokenMgrError.h\"\n");
            this.mainBuffer.insert(0, "#include \"" + incfileName + "\"\n");
            this.includeBuffer.append("#endif\n");
            this.saveOutput(incfilePath, this.includeBuffer);
        }
        this.mainBuffer.insert(0, "/* " + new File(fileName).getName() + " */\n");
        this.saveOutput(fileName, this.mainBuffer);
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private void fixupLongLiterals(StringBuffer sb) {
        for (int i = 0; i < sb.length() - 1; ++i) {
            int beg = i;
            char c1 = sb.charAt(i);
            char c2 = sb.charAt(i + 1);
            if (!Character.isDigit(c1) && (c1 != '0' || c2 != 'x')) continue;
            i += c1 == '0' ? 2 : 1;
            while (CodeGenerator.isHexDigit(sb.charAt(i))) {
                ++i;
            }
            if (sb.charAt(i) == 'L') {
                sb.insert(i, "UL");
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOutput(String fileName, StringBuffer sb) {
        PrintWriter fw = null;
        if (!this.isJavaLanguage()) {
            this.fixupLongLiterals(sb);
        }
        try {
            File tmp = new File(fileName);
            fw = new PrintWriter(new BufferedWriter(new FileWriter(tmp), 8092));
            fw.print(sb.toString());
        }
        catch (IOException ioe) {
            JavaCCErrors.fatal("Could not create output file: " + fileName);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    protected void printTokenSetup(Token t) {
        Token tt = t;
        while (tt.specialToken != null) {
            tt = tt.specialToken;
        }
        this.cline = tt.beginLine;
        this.ccol = tt.beginColumn;
    }

    protected void printTokenList(List<Token> list) {
        Token t2 = null;
        for (Token t2 : list) {
            this.printToken(t2);
        }
        if (t2 != null) {
            this.printTrailingComments(t2);
        }
    }

    protected void printTokenOnly(Token t) {
        this.genCode(this.getStringForTokenOnly(t));
    }

    protected String getStringForTokenOnly(Token t) {
        char last;
        String retval = "";
        while (this.cline < t.beginLine) {
            retval = retval + "\n";
            this.ccol = 1;
            ++this.cline;
        }
        while (this.ccol < t.beginColumn) {
            retval = retval + " ";
            ++this.ccol;
        }
        retval = t.kind == 94 || t.kind == 93 ? retval + JavaCCGlobals.addUnicodeEscapes(t.image) : retval + t.image;
        this.cline = t.endLine;
        this.ccol = t.endColumn + 1;
        if (t.image.length() > 0 && ((last = t.image.charAt(t.image.length() - 1)) == '\n' || last == '\r')) {
            ++this.cline;
            this.ccol = 1;
        }
        return retval;
    }

    protected void printToken(Token t) {
        this.genCode(this.getStringToPrint(t));
    }

    protected String getStringToPrint(Token t) {
        String retval = "";
        Token tt = t.specialToken;
        if (tt != null) {
            while (tt.specialToken != null) {
                tt = tt.specialToken;
            }
            while (tt != null) {
                retval = retval + this.getStringForTokenOnly(tt);
                tt = tt.next;
            }
        }
        return retval + this.getStringForTokenOnly(t);
    }

    protected void printLeadingComments(Token t) {
        this.genCode(this.getLeadingComments(t));
    }

    protected String getLeadingComments(Token t) {
        String retval = "";
        if (t.specialToken == null) {
            return retval;
        }
        Token tt = t.specialToken;
        while (tt.specialToken != null) {
            tt = tt.specialToken;
        }
        while (tt != null) {
            retval = retval + this.getStringForTokenOnly(tt);
            tt = tt.next;
        }
        if (this.ccol != 1 && this.cline != t.beginLine) {
            retval = retval + "\n";
            ++this.cline;
            this.ccol = 1;
        }
        return retval;
    }

    protected void printTrailingComments(Token t) {
        this.outputBuffer.append(this.getTrailingComments(t));
    }

    protected String getTrailingComments(Token t) {
        if (t.next == null) {
            return "";
        }
        return this.getLeadingComments(t.next);
    }

    public String getGeneratedCode() {
        return this.outputBuffer.toString() + "\n";
    }

    public void genAnnotation(String ann) {
        if (Options.isOutputLanguageJava()) {
            this.genCode("@" + ann);
        } else if (Options.getOutputLanguage().equals("c++")) {
            this.genCode("/*" + ann + "*/");
        } else {
            throw new RuntimeException("Unknown language : " + Options.getOutputLanguage());
        }
    }

    public void genModifier(String mod) {
        String origMod = mod.toLowerCase(Locale.ENGLISH);
        if (this.isJavaLanguage()) {
            this.genCode(mod);
        } else if (origMod.equals("public") || origMod.equals("private")) {
            this.genCode(origMod + ": ");
        }
    }

    public void genClassStart(String mod, String name, String[] superClasses, String[] superInterfaces) {
        boolean isJavaLanguage = this.isJavaLanguage();
        if (isJavaLanguage && mod != null) {
            this.genModifier(mod);
        }
        this.genCode("class " + name);
        if (isJavaLanguage) {
            if (superClasses.length == 1 && superClasses[0] != null) {
                this.genCode(" extends " + superClasses[0]);
            }
            if (superInterfaces.length != 0) {
                this.genCode(" implements ");
            }
        } else {
            if (superClasses.length > 0 || superInterfaces.length > 0) {
                this.genCode(" : ");
            }
            this.genCommaSeperatedString(superClasses);
        }
        this.genCommaSeperatedString(superInterfaces);
        this.genCodeLine(" {");
        if (Options.getOutputLanguage().equals("c++")) {
            this.genCodeLine("public:");
        }
    }

    private void genCommaSeperatedString(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                this.genCode(", ");
            }
            this.genCode(strings[i]);
        }
    }

    protected boolean isJavaLanguage() {
        return Options.isOutputLanguageJava();
    }

    public void switchToMainFile() {
        this.outputBuffer = this.mainBuffer;
    }

    public void switchToStaticsFile() {
        if (!this.isJavaLanguage()) {
            this.outputBuffer = this.staticsBuffer;
        }
    }

    public void switchToIncludeFile() {
        if (!this.isJavaLanguage()) {
            this.outputBuffer = this.includeBuffer;
        }
    }

    public void generateMethodDefHeader(String modsAndRetType, String className, String nameAndParams) {
        this.generateMethodDefHeader(modsAndRetType, className, nameAndParams, null);
    }

    public void generateMethodDefHeader(String qualifiedModsAndRetType, String className, String nameAndParams, String exceptions) {
        if (this.isJavaLanguage()) {
            this.genCode(qualifiedModsAndRetType + " " + nameAndParams);
            if (exceptions != null) {
                this.genCode(" throws " + exceptions);
            }
            this.genCodeLine("");
        } else {
            this.includeBuffer.append(qualifiedModsAndRetType + " " + nameAndParams);
            this.includeBuffer.append(";\n");
            String modsAndRetType = null;
            int i = qualifiedModsAndRetType.lastIndexOf(58);
            if (i >= 0) {
                modsAndRetType = qualifiedModsAndRetType.substring(i + 1);
            }
            if (modsAndRetType != null && (i = modsAndRetType.lastIndexOf("virtual")) >= 0) {
                modsAndRetType = modsAndRetType.substring(i + "virtual".length());
            }
            if ((i = qualifiedModsAndRetType.lastIndexOf("virtual")) >= 0) {
                qualifiedModsAndRetType = qualifiedModsAndRetType.substring(i + "virtual".length());
            }
            this.mainBuffer.append("\n" + qualifiedModsAndRetType + " " + this.getClassQualifier(className) + nameAndParams);
            this.switchToMainFile();
        }
    }

    protected String getClassQualifier(String className) {
        return className == null ? "" : className + "::";
    }

    public static String getCharStreamName() {
        if (Options.getUserCharStream()) {
            return "CharStream";
        }
        return Options.getJavaUnicodeEscape() ? "JavaCharStream" : "SimpleCharStream";
    }

    protected void writeTemplate(String name, Map<String, Object> options, Object ... additionalOptions) throws IOException {
        for (int i = 0; i < additionalOptions.length; ++i) {
            Object o = additionalOptions[i];
            if (o instanceof Map) {
                options.putAll((Map)o);
                continue;
            }
            if (i == additionalOptions.length - 1) {
                throw new IllegalArgumentException("Must supply pairs of [name value] args");
            }
            options.put((String)o, additionalOptions[i + 1]);
            ++i;
        }
        OutputFileGenerator gen = new OutputFileGenerator(name, options);
        StringWriter sw = new StringWriter();
        gen.generate(new PrintWriter(sw));
        sw.close();
        this.genCode(sw.toString());
    }
}

