/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjdoc;

import java.util.Hashtable;
import org.javacc.jjdoc.JJDoc;
import org.javacc.jjdoc.JJDocGlobals;
import org.javacc.jjdoc.JJDocOptions;
import org.javacc.jjdoc.TextGenerator;
import org.javacc.parser.CppCodeProduction;
import org.javacc.parser.Expansion;
import org.javacc.parser.JavaCodeProduction;
import org.javacc.parser.NonTerminal;
import org.javacc.parser.NormalProduction;
import org.javacc.parser.RegularExpression;
import org.javacc.parser.TokenProduction;

public class HTMLGenerator
extends TextGenerator {
    private Hashtable id_map = new Hashtable();
    private int id = 1;

    protected String get_id(String nt) {
        String i = (String)this.id_map.get(nt);
        if (i == null) {
            i = "prod" + this.id++;
            this.id_map.put(nt, i);
        }
        return i;
    }

    private void println(String s) {
        this.print(s + "\n");
    }

    @Override
    public void text(String s) {
        String ss = "";
        for (int i = 0; i < s.length(); ++i) {
            ss = s.charAt(i) == '<' ? ss + "&lt;" : (s.charAt(i) == '>' ? ss + "&gt;" : (s.charAt(i) == '&' ? ss + "&amp;" : ss + s.charAt(i)));
        }
        this.print(ss);
    }

    @Override
    public void print(String s) {
        this.ostr.print(s);
    }

    @Override
    public void documentStart() {
        this.ostr = this.create_output_stream();
        this.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">");
        this.println("<HTML>");
        this.println("<HEAD>");
        if (!"".equals(JJDocOptions.getCSS())) {
            this.println("<LINK REL=\"stylesheet\" type=\"text/css\" href=\"" + JJDocOptions.getCSS() + "\"/>");
        }
        if (JJDocGlobals.input_file != null) {
            this.println("<TITLE>BNF for " + JJDocGlobals.input_file + "</TITLE>");
        } else {
            this.println("<TITLE>A BNF grammar by JJDoc</TITLE>");
        }
        this.println("</HEAD>");
        this.println("<BODY>");
        this.println("<H1 ALIGN=CENTER>BNF for " + JJDocGlobals.input_file + "</H1>");
    }

    @Override
    public void documentEnd() {
        this.println("</BODY>");
        this.println("</HTML>");
        this.ostr.close();
    }

    @Override
    public void specialTokens(String s) {
        this.println(" <!-- Special token -->");
        this.println(" <TR>");
        this.println("  <TD>");
        this.println("<PRE>");
        this.print(s);
        this.println("</PRE>");
        this.println("  </TD>");
        this.println(" </TR>");
    }

    @Override
    public void handleTokenProduction(TokenProduction tp) {
        this.println(" <!-- Token -->");
        this.println(" <TR>");
        this.println("  <TD>");
        this.println("   <PRE>");
        String text = JJDoc.getStandardTokenProductionText(tp);
        this.text(text);
        this.println("   </PRE>");
        this.println("  </TD>");
        this.println(" </TR>");
    }

    @Override
    public void nonterminalsStart() {
        this.println("<H2 ALIGN=CENTER>NON-TERMINALS</H2>");
        if (JJDocOptions.getOneTable()) {
            this.println("<TABLE>");
        }
    }

    @Override
    public void nonterminalsEnd() {
        if (JJDocOptions.getOneTable()) {
            this.println("</TABLE>");
        }
    }

    @Override
    public void tokensStart() {
        this.println("<H2 ALIGN=CENTER>TOKENS</H2>");
        this.println("<TABLE>");
    }

    @Override
    public void tokensEnd() {
        this.println("</TABLE>");
    }

    @Override
    public void javacode(JavaCodeProduction jp) {
        this.productionStart(jp);
        this.println("<I>java code</I></TD></TR>");
        this.productionEnd(jp);
    }

    @Override
    public void cppcode(CppCodeProduction cp) {
        this.productionStart(cp);
        this.println("<I>cpp code</I></TD></TR>");
        this.productionEnd(cp);
    }

    @Override
    public void productionStart(NormalProduction np) {
        if (!JJDocOptions.getOneTable()) {
            this.println("");
            this.println("<TABLE ALIGN=CENTER>");
            this.println("<CAPTION><STRONG>" + np.getLhs() + "</STRONG></CAPTION>");
        }
        this.println("<TR>");
        this.println("<TD ALIGN=RIGHT VALIGN=BASELINE><A NAME=\"" + this.get_id(np.getLhs()) + "\">" + np.getLhs() + "</A></TD>");
        this.println("<TD ALIGN=CENTER VALIGN=BASELINE>::=</TD>");
        this.print("<TD ALIGN=LEFT VALIGN=BASELINE>");
    }

    @Override
    public void productionEnd(NormalProduction np) {
        if (!JJDocOptions.getOneTable()) {
            this.println("</TABLE>");
            this.println("<HR>");
        }
    }

    @Override
    public void expansionStart(Expansion e, boolean first) {
        if (!first) {
            this.println("<TR>");
            this.println("<TD ALIGN=RIGHT VALIGN=BASELINE></TD>");
            this.println("<TD ALIGN=CENTER VALIGN=BASELINE>|</TD>");
            this.print("<TD ALIGN=LEFT VALIGN=BASELINE>");
        }
    }

    @Override
    public void expansionEnd(Expansion e, boolean first) {
        this.println("</TD>");
        this.println("</TR>");
    }

    @Override
    public void nonTerminalStart(NonTerminal nt) {
        this.print("<A HREF=\"#" + this.get_id(nt.getName()) + "\">");
    }

    @Override
    public void nonTerminalEnd(NonTerminal nt) {
        this.print("</A>");
    }

    @Override
    public void reStart(RegularExpression r) {
    }

    @Override
    public void reEnd(RegularExpression r) {
    }
}

