/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.javase;

import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import net.glxn.qrgen.core.AbstractQRCode;
import net.glxn.qrgen.core.exception.QRGenerationException;
import net.glxn.qrgen.core.vcard.VCard;
import net.glxn.qrgen.javase.MatrixToSvgWriter;

public class QRCode
extends AbstractQRCode {
    protected final String text;

    protected QRCode(String text) {
        this.text = text;
        this.qrWriter = new QRCodeWriter();
    }

    public static QRCode from(String text) {
        return new QRCode(text);
    }

    public static AbstractQRCode from(VCard vcard) {
        return new QRCode(vcard.toString());
    }

    private File svg() {
        File file;
        try {
            file = this.createTempSvgFile();
            MatrixToSvgWriter.writeToPath(this.createMatrix(this.text), file.toPath());
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR svg from text due to underlying exception", (Throwable)e);
        }
        return file;
    }

    private File svg(String name) {
        File file;
        try {
            file = this.createTempSvgFile(name);
            MatrixToSvgWriter.writeToPath(this.createMatrix(this.text), file.toPath());
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR svg from text due to underlying exception", (Throwable)e);
        }
        return file;
    }

    public File file() {
        File file;
        try {
            file = this.createTempFile();
            MatrixToImageWriter.writeToPath((BitMatrix)this.createMatrix(this.text), (String)this.imageType.toString(), (Path)file.toPath());
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", (Throwable)e);
        }
        return file;
    }

    public File file(String name) {
        File file;
        try {
            file = this.createTempFile(name);
            MatrixToImageWriter.writeToPath((BitMatrix)this.createMatrix(this.text), (String)this.imageType.toString(), (Path)file.toPath());
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", (Throwable)e);
        }
        return file;
    }

    protected void writeToStream(OutputStream stream) throws IOException, WriterException {
        MatrixToImageWriter.writeToStream((BitMatrix)this.createMatrix(this.text), (String)this.imageType.toString(), (OutputStream)stream);
    }

    private File createTempSvgFile() throws IOException {
        return this.createTempSvgFile("QRCode");
    }

    private File createTempSvgFile(String name) throws IOException {
        File file = File.createTempFile(name, ".svg");
        file.deleteOnExit();
        return file;
    }
}

